""""""
from requests import get
from requests.models import Response

import logging
from shimoku_api_python.execution_logger import logging_before_and_after
logger = logging.getLogger(__name__)


class PingApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """
    @logging_before_and_after(logging_level=logger.debug)
    def __init__(self, api_client):
        self.api_client = api_client

    @logging_before_and_after(logging_level=logger.debug)
    def __call__(self, *args, **kwargs) -> bool:
        """Check if the API is alive"""
        response: Response = get(url='https://api.shimoku.io/external/v1/status')
        response = response.json()
        try:
            assert response['success'] == 'External API is Up!'
            return True
        except KeyError:
            return False
        except AssertionError:
            return False
