#pragma once
#include <finance-enums/common.hpp>
#include <finance-enums/helpers/enum.hpp>
#include <finance-enums/helpers/exports.hpp>
#include <iostream>
#include <vector>

namespace finance_enums {
// https://en.wikipedia.org/wiki/ISO_4217
static str_t CurrencyStandard = "ISO4217";

str_t inline currency_standard() { return CurrencyStandard; }

enum class LIB_EXPORT Currency {
  AED,
  AFN,
  ALL,
  AMD,
  ANG,
  AOA,
  ARS,
  AUD,
  AWG,
  AZN,
  BAM,
  BBD,
  BDT,
  BGN,
  BHD,
  BIF,
  BMD,
  BND,
  BOB,
  BOV,
  BRL,
  BSD,
  BTN,
  BWP,
  BYN,
  BZD,
  CAD,
  CDF,
  CHE,
  CHF,
  CHW,
  CLF,
  CLP,
  CNY,
  COP,
  COU,
  CRC,
  CUC,
  CUP,
  CVE,
  CZK,
  DJF,
  DKK,
  DOP,
  DZD,
  EGP,
  ERN,
  ETB,
  EUR,
  EUX, // NOTE: non iso
  FJD,
  FKP,
  GBP,
  GBX, // NOTE: non iso
  GEL,
  GHS,
  GIP,
  GMD,
  GNF,
  GTQ,
  GYD,
  HKD,
  HNL,
  HTG,
  HUF,
  IDR,
  ILS,
  INR,
  IQD,
  IRR,
  ISK,
  JMD,
  JOD,
  JPY,
  KES,
  KGS,
  KHR,
  KMF,
  KPW,
  KRW,
  KWD,
  KYD,
  KZT,
  LAK,
  LBP,
  LKR,
  LRD,
  LSL,
  LYD,
  MAD,
  MDL,
  MGA,
  MKD,
  MMK,
  MNT,
  MOP,
  MRU,
  MUR,
  MVR,
  MWK,
  MXN,
  MXV,
  MYR,
  MZN,
  NAD,
  NGN,
  NIO,
  NOK,
  NPR,
  NZD,
  OMR,
  PAB,
  PEN,
  PGK,
  PHP,
  PKR,
  PLN,
  PYG,
  QAR,
  RON,
  RSD,
  RUB,
  RWF,
  SAR,
  SBD,
  SCR,
  SDG,
  SEK,
  SGD,
  SHP,
  SLE,
  SLL,
  SOS,
  SRD,
  SSP,
  STN,
  SVC,
  SYP,
  SZL,
  THB,
  TJS,
  TMT,
  TND,
  TOP,
  TRY,
  TTD,
  TWD,
  TZS,
  UAH,
  UGX,
  USD,
  USN,
  USX, // NOTE: non iso
  UYI,
  UYU,
  UYW,
  UZS,
  VED,
  VES,
  VND,
  VUV,
  WST,
  XAF,
  XAG,
  XAU,
  XBA,
  XBB,
  XBC,
  XBD,
  XCD,
  XDR,
  XOF,
  XPD,
  XPF,
  XPT,
  XSU,
  XTS,
  XUA,
  XXX,
  YER,
  ZAR,
  ZMW,
  ZWL,
};

static const std::vector<str_t> Currency_names = {
  "AED", "AFN", "ALL", "AMD", "ANG", "AOA", "ARS", "AUD", "AWG", "AZN", "BAM", "BBD", "BDT", "BGN", "BHD", "BIF", "BMD",
  "BND", "BOB", "BOV", "BRL", "BSD", "BTN", "BWP", "BYN", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLF", "CLP", "CNY",
  "COP", "COU", "CRC", "CUC", "CUP", "CVE", "CZK", "DJF", "DKK", "DOP", "DZD", "EGP", "ERN", "ETB", "EUR",
  "EUX", // NOTE: non iso
  "FJD", "FKP", "GBP",
  "GBX", // NOTE: non iso
  "GEL", "GHS", "GIP", "GMD", "GNF", "GTQ", "GYD", "HKD", "HNL", "HTG", "HUF", "IDR", "ILS", "INR", "IQD", "IRR", "ISK",
  "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL",
  "LYD", "MAD", "MDL", "MGA", "MKD", "MMK", "MNT", "MOP", "MRU", "MUR", "MVR", "MWK", "MXN", "MXV", "MYR", "MZN", "NAD",
  "NGN", "NIO", "NOK", "NPR", "NZD", "OMR", "PAB", "PEN", "PGK", "PHP", "PKR", "PLN", "PYG", "QAR", "RON", "RSD", "RUB",
  "RWF", "SAR", "SBD", "SCR", "SDG", "SEK", "SGD", "SHP", "SLE", "SLL", "SOS", "SRD", "SSP", "STN", "SVC", "SYP", "SZL",
  "THB", "TJS", "TMT", "TND", "TOP", "TRY", "TTD", "TWD", "TZS", "UAH", "UGX", "USD", "USN",
  "USX", // NOTE: non iso
  "UYI", "UYU", "UYW", "UZS", "VED", "VES", "VND", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD",
  "XDR", "XOF", "XPD", "XPF", "XPT", "XSU", "XTS", "XUA", "XXX", "YER", "ZAR", "ZMW", "ZWL",
};

static std::unordered_map<str_t, Currency> _Currency_mapping = {
  {"AED", Currency::AED},
  {"AFN", Currency::AFN},
  {"ALL", Currency::ALL},
  {"AMD", Currency::AMD},
  {"ANG", Currency::ANG},
  {"AOA", Currency::AOA},
  {"ARS", Currency::ARS},
  {"AUD", Currency::AUD},
  {"AWG", Currency::AWG},
  {"AZN", Currency::AZN},
  {"BAM", Currency::BAM},
  {"BBD", Currency::BBD},
  {"BDT", Currency::BDT},
  {"BGN", Currency::BGN},
  {"BHD", Currency::BHD},
  {"BIF", Currency::BIF},
  {"BMD", Currency::BMD},
  {"BND", Currency::BND},
  {"BOB", Currency::BOB},
  {"BOV", Currency::BOV},
  {"BRL", Currency::BRL},
  {"BSD", Currency::BSD},
  {"BTN", Currency::BTN},
  {"BWP", Currency::BWP},
  {"BYN", Currency::BYN},
  {"BZD", Currency::BZD},
  {"CAD", Currency::CAD},
  {"CDF", Currency::CDF},
  {"CHE", Currency::CHE},
  {"CHF", Currency::CHF},
  {"CHW", Currency::CHW},
  {"CLF", Currency::CLF},
  {"CLP", Currency::CLP},
  {"CNY", Currency::CNY},
  {"COP", Currency::COP},
  {"COU", Currency::COU},
  {"CRC", Currency::CRC},
  {"CUC", Currency::CUC},
  {"CUP", Currency::CUP},
  {"CVE", Currency::CVE},
  {"CZK", Currency::CZK},
  {"DJF", Currency::DJF},
  {"DKK", Currency::DKK},
  {"DOP", Currency::DOP},
  {"DZD", Currency::DZD},
  {"EGP", Currency::EGP},
  {"ERN", Currency::ERN},
  {"ETB", Currency::ETB},
  {"EUR", Currency::EUR},
  {"EUr", Currency::EUX}, // NOTE: non iso
  {"EUX", Currency::EUX}, // NOTE: non iso
  {"FJD", Currency::FJD},
  {"FKP", Currency::FKP},
  {"GBP", Currency::GBP},
  {"GBp", Currency::GBX}, // NOTE: non iso
  {"GBX", Currency::GBX}, // NOTE: non iso
  {"GEL", Currency::GEL},
  {"GHS", Currency::GHS},
  {"GIP", Currency::GIP},
  {"GMD", Currency::GMD},
  {"GNF", Currency::GNF},
  {"GTQ", Currency::GTQ},
  {"GYD", Currency::GYD},
  {"HKD", Currency::HKD},
  {"HNL", Currency::HNL},
  {"HTG", Currency::HTG},
  {"HUF", Currency::HUF},
  {"IDR", Currency::IDR},
  {"ILS", Currency::ILS},
  {"INR", Currency::INR},
  {"IQD", Currency::IQD},
  {"IRR", Currency::IRR},
  {"ISK", Currency::ISK},
  {"JMD", Currency::JMD},
  {"JOD", Currency::JOD},
  {"JPY", Currency::JPY},
  {"KES", Currency::KES},
  {"KGS", Currency::KGS},
  {"KHR", Currency::KHR},
  {"KMF", Currency::KMF},
  {"KPW", Currency::KPW},
  {"KRW", Currency::KRW},
  {"KWD", Currency::KWD},
  {"KYD", Currency::KYD},
  {"KZT", Currency::KZT},
  {"LAK", Currency::LAK},
  {"LBP", Currency::LBP},
  {"LKR", Currency::LKR},
  {"LRD", Currency::LRD},
  {"LSL", Currency::LSL},
  {"LYD", Currency::LYD},
  {"MAD", Currency::MAD},
  {"MDL", Currency::MDL},
  {"MGA", Currency::MGA},
  {"MKD", Currency::MKD},
  {"MMK", Currency::MMK},
  {"MNT", Currency::MNT},
  {"MOP", Currency::MOP},
  {"MRU", Currency::MRU},
  {"MUR", Currency::MUR},
  {"MVR", Currency::MVR},
  {"MWK", Currency::MWK},
  {"MXN", Currency::MXN},
  {"MXV", Currency::MXV},
  {"MYR", Currency::MYR},
  {"MZN", Currency::MZN},
  {"NAD", Currency::NAD},
  {"NGN", Currency::NGN},
  {"NIO", Currency::NIO},
  {"NOK", Currency::NOK},
  {"NPR", Currency::NPR},
  {"NZD", Currency::NZD},
  {"OMR", Currency::OMR},
  {"PAB", Currency::PAB},
  {"PEN", Currency::PEN},
  {"PGK", Currency::PGK},
  {"PHP", Currency::PHP},
  {"PKR", Currency::PKR},
  {"PLN", Currency::PLN},
  {"PYG", Currency::PYG},
  {"QAR", Currency::QAR},
  {"RON", Currency::RON},
  {"RSD", Currency::RSD},
  {"RUB", Currency::RUB},
  {"RWF", Currency::RWF},
  {"SAR", Currency::SAR},
  {"SBD", Currency::SBD},
  {"SCR", Currency::SCR},
  {"SDG", Currency::SDG},
  {"SEK", Currency::SEK},
  {"SGD", Currency::SGD},
  {"SHP", Currency::SHP},
  {"SLE", Currency::SLE},
  {"SLL", Currency::SLL},
  {"SOS", Currency::SOS},
  {"SRD", Currency::SRD},
  {"SSP", Currency::SSP},
  {"STN", Currency::STN},
  {"SVC", Currency::SVC},
  {"SYP", Currency::SYP},
  {"SZL", Currency::SZL},
  {"THB", Currency::THB},
  {"TJS", Currency::TJS},
  {"TMT", Currency::TMT},
  {"TND", Currency::TND},
  {"TOP", Currency::TOP},
  {"TRY", Currency::TRY},
  {"TTD", Currency::TTD},
  {"TWD", Currency::TWD},
  {"TZS", Currency::TZS},
  {"UAH", Currency::UAH},
  {"UGX", Currency::UGX},
  {"USD", Currency::USD},
  {"USd", Currency::USX}, // NOTE: non iso
  {"USN", Currency::USN},
  {"USX", Currency::USX}, // NOTE: non iso
  {"UYI", Currency::UYI},
  {"UYU", Currency::UYU},
  {"UYW", Currency::UYW},
  {"UZS", Currency::UZS},
  {"VED", Currency::VED},
  {"VES", Currency::VES},
  {"VND", Currency::VND},
  {"VUV", Currency::VUV},
  {"WST", Currency::WST},
  {"XAF", Currency::XAF},
  {"XAG", Currency::XAG},
  {"XAU", Currency::XAU},
  {"XBA", Currency::XBA},
  {"XBB", Currency::XBB},
  {"XBC", Currency::XBC},
  {"XBD", Currency::XBD},
  {"XCD", Currency::XCD},
  {"XDR", Currency::XDR},
  {"XOF", Currency::XOF},
  {"XPD", Currency::XPD},
  {"XPF", Currency::XPF},
  {"XPT", Currency::XPT},
  {"XSU", Currency::XSU},
  {"XTS", Currency::XTS},
  {"XUA", Currency::XUA},
  {"XXX", Currency::XXX},
  {"YER", Currency::YER},
  {"ZAR", Currency::ZAR},
  {"ZMW", Currency::ZMW},
  {"ZWL", Currency::ZWL},
};

ENUM_FROM_STRING(Currency)
ENUM_TO_STRING(Currency)

static const std::vector<str_t> CurrencyName = {
  "United Arab Emirates dirham",
  "Afghan afghani",
  "Albanian lek",
  "Armenian dram",
  "Netherlands Antillean guilder",
  "Angolan kwanza",
  "Argentine peso",
  "Australian dollar",
  "Aruban florin",
  "Azerbaijani manat",
  "Bosnia and Herzegovina convertible mark",
  "Barbados dollar",
  "Bangladeshi taka",
  "Bulgarian lev",
  "Bahraini dinar",
  "Burundian franc",
  "Bermudian dollar",
  "Brunei dollar",
  "Boliviano",
  "Bolivian Mvdol",
  "Brazilian real",
  "Bahamian dollar",
  "Bhutanese ngultrum",
  "Botswana pula",
  "Belarusian ruble",
  "Belize dollar",
  "Canadian dollar",
  "Congolese franc",
  "WIR euro",
  "Swiss franc",
  "WIR franc",
  "Unidad de Fomento",
  "Chilean peso",
  "Renminbi",
  "Colombian peso",
  "Unidad de Valor Real (UVR)",
  "Costa Rican colon",
  "Cuban convertible peso",
  "Cuban peso",
  "Cape Verdean escudo",
  "Czech koruna",
  "Djiboutian franc",
  "Danish krone",
  "Dominican peso",
  "Algerian dinar",
  "Egyptian pound",
  "Eritrean nakfa",
  "Ethiopian birr",
  "Euro",
  "Euro (cents)",
  "Fiji dollar",
  "Falkland Islands pound",
  "Pound sterling",
  "Penny sterling",
  "Georgian lari",
  "Ghanaian cedi",
  "Gibraltar pound",
  "Gambian dalasi",
  "Guinean franc",
  "Guatemalan quetzal",
  "Guyanese dollar",
  "Hong Kong dollar",
  "Honduran lempira",
  "Haitian gourde",
  "Hungarian forint",
  "Indonesian rupiah",
  "Israeli new shekel",
  "Indian rupee",
  "Iraqi dinar",
  "Iranian rial",
  "Icelandic króna",
  "Jamaican dollar",
  "Jordanian dinar",
  "Japanese yen",
  "Kenyan shilling",
  "Kyrgyzstani som",
  "Cambodian riel",
  "Comoro franc",
  "North Korean won",
  "South Korean won",
  "Kuwaiti dinar",
  "Cayman Islands dollar",
  "Kazakhstani tenge",
  "Lao kip",
  "Lebanese pound",
  "Sri Lankan rupee",
  "Liberian dollar",
  "Lesotho loti",
  "Libyan dinar",
  "Moroccan dirham",
  "Moldovan leu",
  "Malagasy ariary",
  "Macedonian denar",
  "Myanmar kyat",
  "Mongolian tögrög",
  "Macanese pataca",
  "Mauritanian ouguiya",
  "Mauritian rupee",
  "Maldivian rufiyaa",
  "Malawian kwacha",
  "Mexican peso",
  "Mexican Unidad de Inversion",
  "Malaysian ringgit",
  "Mozambican metical",
  "Namibian dollar",
  "Nigerian naira",
  "Nicaraguan córdoba",
  "Norwegian krone",
  "Nepalese rupee",
  "New Zealand dollar",
  "Omani rial",
  "Panamanian balboa",
  "Peruvian sol",
  "Papua New Guinean kina",
  "Philippine peso",
  "Pakistani rupee",
  "Polish złoty",
  "Paraguayan guaraní",
  "Qatari riyal",
  "Romanian leu",
  "Serbian dinar",
  "Russian ruble",
  "Rwandan franc",
  "Saudi riyal",
  "Solomon Islands dollar",
  "Seychelles rupee",
  "Sudanese pound",
  "Swedish krona",
  "Singapore dollar",
  "Saint Helena pound",
  "Sierra Leonean leone",
  "Sierra Leonean leone",
  "Somali shilling",
  "Surinamese dollar",
  "South Sudanese pound",
  "São Tomé and Príncipe dobra",
  "Salvadoran colón",
  "Syrian pound",
  "Swazi lilangeni",
  "Thai baht",
  "Tajikistani somoni",
  "Turkmenistan manat",
  "Tunisian dinar",
  "Tongan paʻanga",
  "Turkish lira",
  "Trinidad and Tobago dollar",
  "New Taiwan dollar",
  "Tanzanian shilling",
  "Ukrainian hryvnia",
  "Ugandan shilling",
  "United States dollar",
  "United States dollar",
  "United States penny",
  "Uruguay Peso en Unidades Indexadas",
  "Uruguayan peso",
  "Unidad previsional",
  "Uzbekistan sum",
  "Venezuelan digital bolívar",
  "Venezuelan sovereign bolívar",
  "Vietnamese đồng",
  "Vanuatu vatu",
  "Samoan tala",
  "CFA franc BEAC",
  "Silver",
  "Gold",
  "European Composite Unit",
  "European Monetary Unit",
  "European Unit of Account 9",
  "European Unit of Account 17",
  "East Caribbean dollar",
  "Special drawing rights",
  "CFA franc BCEAO",
  "Palladium",
  "CFP franc",
  "Platinum",
  "SUCRE Unified System for Regional Compensation",
  "Code reserved for testing",
  "ADB Unit of Account",
  "No currency",
  "Yemeni rial",
  "South African rand",
  "Zambian kwacha",
  "Zimbabwean dollar",
};

str_t inline Currency_to_name(Currency& code) { return CurrencyName[static_cast<int>(code)]; }

}
