"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCalicoAddon = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_eks_1 = require("@aws-cdk/aws-eks");
class AwsCalicoAddon {
    constructor(props = {}) {
        this.props = props;
    }
    install(scope, platform) {
        var _b;
        new aws_eks_1.HelmChart(scope, 'AwsCalicoAddonChart', {
            cluster: platform.cluster,
            // Default setup is using built in priorityclasses (system-cluster-critical and system-node-critical) which are currently restricted to kube-system namespace.
            // Follow https://github.com/kubernetes/kubernetes/issues/76308 to see if anything has changed.
            namespace: 'kube-system',
            repository: 'https://aws.github.io/eks-charts',
            chart: 'aws-calico',
            release: 'aws-calico',
            version: (_b = this.props.version) !== null && _b !== void 0 ? _b : '0.3.5',
        });
    }
    get name() {
        return AwsCalicoAddon.NAME;
    }
}
exports.AwsCalicoAddon = AwsCalicoAddon;
_a = JSII_RTTI_SYMBOL_1;
AwsCalicoAddon[_a] = { fqn: "cdkeks.AwsCalicoAddon", version: "0.0.4" };
AwsCalicoAddon.NAME = 'aws-calico';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvYWRkb25zL2F3cy1jYWxpY28vaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw4Q0FBNkM7QUFXN0MsTUFBYSxjQUFjO0lBR3pCLFlBQTZCLFFBQXdCLEVBQUU7UUFBMUIsVUFBSyxHQUFMLEtBQUssQ0FBcUI7SUFBRyxDQUFDO0lBRXBELE9BQU8sQ0FBQyxLQUFnQixFQUFFLFFBQWtCOztRQUNqRCxJQUFJLG1CQUFTLENBQUMsS0FBSyxFQUFFLHFCQUFxQixFQUFFO1lBQzFDLE9BQU8sRUFBRSxRQUFRLENBQUMsT0FBTztZQUN6Qiw4SkFBOEo7WUFDOUosK0ZBQStGO1lBQy9GLFNBQVMsRUFBRSxhQUFhO1lBQ3hCLFVBQVUsRUFBRSxrQ0FBa0M7WUFDOUMsS0FBSyxFQUFFLFlBQVk7WUFDbkIsT0FBTyxFQUFFLFlBQVk7WUFDckIsT0FBTyxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxtQ0FBSSxPQUFPO1NBQ3ZDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRCxJQUFXLElBQUk7UUFDYixPQUFPLGNBQWMsQ0FBQyxJQUFJLENBQUM7SUFDN0IsQ0FBQzs7QUFwQkgsd0NBcUJDOzs7QUFwQndCLG1CQUFJLEdBQUcsWUFBWSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSGVsbUNoYXJ0IH0gZnJvbSAnQGF3cy1jZGsvYXdzLWVrcyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuaW1wb3J0IHsgUGxhdGZvcm0gfSBmcm9tICcuLi8uLi9wbGF0Zm9ybSc7XG5pbXBvcnQgeyBJQWRkb24gfSBmcm9tICcuLi9hZGRvbic7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXdzQ2FsaWNvUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZlcnNpb24/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBBd3NDYWxpY29BZGRvbiBpbXBsZW1lbnRzIElBZGRvbiB7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTkFNRSA9ICdhd3MtY2FsaWNvJztcblxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBBd3NDYWxpY29Qcm9wcyA9IHt9KSB7fVxuXG4gIHB1YmxpYyBpbnN0YWxsKHNjb3BlOiBDb25zdHJ1Y3QsIHBsYXRmb3JtOiBQbGF0Zm9ybSk6IHZvaWQge1xuICAgIG5ldyBIZWxtQ2hhcnQoc2NvcGUsICdBd3NDYWxpY29BZGRvbkNoYXJ0Jywge1xuICAgICAgY2x1c3RlcjogcGxhdGZvcm0uY2x1c3RlcixcbiAgICAgIC8vIERlZmF1bHQgc2V0dXAgaXMgdXNpbmcgYnVpbHQgaW4gcHJpb3JpdHljbGFzc2VzIChzeXN0ZW0tY2x1c3Rlci1jcml0aWNhbCBhbmQgc3lzdGVtLW5vZGUtY3JpdGljYWwpIHdoaWNoIGFyZSBjdXJyZW50bHkgcmVzdHJpY3RlZCB0byBrdWJlLXN5c3RlbSBuYW1lc3BhY2UuXG4gICAgICAvLyBGb2xsb3cgaHR0cHM6Ly9naXRodWIuY29tL2t1YmVybmV0ZXMva3ViZXJuZXRlcy9pc3N1ZXMvNzYzMDggdG8gc2VlIGlmIGFueXRoaW5nIGhhcyBjaGFuZ2VkLlxuICAgICAgbmFtZXNwYWNlOiAna3ViZS1zeXN0ZW0nLFxuICAgICAgcmVwb3NpdG9yeTogJ2h0dHBzOi8vYXdzLmdpdGh1Yi5pby9la3MtY2hhcnRzJyxcbiAgICAgIGNoYXJ0OiAnYXdzLWNhbGljbycsXG4gICAgICByZWxlYXNlOiAnYXdzLWNhbGljbycsXG4gICAgICB2ZXJzaW9uOiB0aGlzLnByb3BzLnZlcnNpb24gPz8gJzAuMy41JyxcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgbmFtZSgpOiBzdHJpbmcge1xuICAgIHJldHVybiBBd3NDYWxpY29BZGRvbi5OQU1FO1xuICB9XG59XG4iXX0=