import { IDomain } from '@aws-cdk/aws-elasticsearch';
import { ILogGroup } from '@aws-cdk/aws-logs';
import { Construct } from 'constructs';
import { Platform } from '../../platform';
import { IAddon } from '../addon';
export interface CloudWatchOptions {
    readonly logGroup: ILogGroup;
    /**
     * The log filter
     * */
    readonly match?: string;
}
export interface ElasticsearchOptions {
    readonly domain: IDomain;
    /**
     * The log filter
     * */
    readonly match?: string;
}
export interface AwsForFluentBitAddonProps {
    /**
     * @default `logging`
     */
    readonly namespaceName?: string;
    /**
     * @default `0.1.6`
     */
    readonly version?: string;
    readonly cloudWatchOptions?: CloudWatchOptions;
    readonly elasticsearchOptions?: ElasticsearchOptions;
}
export declare class AwsForFluentBitAddon implements IAddon {
    private readonly props;
    readonly name = "aws-for-fluent-bit";
    constructor(props?: AwsForFluentBitAddonProps);
    install(scope: Construct, platform: Platform): void;
    private parseCloudWatchOptions;
    private parseElasticsearchOptions;
}
