"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsForFluentBitAddon = void 0;
const aws_eks_1 = require("@aws-cdk/aws-eks");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_logs_1 = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
const namespace_1 = require("../../namespace");
const service_account_1 = require("../../service-account");
class AwsForFluentBitAddon {
    constructor(props = {}) {
        this.props = props;
        this.name = 'aws-for-fluent-bit';
    }
    install(scope, platform) {
        var _a, _b;
        const region = core_1.Stack.of(scope).region;
        const namespace = new namespace_1.Namespace(scope, 'AwsForFluentBitAddonNamespace', {
            platform,
            metadata: {
                name: (_a = this.props.namespaceName) !== null && _a !== void 0 ? _a : 'logging',
            },
        });
        const serviceAccount = new service_account_1.ServiceAccount(scope, 'AwsForFluentBitAddonServiceAccount', {
            platform,
            metadata: {
                name: 'fluent-bit',
                namespace: namespace.name,
            },
        });
        serviceAccount.node.addDependency(namespace);
        // Use cloudWatch as default
        const cloudWatchOptions = this.props.elasticsearchOptions || this.props.cloudWatchOptions
            ? this.props.cloudWatchOptions
            : {
                logGroup: new aws_logs_1.LogGroup(scope, 'AwsForFluentBitAddonDefaultLogGroup', {
                    logGroupName: `/aws/eks/fluentbit/${platform.cluster.clusterName}`,
                    removalPolicy: core_1.RemovalPolicy.DESTROY,
                    retention: aws_logs_1.RetentionDays.ONE_MONTH,
                }),
            };
        const chart = new aws_eks_1.HelmChart(scope, 'AwsForFluentBitAddonChart', {
            cluster: platform.cluster,
            namespace: namespace.name,
            repository: 'https://aws.github.io/eks-charts',
            chart: 'aws-for-fluent-bit',
            release: 'aws-for-fluent-bit',
            version: (_b = this.props.version) !== null && _b !== void 0 ? _b : '0.1.6',
            values: {
                serviceAccount: {
                    create: false,
                    name: serviceAccount.name,
                },
                firehose: {
                    enabled: false,
                },
                kinesis: {
                    enabled: false,
                },
                elasticsearch: this.parseElasticsearchOptions(region, serviceAccount, this.props.elasticsearchOptions),
                cloudWatch: this.parseCloudWatchOptions(region, serviceAccount, cloudWatchOptions),
            },
        });
        chart.node.addDependency(namespace);
    }
    parseCloudWatchOptions(region, serviceAccount, options) {
        var _a;
        if (!options) {
            return {
                enabled: false,
            };
        }
        serviceAccount.role.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('CloudWatchAgentServerPolicy'));
        return {
            enabled: true,
            region,
            logGroupName: options.logGroup.logGroupName,
            match: (_a = options === null || options === void 0 ? void 0 : options.match) !== null && _a !== void 0 ? _a : '*',
            autoCreateGroup: false,
        };
    }
    parseElasticsearchOptions(region, serviceAccount, options) {
        var _a;
        if (!options) {
            return {
                enabled: false,
            };
        }
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['es:ESHttp*'],
            resources: [options.domain.domainArn],
        }));
        return {
            enabled: true,
            awsRegion: region,
            awsAuth: 'On',
            tls: 'On',
            host: options.domain.domainEndpoint,
            port: 443,
            match: (_a = options === null || options === void 0 ? void 0 : options.match) !== null && _a !== void 0 ? _a : '*',
        };
    }
}
exports.AwsForFluentBitAddon = AwsForFluentBitAddon;
//# sourceMappingURL=data:application/json;base64,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