"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancerControllerAddon = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_eks_1 = require("@aws-cdk/aws-eks");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const namespace_1 = require("../../namespace");
const service_account_1 = require("../../service-account");
class AwsLoadBalancerControllerAddon {
    constructor(props = {}) {
        this.props = props;
    }
    install(scope, platform) {
        var _b;
        const region = core_1.Stack.of(scope).region;
        const namespace = this.props.namespaceName
            ? new namespace_1.Namespace(scope, 'Namespace', {
                platform,
                metadata: {
                    name: this.props.namespaceName,
                },
            })
            : namespace_1.Namespace.fromNamespaceName('kube-system');
        const serviceAccount = new service_account_1.ServiceAccount(scope, 'ServiceAccount', {
            platform,
            metadata: {
                name: 'aws-load-balancer-controller',
                namespace: namespace.name,
                labels: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': 'aws-load-balancer-controller',
                },
            },
        });
        //serviceAccount.node.addDependency(namespace);
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: [
                'iam:CreateServiceLinkedRole',
                'ec2:DescribeAccountAttributes',
                'ec2:DescribeAddresses',
                'ec2:DescribeAvailabilityZones',
                'ec2:DescribeInternetGateways',
                'ec2:DescribeVpcs',
                'ec2:DescribeSubnets',
                'ec2:DescribeSecurityGroups',
                'ec2:DescribeInstances',
                'ec2:DescribeNetworkInterfaces',
                'ec2:DescribeTags',
                'ec2:GetCoipPoolUsage',
                'ec2:DescribeCoipPools',
                'elasticloadbalancing:DescribeLoadBalancers',
                'elasticloadbalancing:DescribeLoadBalancerAttributes',
                'elasticloadbalancing:DescribeListeners',
                'elasticloadbalancing:DescribeListenerCertificates',
                'elasticloadbalancing:DescribeSSLPolicies',
                'elasticloadbalancing:DescribeRules',
                'elasticloadbalancing:DescribeTargetGroups',
                'elasticloadbalancing:DescribeTargetGroupAttributes',
                'elasticloadbalancing:DescribeTargetHealth',
                'elasticloadbalancing:DescribeTags',
            ],
            resources: ['*'],
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: [
                'cognito-idp:DescribeUserPoolClient',
                'acm:ListCertificates',
                'acm:DescribeCertificate',
                'iam:ListServerCertificates',
                'iam:GetServerCertificate',
                'waf-regional:GetWebACL',
                'waf-regional:GetWebACLForResource',
                'waf-regional:AssociateWebACL',
                'waf-regional:DisassociateWebACL',
                'wafv2:GetWebACL',
                'wafv2:GetWebACLForResource',
                'wafv2:AssociateWebACL',
                'wafv2:DisassociateWebACL',
                'shield:GetSubscriptionState',
                'shield:DescribeProtection',
                'shield:CreateProtection',
                'shield:DeleteProtection',
            ],
            resources: ['*'],
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['ec2:AuthorizeSecurityGroupIngress', 'ec2:RevokeSecurityGroupIngress'],
            resources: ['*'],
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['ec2:CreateSecurityGroup'],
            resources: ['*'],
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['ec2:CreateTags'],
            resources: ['arn:aws:ec2:*:*:security-group/*'],
            conditions: {
                StringEquals: {
                    'ec2:CreateAction': 'CreateSecurityGroup',
                },
                Null: {
                    'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['ec2:CreateTags', 'ec2:DeleteTags'],
            resources: ['arn:aws:ec2:*:*:security-group/*'],
            conditions: {
                Null: {
                    'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                    'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['ec2:AuthorizeSecurityGroupIngress', 'ec2:RevokeSecurityGroupIngress', 'ec2:DeleteSecurityGroup'],
            resources: ['*'],
            conditions: {
                Null: {
                    'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['elasticloadbalancing:CreateLoadBalancer', 'elasticloadbalancing:CreateTargetGroup'],
            resources: ['*'],
            conditions: {
                Null: {
                    'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: [
                'elasticloadbalancing:CreateListener',
                'elasticloadbalancing:DeleteListener',
                'elasticloadbalancing:CreateRule',
                'elasticloadbalancing:DeleteRule',
            ],
            resources: ['*'],
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['elasticloadbalancing:AddTags', 'elasticloadbalancing:RemoveTags'],
            resources: [
                'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
                'arn:aws:elasticloadbalancing:*:*:loadbalancer/net/*/*',
                'arn:aws:elasticloadbalancing:*:*:loadbalancer/app/*/*',
            ],
            conditions: {
                Null: {
                    'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                    'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['elasticloadbalancing:AddTags', 'elasticloadbalancing:RemoveTags'],
            resources: [
                'arn:aws:elasticloadbalancing:*:*:listener/net/*/*/*',
                'arn:aws:elasticloadbalancing:*:*:listener/app/*/*/*',
                'arn:aws:elasticloadbalancing:*:*:listener-rule/net/*/*/*',
                'arn:aws:elasticloadbalancing:*:*:listener-rule/app/*/*/*',
            ],
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: [
                'elasticloadbalancing:ModifyLoadBalancerAttributes',
                'elasticloadbalancing:SetIpAddressType',
                'elasticloadbalancing:SetSecurityGroups',
                'elasticloadbalancing:SetSubnets',
                'elasticloadbalancing:DeleteLoadBalancer',
                'elasticloadbalancing:ModifyTargetGroup',
                'elasticloadbalancing:ModifyTargetGroupAttributes',
                'elasticloadbalancing:DeleteTargetGroup',
            ],
            resources: ['*'],
            conditions: {
                Null: {
                    'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['elasticloadbalancing:RegisterTargets', 'elasticloadbalancing:DeregisterTargets'],
            resources: ['arn:aws:elasticloadbalancing:*:*:targetgroup/*/*'],
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: [
                'elasticloadbalancing:SetWebAcl',
                'elasticloadbalancing:ModifyListener',
                'elasticloadbalancing:AddListenerCertificates',
                'elasticloadbalancing:RemoveListenerCertificates',
                'elasticloadbalancing:ModifyRule',
            ],
            resources: ['*'],
        }));
        new aws_eks_1.HelmChart(scope, 'HelmChart', {
            cluster: platform.cluster,
            namespace: namespace.name,
            repository: 'https://aws.github.io/eks-charts',
            chart: 'aws-load-balancer-controller',
            release: 'aws-load-balancer-controller',
            version: (_b = this.props.version) !== null && _b !== void 0 ? _b : '1.2.0',
            values: {
                clusterName: platform.cluster.clusterName,
                region,
                vpcId: platform.cluster.vpc.vpcId,
                serviceAccount: {
                    create: false,
                    name: serviceAccount.name,
                },
            },
        });
        //chart.node.addDependency(namespace);
    }
    get name() {
        return AwsLoadBalancerControllerAddon.NAME;
    }
}
exports.AwsLoadBalancerControllerAddon = AwsLoadBalancerControllerAddon;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancerControllerAddon[_a] = { fqn: "cdkeks.AwsLoadBalancerControllerAddon", version: "0.0.4" };
AwsLoadBalancerControllerAddon.NAME = 'aws-load-balancer-controller';
//# sourceMappingURL=data:application/json;base64,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