import { IHostedZone } from '@aws-cdk/aws-route53';
import { Construct } from 'constructs';
import { Platform } from '../../platform';
import { IAddon } from '../addon';
export interface ExternalDnsProps {
    /**
     * @default `dns`
     */
    readonly namespaceName?: string;
    /**
     * @default `5.0.2`
     */
    readonly version?: string;
    readonly hostedZones: IHostedZone[];
}
export declare class ExternalDnsAddon implements IAddon {
    private readonly props;
    readonly name = "external-dns";
    constructor(props: ExternalDnsProps);
    install(scope: Construct, platform: Platform): void;
}
