"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExternalDnsAddon = void 0;
const aws_eks_1 = require("@aws-cdk/aws-eks");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const namespace_1 = require("../../namespace");
const service_account_1 = require("../../service-account");
class ExternalDnsAddon {
    constructor(props) {
        this.props = props;
        this.name = 'external-dns';
    }
    install(scope, platform) {
        var _a, _b;
        const region = core_1.Stack.of(scope).region;
        const namespace = new namespace_1.Namespace(scope, 'AwsForFluentBitAddonNamespace', {
            platform,
            metadata: {
                name: (_a = this.props.namespaceName) !== null && _a !== void 0 ? _a : 'dns',
            },
        });
        const serviceAccount = new service_account_1.ServiceAccount(scope, 'ServiceAccount', {
            platform,
            metadata: {
                name: 'external-dns',
                namespace: namespace.name,
            },
        });
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['route53:ChangeResourceRecordSets', 'route53:ListResourceRecordSets'],
            resources: this.props.hostedZones.map((hostedZone) => hostedZone.hostedZoneArn),
        }));
        serviceAccount.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['route53:ListHostedZones'],
            resources: ['*'],
        }));
        serviceAccount.node.addDependency(namespace);
        const chart = new aws_eks_1.HelmChart(scope, 'ExternalDnsAddonChart', {
            cluster: platform.cluster,
            namespace: 'kube-system',
            repository: 'https://charts.bitnami.com/bitnami',
            chart: 'external-dns',
            release: 'external-dns',
            version: (_b = this.props.version) !== null && _b !== void 0 ? _b : '5.0.2',
            values: {
                provider: 'aws',
                zoneIdFilters: this.props.hostedZones.map((hostedZone) => hostedZone.hostedZoneId),
                aws: {
                    region,
                },
                serviceAccount: {
                    create: false,
                    name: serviceAccount.name,
                },
            },
        });
        chart.node.addDependency(namespace);
    }
}
exports.ExternalDnsAddon = ExternalDnsAddon;
//# sourceMappingURL=data:application/json;base64,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