"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NginxIngressAddon = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_eks_1 = require("@aws-cdk/aws-eks");
const namespace_1 = require("../../namespace");
class NginxIngressAddon {
    constructor(props = {}) {
        this.props = props;
    }
    install(scope, platform) {
        var _b, _c;
        const namespace = new namespace_1.Namespace(scope, 'AwsForFluentBitAddonNamespace', {
            platform,
            metadata: {
                name: (_b = this.props.namespaceName) !== null && _b !== void 0 ? _b : 'nginx-ingress',
            },
        });
        const chart = new aws_eks_1.HelmChart(scope, 'ArgoCDAddonChart', {
            cluster: platform.cluster,
            namespace: namespace.name,
            repository: 'https://helm.nginx.com/stable',
            chart: 'nginx-ingress',
            version: (_c = this.props.version) !== null && _c !== void 0 ? _c : '0.9.2',
        });
        chart.node.addDependency(namespace);
    }
    get name() {
        return NginxIngressAddon.NAME;
    }
}
exports.NginxIngressAddon = NginxIngressAddon;
_a = JSII_RTTI_SYMBOL_1;
NginxIngressAddon[_a] = { fqn: "cdkeks.NginxIngressAddon", version: "0.0.4" };
NginxIngressAddon.NAME = 'nginx-ingress';
//# sourceMappingURL=data:application/json;base64,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