import { ICertificate } from '@aws-cdk/aws-certificatemanager';
import { IConnectable, Connections, ISecurityGroup } from '@aws-cdk/aws-ec2';
import { IpAddressType, SslPolicy } from '@aws-cdk/aws-elasticloadbalancingv2';
import { IBucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import * as cdk8s from 'cdk8s';
import * as kplus from 'cdk8s-plus-17';
import { Cdk8sConstruct, Cdk8sConstructProps } from './cdk8s-construct';
import { Service } from './service';
export interface AlbIngressProps extends Cdk8sConstructProps {
    /**
     * Security Group to assign to this instance.
     *
     * @default - create new security group
     */
    readonly securityGroup?: ISecurityGroup;
    /**
     * @default AlbTargetType.INSTANCE
     */
    readonly targetType?: TargetType;
    /**
     * Whether the load balancer has an internet-routable address.
     *
     * @default false
     */
    readonly internetFacing?: boolean;
    /**
     * The type of IP addresses to use.
     *
     * Only applies to application load balancers.
     *
     * @default IpAddressType.Ipv4
     */
    readonly ipAdressType?: IpAddressType;
    /**
     * @default SslPolicy.RECOMMENDED
     */
    readonly sslPolicy?: SslPolicy;
    /**
     * Certificates to attach.
     */
    readonly certificates?: ICertificate[];
    readonly rules?: kplus.IngressV1Beta1Rule[];
    /**
     * Tags that will be applied to AWS resources created.
     */
    readonly tags?: Record<string, string>;
}
export declare class AlbIngress extends Cdk8sConstruct implements IConnectable {
    readonly apiObject: kplus.IngressV1Beta1;
    /**
     * Allows specify security group connections for the instance.
     */
    readonly connections: Connections;
    private readonly securityGroup;
    private readonly securityGroups;
    constructor(scope: Construct, id: string, props: AlbIngressProps);
    addRule(path: string, backend: kplus.IngressV1Beta1Backend): void;
    /**
     * Add the security group to the instance.
     *
     * @param securityGroup : The security group to add.
     */
    addSecurityGroup(securityGroup: ISecurityGroup): void;
    /**
     * Enable access logging for this load balancer.
     */
    logAccessLogs(bucket: IBucket, prefix?: string): void;
    get name(): string;
    get metadata(): cdk8s.ApiObjectMetadataDefinition;
}
export declare class IngressBackend {
    static fromService(service: Service, options?: kplus.ServiceIngressV1BetaBackendOptions): kplus.IngressV1Beta1Backend;
}
/**
 * How to interpret the load balancing target identifiers.
 */
export declare enum TargetType {
    /**
     * Targets identified by IP address.
     */
    IP = "ip",
    /**
     * Targets identified by instance ID.
     */
    INSTANCE = "instance"
}
