"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TargetType = exports.IngressBackend = exports.AlbIngress = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_elasticloadbalancingv2_1 = require("@aws-cdk/aws-elasticloadbalancingv2");
const core_1 = require("@aws-cdk/core");
const kplus = require("cdk8s-plus-17");
const cdk8s_construct_1 = require("./cdk8s-construct");
const utils_1 = require("./utils");
class AlbIngress extends cdk8s_construct_1.Cdk8sConstruct {
    constructor(scope, id, props) {
        var _c, _d, _e;
        super(scope, id, props);
        this.securityGroups = [];
        if (props.securityGroup) {
            this.securityGroup = props.securityGroup;
        }
        else {
            this.securityGroup = new aws_ec2_1.SecurityGroup(this, 'SecurityGroup', {
                vpc: this.platform.cluster.vpc,
                description: `Automatically created Security Group for ELB ${core_1.Names.uniqueId(this)}`,
                allowAllOutbound: true,
            });
        }
        this.connections = new aws_ec2_1.Connections({ securityGroups: [this.securityGroup] });
        this.securityGroups.push(this.securityGroup);
        //TODO
        this.platform.cluster.clusterSecurityGroup.connections.allowFrom(this, aws_ec2_1.Port.tcp(80));
        this.platform.cluster.clusterSecurityGroup.connections.allowFrom(this, aws_ec2_1.Port.tcp(443));
        const securityGroupsToken = core_1.Lazy.string({ produce: () => this.securityGroups.map((sg) => sg.securityGroupId).join(',') });
        const annotations = {
            'kubernetes.io/ingress.class': 'alb',
            'alb.ingress.kubernetes.io/target-type': (_c = props.targetType) !== null && _c !== void 0 ? _c : TargetType.INSTANCE,
            'alb.ingress.kubernetes.io/scheme': props.internetFacing ? 'internet-facing' : 'internal',
            'alb.ingress.kubernetes.io/security-groups': securityGroupsToken,
            'alb.ingress.kubernetes.io/ip-address-type': (_d = props.ipAdressType) !== null && _d !== void 0 ? _d : aws_elasticloadbalancingv2_1.IpAddressType.IPV4,
            'alb.ingress.kubernetes.io/ssl-policy': (_e = props.sslPolicy) !== null && _e !== void 0 ? _e : aws_elasticloadbalancingv2_1.SslPolicy.RECOMMENDED,
        };
        if (props.tags) {
            const tags = [];
            for (const [key, value] of Object.entries(props.tags)) {
                core_1.Tags.of(this).add(key, value);
                tags.push(`${key}=${value}`);
            }
            annotations['alb.ingress.kubernetes.io/tags'] = tags.join(',');
        }
        if (props.certificates && props.certificates.length > 0) {
            annotations['alb.ingress.kubernetes.io/certificate-arn'] = props.certificates.map((cert) => cert.certificateArn).join(',');
        }
        this.apiObject = new kplus.IngressV1Beta1(this.chart, 'ingress', {
            metadata: utils_1.generateMetadata(props.metadata, annotations),
            rules: props.rules,
        });
    }
    addRule(path, backend) {
        this.apiObject.addRule(path, backend);
    }
    /**
     * Add the security group to the instance.
     *
     * @param securityGroup : The security group to add.
     */
    addSecurityGroup(securityGroup) {
        this.securityGroups.push(securityGroup);
    }
    /**
     * Enable access logging for this load balancer.
     */
    logAccessLogs(bucket, prefix = '/') {
        this.apiObject.metadata.addAnnotation('alb.ingress.kubernetes.io/load-balancer-attributes', `access_logs.s3.enabled=true,access_logs.s3.bucket=${bucket.bucketName},access_logs.s3.prefix=${prefix}`);
        this.node.addDependency(bucket);
    }
    get name() {
        return this.apiObject.name;
    }
    get metadata() {
        return this.apiObject.metadata;
    }
}
exports.AlbIngress = AlbIngress;
_a = JSII_RTTI_SYMBOL_1;
AlbIngress[_a] = { fqn: "cdkeks.AlbIngress", version: "0.0.4" };
class IngressBackend {
    static fromService(service, options = {}) {
        return kplus.IngressV1Beta1Backend.fromService(service.apiObject, options);
    }
}
exports.IngressBackend = IngressBackend;
_b = JSII_RTTI_SYMBOL_1;
IngressBackend[_b] = { fqn: "cdkeks.IngressBackend", version: "0.0.4" };
/**
 * How to interpret the load balancing target identifiers.
 */
var TargetType;
(function (TargetType) {
    TargetType["IP"] = "ip";
    TargetType["INSTANCE"] = "instance";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
//# sourceMappingURL=data:application/json;base64,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