import { Construct as CoreConstruct } from '@aws-cdk/core';
import * as cdk8s from 'cdk8s';
import { Construct } from 'constructs';
import { Platform } from './platform';
export interface Cdk8sConstructProps {
    readonly metadata?: cdk8s.ApiObjectMetadata;
    readonly platform: Platform;
}
export declare abstract class Cdk8sConstruct extends CoreConstruct {
    protected readonly platform: Platform;
    protected readonly chart: cdk8s.Chart;
    abstract readonly name: string;
    abstract readonly metadata: cdk8s.ApiObjectMetadataDefinition;
    constructor(scope: Construct, id: string, props: Cdk8sConstructProps);
    /**
     * Perform final modifications before synthesis.
     *
     * This method can be implemented by derived constructs in order to perform
     * final changes before synthesis. prepare() will be called after child
     * constructs have been prepared.
     *
     * This is an advanced framework feature. Only use this if you
     * understand the implications.
     */
    protected onPrepare(): void;
}
