"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cdk8sConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
class Cdk8sConstruct extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.platform = props.platform;
        this.chart = new cdk8s.Chart(new cdk8s.App(), 'chart');
    }
    /**
     * Perform final modifications before synthesis.
     *
     * This method can be implemented by derived constructs in order to perform
     * final changes before synthesis. prepare() will be called after child
     * constructs have been prepared.
     *
     * This is an advanced framework feature. Only use this if you
     * understand the implications.
     */
    onPrepare() {
        this.platform.addCdk8sChart(constructs_1.Node.of(this).id, this.chart);
    }
}
exports.Cdk8sConstruct = Cdk8sConstruct;
_a = JSII_RTTI_SYMBOL_1;
Cdk8sConstruct[_a] = { fqn: "cdkeks.Cdk8sConstruct", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2RrOHMtY29uc3RydWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2NkazhzLWNvbnN0cnVjdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHdDQUEyRDtBQUMzRCwrQkFBK0I7QUFDL0IsMkNBQTZDO0FBUzdDLE1BQXNCLGNBQWUsU0FBUSxnQkFBYTtJQU94RCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTBCO1FBQ2xFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxLQUFLLEdBQUcsSUFBSSxLQUFLLENBQUMsS0FBSyxDQUFDLElBQUksS0FBSyxDQUFDLEdBQUcsRUFBRSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ3pELENBQUM7Ozs7Ozs7Ozs7O0lBRVMsU0FBUztRQUNqQixJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQyxpQkFBSSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQzVELENBQUM7O0FBZkgsd0NBZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IGFzIENvcmVDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGNkazhzIGZyb20gJ2NkazhzJztcbmltcG9ydCB7IENvbnN0cnVjdCwgTm9kZSB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5pbXBvcnQgeyBQbGF0Zm9ybSB9IGZyb20gJy4vcGxhdGZvcm0nO1xuXG5leHBvcnQgaW50ZXJmYWNlIENkazhzQ29uc3RydWN0UHJvcHMge1xuICByZWFkb25seSBtZXRhZGF0YT86IGNkazhzLkFwaU9iamVjdE1ldGFkYXRhO1xuICByZWFkb25seSBwbGF0Zm9ybTogUGxhdGZvcm07XG59XG5cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBDZGs4c0NvbnN0cnVjdCBleHRlbmRzIENvcmVDb25zdHJ1Y3Qge1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgcGxhdGZvcm06IFBsYXRmb3JtO1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgY2hhcnQ6IGNkazhzLkNoYXJ0O1xuXG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBtZXRhZGF0YTogY2RrOHMuQXBpT2JqZWN0TWV0YWRhdGFEZWZpbml0aW9uO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZGs4c0NvbnN0cnVjdFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICB0aGlzLnBsYXRmb3JtID0gcHJvcHMucGxhdGZvcm07XG4gICAgdGhpcy5jaGFydCA9IG5ldyBjZGs4cy5DaGFydChuZXcgY2RrOHMuQXBwKCksICdjaGFydCcpO1xuICB9XG5cbiAgcHJvdGVjdGVkIG9uUHJlcGFyZSgpOiB2b2lkIHtcbiAgICB0aGlzLnBsYXRmb3JtLmFkZENkazhzQ2hhcnQoTm9kZS5vZih0aGlzKS5pZCwgdGhpcy5jaGFydCk7XG4gIH1cbn1cbiJdfQ==