import { ServiceAccount } from '@aws-cdk/aws-eks';
import { Construct } from '@aws-cdk/core';
import * as cdk8s from 'cdk8s';
import * as kplus from 'cdk8s-plus-17';
import { Cdk8sConstruct, Cdk8sConstructProps } from './cdk8s-construct';
import { Service } from './service';
export interface DeploymentProps extends Cdk8sConstructProps {
    readonly serviceAccount?: ServiceAccount;
    readonly containers?: kplus.ContainerProps[];
}
export declare class Deployment extends Cdk8sConstruct {
    readonly apiObject: kplus.Deployment;
    readonly labelSelector: Record<string, string>;
    constructor(scope: Construct, id: string, props: DeploymentProps);
    expose(id: string, port: number, options?: kplus.ExposeOptions): Service;
    get containers(): kplus.Container[];
    get name(): string;
    get metadata(): cdk8s.ApiObjectMetadataDefinition;
}
