"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Deployment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const kplus = require("cdk8s-plus-17");
const cdk8s_construct_1 = require("./cdk8s-construct");
const service_1 = require("./service");
const utils_1 = require("./utils");
class Deployment extends cdk8s_construct_1.Cdk8sConstruct {
    constructor(scope, id, props) {
        super(scope, id, props);
        const serviceAccount = props.serviceAccount ? kplus.ServiceAccount.fromServiceAccountName(props.serviceAccount.serviceAccountName) : undefined;
        this.apiObject = new kplus.Deployment(this.chart, 'deployment', {
            metadata: utils_1.generateMetadata(props.metadata),
            containers: props.containers,
            serviceAccount,
        });
        this.labelSelector = this.apiObject.labelSelector;
    }
    expose(id, port, options = {}) {
        var _b;
        const service = new service_1.Service(this, id, {
            platform: this.platform,
            metadata: options.name ? { name: options.name } : undefined,
            type: (_b = options.serviceType) !== null && _b !== void 0 ? _b : kplus.ServiceType.CLUSTER_IP,
        });
        service.node.addDependency(this);
        service.addDeployment(this, port, { protocol: options.protocol, targetPort: options.targetPort });
        return service;
    }
    get containers() {
        return this.apiObject.containers;
    }
    get name() {
        return this.apiObject.name;
    }
    get metadata() {
        return this.apiObject.metadata;
    }
}
exports.Deployment = Deployment;
_a = JSII_RTTI_SYMBOL_1;
Deployment[_a] = { fqn: "cdkeks.Deployment", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVwbG95bWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9kZXBsb3ltZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBR0EsdUNBQXVDO0FBRXZDLHVEQUF3RTtBQUN4RSx1Q0FBb0M7QUFDcEMsbUNBQTJDO0FBTzNDLE1BQWEsVUFBVyxTQUFRLGdDQUFjO0lBSzVDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBc0I7UUFDOUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFeEIsTUFBTSxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQyxzQkFBc0IsQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztRQUUvSSxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksS0FBSyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLFlBQVksRUFBRTtZQUM5RCxRQUFRLEVBQUUsd0JBQWdCLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQztZQUMxQyxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsY0FBYztTQUNmLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLENBQUM7SUFDcEQsQ0FBQztJQUVNLE1BQU0sQ0FBQyxFQUFVLEVBQUUsSUFBWSxFQUFFLFVBQStCLEVBQUU7O1FBQ3ZFLE1BQU0sT0FBTyxHQUFHLElBQUksaUJBQU8sQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFFO1lBQ3BDLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixRQUFRLEVBQUUsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxJQUFJLEVBQUUsT0FBTyxDQUFDLElBQUksRUFBRSxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQzNELElBQUksUUFBRSxPQUFPLENBQUMsV0FBVyxtQ0FBSSxLQUFLLENBQUMsV0FBVyxDQUFDLFVBQVU7U0FDMUQsQ0FBQyxDQUFDO1FBRUgsT0FBTyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDakMsT0FBTyxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsSUFBSSxFQUFFLEVBQUUsUUFBUSxFQUFFLE9BQU8sQ0FBQyxRQUFRLEVBQUUsVUFBVSxFQUFFLE9BQU8sQ0FBQyxVQUFVLEVBQUUsQ0FBQyxDQUFDO1FBRWxHLE9BQU8sT0FBTyxDQUFDO0lBQ2pCLENBQUM7SUFFRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQztJQUNuQyxDQUFDO0lBRUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQztJQUM3QixDQUFDO0lBRUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUM7SUFDakMsQ0FBQzs7QUExQ0gsZ0NBMkNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgU2VydmljZUFjY291bnQgfSBmcm9tICdAYXdzLWNkay9hd3MtZWtzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgY2RrOHMgZnJvbSAnY2RrOHMnO1xuaW1wb3J0ICogYXMga3BsdXMgZnJvbSAnY2RrOHMtcGx1cy0xNyc7XG5cbmltcG9ydCB7IENkazhzQ29uc3RydWN0LCBDZGs4c0NvbnN0cnVjdFByb3BzIH0gZnJvbSAnLi9jZGs4cy1jb25zdHJ1Y3QnO1xuaW1wb3J0IHsgU2VydmljZSB9IGZyb20gJy4vc2VydmljZSc7XG5pbXBvcnQgeyBnZW5lcmF0ZU1ldGFkYXRhIH0gZnJvbSAnLi91dGlscyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgRGVwbG95bWVudFByb3BzIGV4dGVuZHMgQ2RrOHNDb25zdHJ1Y3RQcm9wcyB7XG4gIHJlYWRvbmx5IHNlcnZpY2VBY2NvdW50PzogU2VydmljZUFjY291bnQ7XG4gIHJlYWRvbmx5IGNvbnRhaW5lcnM/OiBrcGx1cy5Db250YWluZXJQcm9wc1tdO1xufVxuXG5leHBvcnQgY2xhc3MgRGVwbG95bWVudCBleHRlbmRzIENkazhzQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGFwaU9iamVjdDoga3BsdXMuRGVwbG95bWVudDtcblxuICBwdWJsaWMgcmVhZG9ubHkgbGFiZWxTZWxlY3RvcjogUmVjb3JkPHN0cmluZywgc3RyaW5nPjtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRGVwbG95bWVudFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG5cbiAgICBjb25zdCBzZXJ2aWNlQWNjb3VudCA9IHByb3BzLnNlcnZpY2VBY2NvdW50ID8ga3BsdXMuU2VydmljZUFjY291bnQuZnJvbVNlcnZpY2VBY2NvdW50TmFtZShwcm9wcy5zZXJ2aWNlQWNjb3VudC5zZXJ2aWNlQWNjb3VudE5hbWUpIDogdW5kZWZpbmVkO1xuXG4gICAgdGhpcy5hcGlPYmplY3QgPSBuZXcga3BsdXMuRGVwbG95bWVudCh0aGlzLmNoYXJ0LCAnZGVwbG95bWVudCcsIHtcbiAgICAgIG1ldGFkYXRhOiBnZW5lcmF0ZU1ldGFkYXRhKHByb3BzLm1ldGFkYXRhKSxcbiAgICAgIGNvbnRhaW5lcnM6IHByb3BzLmNvbnRhaW5lcnMsXG4gICAgICBzZXJ2aWNlQWNjb3VudCxcbiAgICB9KTtcblxuICAgIHRoaXMubGFiZWxTZWxlY3RvciA9IHRoaXMuYXBpT2JqZWN0LmxhYmVsU2VsZWN0b3I7XG4gIH1cblxuICBwdWJsaWMgZXhwb3NlKGlkOiBzdHJpbmcsIHBvcnQ6IG51bWJlciwgb3B0aW9uczoga3BsdXMuRXhwb3NlT3B0aW9ucyA9IHt9KTogU2VydmljZSB7XG4gICAgY29uc3Qgc2VydmljZSA9IG5ldyBTZXJ2aWNlKHRoaXMsIGlkLCB7XG4gICAgICBwbGF0Zm9ybTogdGhpcy5wbGF0Zm9ybSxcbiAgICAgIG1ldGFkYXRhOiBvcHRpb25zLm5hbWUgPyB7IG5hbWU6IG9wdGlvbnMubmFtZSB9IDogdW5kZWZpbmVkLFxuICAgICAgdHlwZTogb3B0aW9ucy5zZXJ2aWNlVHlwZSA/PyBrcGx1cy5TZXJ2aWNlVHlwZS5DTFVTVEVSX0lQLFxuICAgIH0pO1xuXG4gICAgc2VydmljZS5ub2RlLmFkZERlcGVuZGVuY3kodGhpcyk7XG4gICAgc2VydmljZS5hZGREZXBsb3ltZW50KHRoaXMsIHBvcnQsIHsgcHJvdG9jb2w6IG9wdGlvbnMucHJvdG9jb2wsIHRhcmdldFBvcnQ6IG9wdGlvbnMudGFyZ2V0UG9ydCB9KTtcblxuICAgIHJldHVybiBzZXJ2aWNlO1xuICB9XG5cbiAgcHVibGljIGdldCBjb250YWluZXJzKCk6IGtwbHVzLkNvbnRhaW5lcltdIHtcbiAgICByZXR1cm4gdGhpcy5hcGlPYmplY3QuY29udGFpbmVycztcbiAgfVxuXG4gIHB1YmxpYyBnZXQgbmFtZSgpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLmFwaU9iamVjdC5uYW1lO1xuICB9XG5cbiAgcHVibGljIGdldCBtZXRhZGF0YSgpOiBjZGs4cy5BcGlPYmplY3RNZXRhZGF0YURlZmluaXRpb24ge1xuICAgIHJldHVybiB0aGlzLmFwaU9iamVjdC5tZXRhZGF0YTtcbiAgfVxufVxuIl19