"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyType = exports.NetworkPolicy = void 0;
const cdk8s = require("cdk8s");
const kplus = require("cdk8s-plus-17");
const k8s = require("./imports/k8s");
class NetworkPolicy extends kplus.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        this.apiObject = new k8s.KubeNetworkPolicy(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s.Lazy.any({ produce: () => this.toKube() }),
        });
        this.policyTypes = (_a = props.policyTypes) !== null && _a !== void 0 ? _a : [PolicyType.INGRESS];
    }
    toKube() {
        return {
            podSelector: {},
            policyTypes: this.policyTypes,
        };
    }
}
exports.NetworkPolicy = NetworkPolicy;
var PolicyType;
(function (PolicyType) {
    PolicyType["INGRESS"] = "Ingress";
    PolicyType["EGRESS"] = "Egress";
})(PolicyType = exports.PolicyType || (exports.PolicyType = {}));
//# sourceMappingURL=data:application/json;base64,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