import { ICertificate } from '@aws-cdk/aws-certificatemanager';
import { SslPolicy } from '@aws-cdk/aws-elasticloadbalancingv2';
import { Construct } from '@aws-cdk/core';
import { Cdk8sConstructProps } from './cdk8s-construct';
import { Service } from './service';
export interface LoadBalancerProps extends Cdk8sConstructProps {
    readonly backendProtocal?: BackendProtocol;
    readonly certificate?: ICertificate;
    readonly sslPolicy?: SslPolicy;
    /**
     * @default false
     */
    readonly internal: boolean;
}
export declare class LoadBalancer extends Service {
    constructor(scope: Construct, id: string, props: LoadBalancerProps);
    get hostname(): string;
}
export interface NetworkLoadBalancerProps extends Cdk8sConstructProps {
    /**
     * @default false
     */
    readonly internal: boolean;
}
export declare class NetworkLoadBalancer extends Service {
    constructor(scope: Construct, id: string, props: NetworkLoadBalancerProps);
}
export declare enum BackendProtocol {
    HTTPS = "https",
    HTTP = "http",
    TCP = "tcp",
    SSL = "ssl"
}
