"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackendProtocol = exports.NetworkLoadBalancer = exports.LoadBalancer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_eks_1 = require("@aws-cdk/aws-eks");
const service_1 = require("./service");
const utils_1 = require("./utils");
class LoadBalancer extends service_1.Service {
    constructor(scope, id, props) {
        var _c;
        const annotations = {
            'service.beta.kubernetes.io/aws-load-balancer-internal': props.internal ? 'true' : 'false',
        };
        if (props.backendProtocal) {
            annotations['service.beta.kubernetes.io/aws-load-balancer-backend-protocol'] = props.backendProtocal;
        }
        if (props.certificate) {
            annotations['service.beta.kubernetes.io/aws-load-balancer-ssl-cert'] = (_c = props.certificate) === null || _c === void 0 ? void 0 : _c.certificateArn;
        }
        if (props.sslPolicy) {
            annotations['service.beta.kubernetes.io/aws-load-balancer-ssl-negotiation-policy'] = props.sslPolicy;
        }
        super(scope, id, {
            metadata: utils_1.generateMetadata(props.metadata, annotations),
            platform: props.platform,
            type: service_1.ServiceType.LOAD_BALANCER,
        });
    }
    get hostname() {
        const loadBalancerAddress = new aws_eks_1.KubernetesObjectValue(this, 'ServiceAddress', {
            cluster: this.platform.cluster,
            objectType: 'service',
            objectName: this.name,
            objectNamespace: this.metadata.namespace,
            jsonPath: '.status.loadBalancer.ingress[0].hostname',
        });
        return loadBalancerAddress.value;
    }
}
exports.LoadBalancer = LoadBalancer;
_a = JSII_RTTI_SYMBOL_1;
LoadBalancer[_a] = { fqn: "cdkeks.LoadBalancer", version: "0.0.4" };
class NetworkLoadBalancer extends service_1.Service {
    constructor(scope, id, props) {
        const annotations = {
            'service.beta.kubernetes.io/aws-load-balancer-type': 'nlb',
            'service.beta.kubernetes.io/aws-load-balancer-internal': props.internal ? 'true' : 'false',
        };
        super(scope, id, {
            metadata: utils_1.generateMetadata(props.metadata, annotations),
            platform: props.platform,
            type: service_1.ServiceType.LOAD_BALANCER,
        });
    }
}
exports.NetworkLoadBalancer = NetworkLoadBalancer;
_b = JSII_RTTI_SYMBOL_1;
NetworkLoadBalancer[_b] = { fqn: "cdkeks.NetworkLoadBalancer", version: "0.0.4" };
var BackendProtocol;
(function (BackendProtocol) {
    BackendProtocol["HTTPS"] = "https";
    BackendProtocol["HTTP"] = "http";
    BackendProtocol["TCP"] = "tcp";
    BackendProtocol["SSL"] = "ssl";
})(BackendProtocol = exports.BackendProtocol || (exports.BackendProtocol = {}));
//# sourceMappingURL=data:application/json;base64,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