import * as cdk8s from 'cdk8s';
import { Construct } from 'constructs';
import { Cdk8sConstruct, Cdk8sConstructProps } from './cdk8s-construct';
import * as k8s from './k8s';
export interface INamespace {
    readonly name: string;
}
export declare type NamespaceProps = Cdk8sConstructProps;
export declare class Namespace extends Cdk8sConstruct implements INamespace {
    static fromNamespaceName(name: string): INamespace;
    readonly apiObject: k8s.Namespace;
    constructor(scope: Construct, id: string, props: NamespaceProps);
    get name(): string;
    get metadata(): cdk8s.ApiObjectMetadataDefinition;
}
