"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Namespace = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_construct_1 = require("./cdk8s-construct");
const k8s = require("./k8s");
const utils_1 = require("./utils");
class Namespace extends cdk8s_construct_1.Cdk8sConstruct {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.apiObject = new k8s.Namespace(this.chart, 'Namespace', {
            metadata: utils_1.generateMetadata(props.metadata),
        });
    }
    static fromNamespaceName(name) {
        return {
            name,
        };
    }
    get name() {
        return this.apiObject.name;
    }
    get metadata() {
        return this.apiObject.metadata;
    }
}
exports.Namespace = Namespace;
_a = JSII_RTTI_SYMBOL_1;
Namespace[_a] = { fqn: "cdkeks.Namespace", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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