import { Construct } from '@aws-cdk/core';
import * as cdk8s from 'cdk8s';
import * as kplus from 'cdk8s-plus-17';
import { Cdk8sConstruct, Cdk8sConstructProps } from './cdk8s-construct';
export interface NginxIngressProps extends Cdk8sConstructProps {
    readonly rewriteTarget?: string;
    readonly sslRedirect?: boolean;
    readonly forceSslRedirect?: boolean;
    readonly rules?: kplus.IngressV1Beta1Rule[];
}
export declare class NginxIngress extends Cdk8sConstruct {
    private readonly apiObject;
    constructor(scope: Construct, id: string, props: NginxIngressProps);
    addRule(path: string, backend: kplus.IngressV1Beta1Backend): void;
    get name(): string;
    get metadata(): cdk8s.ApiObjectMetadataDefinition;
}
