"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NginxIngress = void 0;
const kplus = require("cdk8s-plus-17");
const cdk8s_construct_1 = require("./cdk8s-construct");
const utils_1 = require("./utils");
class NginxIngress extends cdk8s_construct_1.Cdk8sConstruct {
    constructor(scope, id, props) {
        super(scope, id, props);
        const annotations = {
            'kubernetes.io/ingress.class': 'nginx',
        };
        if (props.rewriteTarget) {
            annotations['nginx.ingress.kubernetes.io/rewrite-target'] = props.rewriteTarget;
        }
        this.apiObject = new kplus.IngressV1Beta1(this.chart, 'ingress', {
            metadata: utils_1.generateMetadata(props.metadata, annotations),
            rules: props.rules,
        });
    }
    addRule(path, backend) {
        this.apiObject.addRule(path, backend);
    }
    get name() {
        return this.apiObject.name;
    }
    get metadata() {
        return this.apiObject.metadata;
    }
}
exports.NginxIngress = NginxIngress;
//# sourceMappingURL=data:application/json;base64,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