import { ICluster, HelmChart, HelmChartOptions, KubernetesManifest } from '@aws-cdk/aws-eks';
import { Construct as CoreConstruct } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IAddon } from './addons';
export interface PlatformProps {
    readonly cluster: ICluster;
    readonly addons?: IAddon[];
    /**
     * @default false;
     */
    readonly strict?: boolean;
}
export declare class Platform extends CoreConstruct {
    readonly cluster: ICluster;
    readonly strict: boolean;
    constructor(scope: Construct, id: string, props: PlatformProps);
    addAddon(addon: IAddon): void;
    addManifest(id: string, ...manifest: Record<string, unknown>[]): KubernetesManifest;
    addHelmChart(id: string, options: HelmChartOptions): HelmChart;
    addCdk8sChart(id: string, chart: Construct): KubernetesManifest;
}
