"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Platform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
class Platform extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.cluster = props.cluster;
        this.strict = !!props.strict;
        if (props.addons) {
            props.addons.forEach((addon) => this.addAddon(addon));
        }
    }
    addAddon(addon) {
        addon.install(this, this);
    }
    addManifest(id, ...manifest) {
        return this.cluster.addManifest(id, manifest);
    }
    addHelmChart(id, options) {
        return this.cluster.addHelmChart(id, options);
    }
    addCdk8sChart(id, chart) {
        return this.cluster.addCdk8sChart(id, chart);
    }
}
exports.Platform = Platform;
_a = JSII_RTTI_SYMBOL_1;
Platform[_a] = { fqn: "cdkeks.Platform", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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