import { AddToPrincipalPolicyResult, IPrincipal, IRole, PolicyStatement, PrincipalPolicyFragment } from '@aws-cdk/aws-iam';
import * as cdk8s from 'cdk8s';
import * as kplus from 'cdk8s-plus-17';
import { Construct } from 'constructs';
import { Cdk8sConstruct, Cdk8sConstructProps } from './cdk8s-construct';
export interface ServiceAccountProps extends Cdk8sConstructProps {
    readonly secrets?: kplus.ISecret[];
}
export declare class ServiceAccount extends Cdk8sConstruct implements IPrincipal {
    readonly role: IRole;
    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     */
    readonly assumeRoleAction: string;
    /**
     * The principal to grant permissions to.
     */
    readonly grantPrincipal: IPrincipal;
    /**
     * Return the policy fragment that identifies this principal in a Policy.
     */
    readonly policyFragment: PrincipalPolicyFragment;
    readonly apiObject: kplus.ServiceAccount;
    constructor(scope: Construct, id: string, props: ServiceAccountProps);
    /**
     * (deprecated) (deprecated) Add to the policy of this principal.
     *
     * @deprecated use `addToPrincipalPolicy()`
     */
    addToPolicy(statement: PolicyStatement): boolean;
    /**
     * Add to the policy of this principal.
     */
    addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult;
    get name(): string;
    get metadata(): cdk8s.ApiObjectMetadataDefinition;
}
