"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceAccount = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const kplus = require("cdk8s-plus-17");
const cdk8s_construct_1 = require("./cdk8s-construct");
const utils_1 = require("./utils");
class ServiceAccount extends cdk8s_construct_1.Cdk8sConstruct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        const { name = core_1.Names.uniqueId(this).toLowerCase(), namespace = 'default' } = (_b = props.metadata) !== null && _b !== void 0 ? _b : {};
        const conditions = new core_1.CfnJson(this, 'ConditionJson', {
            value: {
                [`${props.platform.cluster.openIdConnectProvider.openIdConnectProviderIssuer}:aud`]: 'sts.amazonaws.com',
                [`${props.platform.cluster.openIdConnectProvider.openIdConnectProviderIssuer}:sub`]: `system:serviceaccount:${namespace}:${name}`,
            },
        });
        const principal = new aws_iam_1.OpenIdConnectPrincipal(props.platform.cluster.openIdConnectProvider).withConditions({
            StringEquals: conditions,
        });
        this.role = new aws_iam_1.Role(this, 'Role', { assumedBy: principal });
        this.assumeRoleAction = this.role.assumeRoleAction;
        this.grantPrincipal = this.role.grantPrincipal;
        this.policyFragment = this.role.policyFragment;
        const annotation = {
            'eks.amazonaws.com/role-arn': this.role.roleArn,
        };
        this.apiObject = new kplus.ServiceAccount(this.chart, 'ServiceAccount', {
            metadata: utils_1.generateMetadata({
                ...props.metadata,
                name,
                namespace,
            }, annotation),
            secrets: props.secrets,
        });
    }
    /**
     * (deprecated) (deprecated) Add to the policy of this principal.
     *
     * @deprecated use `addToPrincipalPolicy()`
     */
    addToPolicy(statement) {
        return this.addToPrincipalPolicy(statement).statementAdded;
    }
    /**
     * Add to the policy of this principal.
     */
    addToPrincipalPolicy(statement) {
        return this.role.addToPrincipalPolicy(statement);
    }
    get name() {
        return this.apiObject.name;
    }
    get metadata() {
        return this.apiObject.metadata;
    }
}
exports.ServiceAccount = ServiceAccount;
_a = JSII_RTTI_SYMBOL_1;
ServiceAccount[_a] = { fqn: "cdkeks.ServiceAccount", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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