import * as cdk8s from 'cdk8s';
import * as kplus from 'cdk8s-plus-17';
import { Construct } from 'constructs';
import { Cdk8sConstruct, Cdk8sConstructProps } from './cdk8s-construct';
import { Deployment } from './deployment';
export interface ServiceProps extends Cdk8sConstructProps {
    /**
     * @default ServiceType.CLUSTER_IP
     */
    readonly type?: ServiceType;
    readonly ports?: kplus.ServicePort[];
}
export declare class Service extends Cdk8sConstruct {
    readonly apiObject: kplus.Service;
    constructor(scope: Construct, id: string, props: ServiceProps);
    addSelector(label: string, value: string): void;
    addDeployment(deployment: Deployment, port: number, options?: kplus.ServicePortOptions): void;
    get selector(): Record<string, string>;
    get ports(): kplus.ServicePort[];
    get name(): string;
    get metadata(): cdk8s.ApiObjectMetadataDefinition;
}
export declare enum ServiceType {
    CLUSTER_IP = "ClusterIP",
    NODE_PORT = "NodePort",
    LOAD_BALANCER = "LoadBalancer",
    EXTERNAL_NAME = "ExternalName"
}
