"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceType = exports.Service = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const kplus = require("cdk8s-plus-17");
const cdk8s_construct_1 = require("./cdk8s-construct");
const utils_1 = require("./utils");
class Service extends cdk8s_construct_1.Cdk8sConstruct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.apiObject = new kplus.Service(this.chart, 'Service', {
            metadata: utils_1.generateMetadata(props.metadata),
            ports: props.ports,
            type: (_b = props.type) !== null && _b !== void 0 ? _b : ServiceType.CLUSTER_IP,
        });
    }
    addSelector(label, value) {
        this.apiObject.addSelector(label, value);
    }
    addDeployment(deployment, port, options = {}) {
        this.apiObject.addDeployment(deployment.apiObject, port, options);
    }
    get selector() {
        return this.apiObject.selector;
    }
    get ports() {
        return this.apiObject.ports;
    }
    get name() {
        return this.apiObject.name;
    }
    get metadata() {
        return this.apiObject.metadata;
    }
}
exports.Service = Service;
_a = JSII_RTTI_SYMBOL_1;
Service[_a] = { fqn: "cdkeks.Service", version: "0.0.4" };
var ServiceType;
(function (ServiceType) {
    ServiceType["CLUSTER_IP"] = "ClusterIP";
    ServiceType["NODE_PORT"] = "NodePort";
    ServiceType["LOAD_BALANCER"] = "LoadBalancer";
    ServiceType["EXTERNAL_NAME"] = "ExternalName";
})(ServiceType = exports.ServiceType || (exports.ServiceType = {}));
//# sourceMappingURL=data:application/json;base64,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