"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateMetadata = void 0;
const cdk8s = require("cdk8s");
function generateMetadata(metadata, additionalAnnotations) {
    const metadataDefinition = new cdk8s.ApiObjectMetadataDefinition(metadata);
    if (additionalAnnotations) {
        for (const [key, value] of Object.entries(additionalAnnotations)) {
            metadataDefinition.addAnnotation(key, value);
        }
    }
    return metadataDefinition.toJson();
}
exports.generateMetadata = generateMetadata;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0JBQStCO0FBRS9CLFNBQWdCLGdCQUFnQixDQUM5QixRQUFrQyxFQUNsQyxxQkFBOEM7SUFFOUMsTUFBTSxrQkFBa0IsR0FBRyxJQUFJLEtBQUssQ0FBQywyQkFBMkIsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUUzRSxJQUFJLHFCQUFxQixFQUFFO1FBQ3pCLEtBQUssTUFBTSxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLHFCQUFxQixDQUFDLEVBQUU7WUFDaEUsa0JBQWtCLENBQUMsYUFBYSxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsQ0FBQztTQUM5QztLQUNGO0lBRUQsT0FBTyxrQkFBa0IsQ0FBQyxNQUFNLEVBQUUsQ0FBQztBQUNyQyxDQUFDO0FBYkQsNENBYUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGs4cyBmcm9tICdjZGs4cyc7XG5cbmV4cG9ydCBmdW5jdGlvbiBnZW5lcmF0ZU1ldGFkYXRhKFxuICBtZXRhZGF0YT86IGNkazhzLkFwaU9iamVjdE1ldGFkYXRhLFxuICBhZGRpdGlvbmFsQW5ub3RhdGlvbnM/OiBSZWNvcmQ8c3RyaW5nLCBzdHJpbmc+LFxuKTogY2RrOHMuQXBpT2JqZWN0TWV0YWRhdGEgfCB1bmRlZmluZWQge1xuICBjb25zdCBtZXRhZGF0YURlZmluaXRpb24gPSBuZXcgY2RrOHMuQXBpT2JqZWN0TWV0YWRhdGFEZWZpbml0aW9uKG1ldGFkYXRhKTtcblxuICBpZiAoYWRkaXRpb25hbEFubm90YXRpb25zKSB7XG4gICAgZm9yIChjb25zdCBba2V5LCB2YWx1ZV0gb2YgT2JqZWN0LmVudHJpZXMoYWRkaXRpb25hbEFubm90YXRpb25zKSkge1xuICAgICAgbWV0YWRhdGFEZWZpbml0aW9uLmFkZEFubm90YXRpb24oa2V5LCB2YWx1ZSk7XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIG1ldGFkYXRhRGVmaW5pdGlvbi50b0pzb24oKTtcbn1cbiJdfQ==