# This file was auto-generated by Fern from our API Definition.

import typing

import httpx

from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import FlagrightEnvironment
from .resources.business_user_events.client import AsyncBusinessUserEventsClient, BusinessUserEventsClient
from .resources.business_users.client import AsyncBusinessUsersClient, BusinessUsersClient
from .resources.consumer_user_events.client import AsyncConsumerUserEventsClient, ConsumerUserEventsClient
from .resources.consumer_users.client import AsyncConsumerUsersClient, ConsumerUsersClient
from .resources.transaction_events.client import AsyncTransactionEventsClient, TransactionEventsClient
from .resources.transactions.client import AsyncTransactionsClient, TransactionsClient


class Flagright:
    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: FlagrightEnvironment = FlagrightEnvironment.DEFAULT,
        api_key: str,
        timeout: typing.Optional[float] = 60,
        httpx_client: typing.Optional[httpx.Client] = None
    ):
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx.Client(timeout=timeout) if httpx_client is None else httpx_client,
        )
        self.transactions = TransactionsClient(client_wrapper=self._client_wrapper)
        self.transaction_events = TransactionEventsClient(client_wrapper=self._client_wrapper)
        self.consumer_users = ConsumerUsersClient(client_wrapper=self._client_wrapper)
        self.business_users = BusinessUsersClient(client_wrapper=self._client_wrapper)
        self.consumer_user_events = ConsumerUserEventsClient(client_wrapper=self._client_wrapper)
        self.business_user_events = BusinessUserEventsClient(client_wrapper=self._client_wrapper)


class AsyncFlagright:
    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: FlagrightEnvironment = FlagrightEnvironment.DEFAULT,
        api_key: str,
        timeout: typing.Optional[float] = 60,
        httpx_client: typing.Optional[httpx.AsyncClient] = None
    ):
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            httpx_client=httpx.AsyncClient(timeout=timeout) if httpx_client is None else httpx_client,
        )
        self.transactions = AsyncTransactionsClient(client_wrapper=self._client_wrapper)
        self.transaction_events = AsyncTransactionEventsClient(client_wrapper=self._client_wrapper)
        self.consumer_users = AsyncConsumerUsersClient(client_wrapper=self._client_wrapper)
        self.business_users = AsyncBusinessUsersClient(client_wrapper=self._client_wrapper)
        self.consumer_user_events = AsyncConsumerUserEventsClient(client_wrapper=self._client_wrapper)
        self.business_user_events = AsyncBusinessUserEventsClient(client_wrapper=self._client_wrapper)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: FlagrightEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
