# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .webhook_event_base_triggered_by import WebhookEventBaseTriggeredBy

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class WebhookEventBase(pydantic.BaseModel):
    id: str = pydantic.Field(description="Unique identifier for the event")
    triggered_by: WebhookEventBaseTriggeredBy = pydantic.Field(
        alias="triggeredBy", description="Event triggered by a user or system"
    )
    created_timestamp: float = pydantic.Field(
        alias="createdTimestamp",
        description="Time at which the event was created. Measured in ms since the Unix epoch.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
