# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .contact_details import ContactDetails
from .legal_document import LegalDocument
from .pep_status import PepStatus
from .tag import Tag
from .user_details import UserDetails

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Person(pydantic.BaseModel):
    """
    Model for a generic individual - different from User model by not having userId field
    """

    general_details: UserDetails = pydantic.Field(alias="generalDetails")
    legal_documents: typing.Optional[typing.List[LegalDocument]] = pydantic.Field(
        alias="legalDocuments", description="User's legal identity documents - See Document Model for details"
    )
    contact_details: typing.Optional[ContactDetails] = pydantic.Field(alias="contactDetails")
    pep_status: typing.Optional[typing.List[PepStatus]] = pydantic.Field(alias="pepStatus")
    tags: typing.Optional[typing.List[Tag]] = pydantic.Field(
        description="Additional information that can be added via tags"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
