import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelDataConnectorOfficePowerBiConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_power_bi#id SentinelDataConnectorOfficePowerBi#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_power_bi#log_analytics_workspace_id SentinelDataConnectorOfficePowerBi#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_power_bi#name SentinelDataConnectorOfficePowerBi#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_power_bi#tenant_id SentinelDataConnectorOfficePowerBi#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_power_bi#timeouts SentinelDataConnectorOfficePowerBi#timeouts}
    */
    readonly timeouts?: SentinelDataConnectorOfficePowerBiTimeouts;
}
export interface SentinelDataConnectorOfficePowerBiTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_power_bi#create SentinelDataConnectorOfficePowerBi#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_power_bi#delete SentinelDataConnectorOfficePowerBi#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_power_bi#read SentinelDataConnectorOfficePowerBi#read}
    */
    readonly read?: string;
}
export declare function sentinelDataConnectorOfficePowerBiTimeoutsToTerraform(struct?: SentinelDataConnectorOfficePowerBiTimeoutsOutputReference | SentinelDataConnectorOfficePowerBiTimeouts | cdktf.IResolvable): any;
export declare class SentinelDataConnectorOfficePowerBiTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelDataConnectorOfficePowerBiTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelDataConnectorOfficePowerBiTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_power_bi azurerm_sentinel_data_connector_office_power_bi}
*/
export declare class SentinelDataConnectorOfficePowerBi extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sentinel_data_connector_office_power_bi";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_data_connector_office_power_bi azurerm_sentinel_data_connector_office_power_bi} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelDataConnectorOfficePowerBiConfig
    */
    constructor(scope: Construct, id: string, config: SentinelDataConnectorOfficePowerBiConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    resetTenantId(): void;
    get tenantIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SentinelDataConnectorOfficePowerBiTimeoutsOutputReference;
    putTimeouts(value: SentinelDataConnectorOfficePowerBiTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SentinelDataConnectorOfficePowerBiTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
