# generated by datamodel-codegen:
#   filename:  auth/ldapConfiguration.json
#   timestamp: 2022-12-22T05:17:32+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field


class LdapConfiguration(BaseModel):
    class Config:
        extra = Extra.forbid

    host: str = Field(
        ..., description='LDAP server address without scheme(Example :- localhost)'
    )
    port: int = Field(..., description='Port of the server')
    maxPoolSize: Optional[int] = Field(
        3, description='No of connection to create the pool with'
    )
    isFullDn: Optional[bool] = Field(
        False, description='If enable need to give full dn to login'
    )
    dnAdminPrincipal: str = Field(
        ..., description='Distinguished Admin name with search capabilities'
    )
    dnAdminPassword: str = Field(..., description='Password for LDAP Admin')
    sslEnabled: Optional[bool] = Field(False, description='Ldaps or Ldap')
    keyStorePath: Optional[str] = Field(
        None, description='Path of the Keystore for SSL'
    )
    keyStorePassword: Optional[str] = Field(
        None, description='Password of the Keystore'
    )
    userBaseDN: str = Field(..., description='Password for LDAP Admin')
    mailAttributeName: str = Field(..., description='Password for LDAP Admin')
    truststoreFormat: Optional[str] = Field(None, description='Password for LDAP Admin')
    verifyCertificateHostname: Optional[bool] = Field(
        False,
        description='If true use HostNameSSLVerifier(only then trust store cn as hostname) else TrustAll ',
    )
