# generated by datamodel-codegen:
#   filename:  dataInsight/dataInsightChart.json
#   timestamp: 2022-12-22T05:17:32+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ..type import basic, entityHistory, entityReference


class ChartDataType(Enum):
    NUMBER = 'NUMBER'
    INT = 'INT'
    FLOAT = 'FLOAT'
    DOUBLE = 'DOUBLE'
    DECIMAL = 'DECIMAL'
    TIMESTAMP = 'TIMESTAMP'
    TIME = 'TIME'
    DATE = 'DATE'
    DATETIME = 'DATETIME'
    ARRAY = 'ARRAY'
    MAP = 'MAP'
    SET = 'SET'
    STRING = 'STRING'
    BOOLEAN = 'BOOLEAN'
    PERCENTAGE = 'PERCENTAGE'


class ChartParameterValues(BaseModel):
    name: Optional[str] = Field(None, description='name of the parameter.')
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this parameter name.'
    )
    chartDataType: Optional[ChartDataType] = Field(
        None, description='Data type of the parameter (int, date etc.).'
    )


class DataReportIndex(Enum):
    entity_report_data_index = 'entity_report_data_index'
    web_analytic_entity_view_report_data_index = (
        'web_analytic_entity_view_report_data_index'
    )
    web_analytic_user_activity_report_data_index = (
        'web_analytic_user_activity_report_data_index'
    )


class DataInsightChart(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier of this table instance.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that identifies this data insight chart.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this data insight chart.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the data insight chart.'
    )
    dataIndexType: Optional[DataReportIndex] = None
    dimensions: Optional[List[ChartParameterValues]] = None
    metrics: Optional[List[ChartParameterValues]] = None
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Pipeline.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
