# generated by datamodel-codegen:
#   filename:  dataInsight/dataInsightChartResult.json
#   timestamp: 2022-12-22T05:17:32+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Extra, Field

from .type import (
    dailyActiveUsers,
    mostActiveUsers,
    mostViewedEntities,
    pageViewsByEntities,
    percentageOfEntitiesWithDescriptionByType,
    percentageOfEntitiesWithOwnerByType,
    totalEntitiesByTier,
    totalEntitiesByType,
)


class DataInsightChartType(Enum):
    TotalEntitiesByType = 'TotalEntitiesByType'
    TotalEntitiesByTier = 'TotalEntitiesByTier'
    PercentageOfEntitiesWithDescriptionByType = (
        'PercentageOfEntitiesWithDescriptionByType'
    )
    PercentageOfEntitiesWithOwnerByType = 'PercentageOfEntitiesWithOwnerByType'
    DailyActiveUsers = 'DailyActiveUsers'
    MostActiveUsers = 'MostActiveUsers'
    MostViewedEntities = 'MostViewedEntities'
    PageViewsByEntities = 'PageViewsByEntities'


class DataInsightChartResult(BaseModel):
    class Config:
        extra = Extra.forbid

    chartType: DataInsightChartType = Field(
        ...,
        description='Chart Type that will consume the data. Must match name of dataInsightChart.',
    )
    data: Optional[
        List[
            Union[
                percentageOfEntitiesWithDescriptionByType.PercentageOfEntitiesWithDescriptionByType,
                percentageOfEntitiesWithOwnerByType.PercentageOfEntitiesWithOwnerByType,
                totalEntitiesByTier.TotalEntitiesByTier,
                totalEntitiesByType.TotalEntitiesByType,
                dailyActiveUsers.DailyActiveUsers,
                pageViewsByEntities.PageViewsByEntities,
                mostActiveUsers.MostActiveUsers,
                mostViewedEntities.MostViewedEntities,
            ]
        ]
    ] = Field(None, description='Array of consumable data.')
