# generated by datamodel-codegen:
#   filename:  metadataIngestion/dbtPipeline.json
#   timestamp: 2022-12-22T05:17:32+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from .dbtconfig import (
    dbtCloudConfig,
    dbtGCSConfig,
    dbtHttpConfig,
    dbtLocalConfig,
    dbtS3Config,
)


class DbtConfigType(Enum):
    DBT = 'DBT'


class DbtPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DbtConfigType] = Field(
        DbtConfigType.DBT, description='Pipeline type'
    )
    dbtConfigSource: Optional[
        Union[
            dbtCloudConfig.DbtCloudConfig,
            dbtLocalConfig.DbtLocalConfig,
            dbtHttpConfig.DbtHttpConfig,
            dbtS3Config.DbtS3Config,
            dbtGCSConfig.DbtGcsConfig,
        ]
    ] = Field(
        None,
        description='Available sources to fetch DBT catalog and manifest files.',
        title='DBT Configuration Source',
    )
