# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSessionsResult',
    'AwaitableGetSessionsResult',
    'get_sessions',
    'get_sessions_output',
]

@pulumi.output_type
class GetSessionsResult:
    """
    A collection of values returned by getSessions.
    """
    def __init__(__self__, bastion_id=None, display_name=None, filters=None, id=None, session_id=None, session_lifecycle_state=None, sessions=None):
        if bastion_id and not isinstance(bastion_id, str):
            raise TypeError("Expected argument 'bastion_id' to be a str")
        pulumi.set(__self__, "bastion_id", bastion_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if session_id and not isinstance(session_id, str):
            raise TypeError("Expected argument 'session_id' to be a str")
        pulumi.set(__self__, "session_id", session_id)
        if session_lifecycle_state and not isinstance(session_lifecycle_state, str):
            raise TypeError("Expected argument 'session_lifecycle_state' to be a str")
        pulumi.set(__self__, "session_lifecycle_state", session_lifecycle_state)
        if sessions and not isinstance(sessions, list):
            raise TypeError("Expected argument 'sessions' to be a list")
        pulumi.set(__self__, "sessions", sessions)

    @property
    @pulumi.getter(name="bastionId")
    def bastion_id(self) -> str:
        """
        The unique identifier (OCID) of the bastion that is hosting this session.
        """
        return pulumi.get(self, "bastion_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the session.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSessionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> Optional[str]:
        return pulumi.get(self, "session_id")

    @property
    @pulumi.getter(name="sessionLifecycleState")
    def session_lifecycle_state(self) -> Optional[str]:
        return pulumi.get(self, "session_lifecycle_state")

    @property
    @pulumi.getter
    def sessions(self) -> Sequence['outputs.GetSessionsSessionResult']:
        """
        The list of sessions.
        """
        return pulumi.get(self, "sessions")


class AwaitableGetSessionsResult(GetSessionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSessionsResult(
            bastion_id=self.bastion_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            session_id=self.session_id,
            session_lifecycle_state=self.session_lifecycle_state,
            sessions=self.sessions)


def get_sessions(bastion_id: Optional[str] = None,
                 display_name: Optional[str] = None,
                 filters: Optional[Sequence[pulumi.InputType['GetSessionsFilterArgs']]] = None,
                 session_id: Optional[str] = None,
                 session_lifecycle_state: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSessionsResult:
    """
    This data source provides the list of Sessions in Oracle Cloud Infrastructure Bastion service.

    Retrieves a list of SessionSummary objects for an existing bastion. Bastion sessions let authorized users connect to a target resource for a predetermined amount of time.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sessions = oci.Bastion.get_sessions(bastion_id=oci_bastion_bastion["test_bastion"]["id"],
        display_name=var["session_display_name"],
        session_id=oci_bastion_session["test_session"]["id"],
        session_lifecycle_state=var["session_session_lifecycle_state"])
    ```


    :param str bastion_id: The unique identifier (OCID) of the bastion in which to list sessions.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str session_id: The unique identifier (OCID) of the session in which to list resources.
    :param str session_lifecycle_state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['bastionId'] = bastion_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['sessionId'] = session_id
    __args__['sessionLifecycleState'] = session_lifecycle_state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Bastion/getSessions:getSessions', __args__, opts=opts, typ=GetSessionsResult).value

    return AwaitableGetSessionsResult(
        bastion_id=pulumi.get(__ret__, 'bastion_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        session_id=pulumi.get(__ret__, 'session_id'),
        session_lifecycle_state=pulumi.get(__ret__, 'session_lifecycle_state'),
        sessions=pulumi.get(__ret__, 'sessions'))


@_utilities.lift_output_func(get_sessions)
def get_sessions_output(bastion_id: Optional[pulumi.Input[str]] = None,
                        display_name: Optional[pulumi.Input[Optional[str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSessionsFilterArgs']]]]] = None,
                        session_id: Optional[pulumi.Input[Optional[str]]] = None,
                        session_lifecycle_state: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSessionsResult]:
    """
    This data source provides the list of Sessions in Oracle Cloud Infrastructure Bastion service.

    Retrieves a list of SessionSummary objects for an existing bastion. Bastion sessions let authorized users connect to a target resource for a predetermined amount of time.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sessions = oci.Bastion.get_sessions(bastion_id=oci_bastion_bastion["test_bastion"]["id"],
        display_name=var["session_display_name"],
        session_id=oci_bastion_session["test_session"]["id"],
        session_lifecycle_state=var["session_session_lifecycle_state"])
    ```


    :param str bastion_id: The unique identifier (OCID) of the bastion in which to list sessions.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str session_id: The unique identifier (OCID) of the session in which to list resources.
    :param str session_lifecycle_state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    ...
