# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDiscoverySchedulesResult',
    'AwaitableGetDiscoverySchedulesResult',
    'get_discovery_schedules',
    'get_discovery_schedules_output',
]

@pulumi.output_type
class GetDiscoverySchedulesResult:
    """
    A collection of values returned by getDiscoverySchedules.
    """
    def __init__(__self__, compartment_id=None, discovery_schedule_collections=None, discovery_schedule_id=None, display_name=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if discovery_schedule_collections and not isinstance(discovery_schedule_collections, list):
            raise TypeError("Expected argument 'discovery_schedule_collections' to be a list")
        pulumi.set(__self__, "discovery_schedule_collections", discovery_schedule_collections)
        if discovery_schedule_id and not isinstance(discovery_schedule_id, str):
            raise TypeError("Expected argument 'discovery_schedule_id' to be a str")
        pulumi.set(__self__, "discovery_schedule_id", discovery_schedule_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the discovery schedule exists.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="discoveryScheduleCollections")
    def discovery_schedule_collections(self) -> Sequence['outputs.GetDiscoverySchedulesDiscoveryScheduleCollectionResult']:
        """
        The list of discovery_schedule_collection.
        """
        return pulumi.get(self, "discovery_schedule_collections")

    @property
    @pulumi.getter(name="discoveryScheduleId")
    def discovery_schedule_id(self) -> Optional[str]:
        return pulumi.get(self, "discovery_schedule_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name for the discovery schedule. Does not have to be unique, and it's mutable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDiscoverySchedulesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Current state of the discovery schedule.
        """
        return pulumi.get(self, "state")


class AwaitableGetDiscoverySchedulesResult(GetDiscoverySchedulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiscoverySchedulesResult(
            compartment_id=self.compartment_id,
            discovery_schedule_collections=self.discovery_schedule_collections,
            discovery_schedule_id=self.discovery_schedule_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_discovery_schedules(compartment_id: Optional[str] = None,
                            discovery_schedule_id: Optional[str] = None,
                            display_name: Optional[str] = None,
                            filters: Optional[Sequence[pulumi.InputType['GetDiscoverySchedulesFilterArgs']]] = None,
                            state: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiscoverySchedulesResult:
    """
    This data source provides the list of Discovery Schedules in Oracle Cloud Infrastructure Cloud Bridge service.

    Lists discovery schedules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_schedules = oci.CloudBridge.get_discovery_schedules(compartment_id=var["compartment_id"],
        discovery_schedule_id=oci_cloud_bridge_discovery_schedule["test_discovery_schedule"]["id"],
        display_name=var["discovery_schedule_display_name"],
        state=var["discovery_schedule_state"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str discovery_schedule_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the discovery schedule.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str state: The current state of the discovery schedule.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['discoveryScheduleId'] = discovery_schedule_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudBridge/getDiscoverySchedules:getDiscoverySchedules', __args__, opts=opts, typ=GetDiscoverySchedulesResult).value

    return AwaitableGetDiscoverySchedulesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        discovery_schedule_collections=pulumi.get(__ret__, 'discovery_schedule_collections'),
        discovery_schedule_id=pulumi.get(__ret__, 'discovery_schedule_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_discovery_schedules)
def get_discovery_schedules_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                   discovery_schedule_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDiscoverySchedulesFilterArgs']]]]] = None,
                                   state: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDiscoverySchedulesResult]:
    """
    This data source provides the list of Discovery Schedules in Oracle Cloud Infrastructure Cloud Bridge service.

    Lists discovery schedules.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_discovery_schedules = oci.CloudBridge.get_discovery_schedules(compartment_id=var["compartment_id"],
        discovery_schedule_id=oci_cloud_bridge_discovery_schedule["test_discovery_schedule"]["id"],
        display_name=var["discovery_schedule_display_name"],
        state=var["discovery_schedule_state"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str discovery_schedule_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the discovery schedule.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str state: The current state of the discovery schedule.
    """
    ...
