# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VaultVerificationArgs', 'VaultVerification']

@pulumi.input_type
class VaultVerificationArgs:
    def __init__(__self__, *,
                 replica_region: pulumi.Input[str],
                 vault_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a VaultVerification resource.
        :param pulumi.Input[str] replica_region: (Updatable) The region to be created replica to. When updated,
               replica will be deleted from old region, and created to updated region.
        :param pulumi.Input[str] vault_id: The OCID of the primary vault to create replica from.
        """
        pulumi.set(__self__, "replica_region", replica_region)
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="replicaRegion")
    def replica_region(self) -> pulumi.Input[str]:
        """
        (Updatable) The region to be created replica to. When updated,
        replica will be deleted from old region, and created to updated region.
        """
        return pulumi.get(self, "replica_region")

    @replica_region.setter
    def replica_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "replica_region", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[str]:
        """
        The OCID of the primary vault to create replica from.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vault_id", value)


@pulumi.input_type
class _VaultVerificationState:
    def __init__(__self__, *,
                 replica_region: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VaultVerification resources.
        :param pulumi.Input[str] replica_region: (Updatable) The region to be created replica to. When updated,
               replica will be deleted from old region, and created to updated region.
        :param pulumi.Input[str] vault_id: The OCID of the primary vault to create replica from.
        """
        if replica_region is not None:
            pulumi.set(__self__, "replica_region", replica_region)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="replicaRegion")
    def replica_region(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The region to be created replica to. When updated,
        replica will be deleted from old region, and created to updated region.
        """
        return pulumi.get(self, "replica_region")

    @replica_region.setter
    def replica_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_region", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the primary vault to create replica from.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)


class VaultVerification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 replica_region: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This source triggers action to create, update and delete replica for a vault in Oracle Cloud Infrastructure Kms service.

        A vault replica is a mirror of that vault in a different region in the same realm.
        The vault replica and all the resources have same OCID with corresponding original ones.

        This only supports virtual private vault for now.
        This supports only one replica in a region for a vault. Multiple replica will be supported in the future.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_replication = oci.kms.VaultVerification("testReplication",
            vault_id=oci_kms_vault["test_vault"]["id"],
            replica_region=var["replica_region"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] replica_region: (Updatable) The region to be created replica to. When updated,
               replica will be deleted from old region, and created to updated region.
        :param pulumi.Input[str] vault_id: The OCID of the primary vault to create replica from.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VaultVerificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This source triggers action to create, update and delete replica for a vault in Oracle Cloud Infrastructure Kms service.

        A vault replica is a mirror of that vault in a different region in the same realm.
        The vault replica and all the resources have same OCID with corresponding original ones.

        This only supports virtual private vault for now.
        This supports only one replica in a region for a vault. Multiple replica will be supported in the future.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_replication = oci.kms.VaultVerification("testReplication",
            vault_id=oci_kms_vault["test_vault"]["id"],
            replica_region=var["replica_region"])
        ```

        :param str resource_name: The name of the resource.
        :param VaultVerificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VaultVerificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 replica_region: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VaultVerificationArgs.__new__(VaultVerificationArgs)

            if replica_region is None and not opts.urn:
                raise TypeError("Missing required property 'replica_region'")
            __props__.__dict__["replica_region"] = replica_region
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
        super(VaultVerification, __self__).__init__(
            'oci:Kms/vaultVerification:VaultVerification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            replica_region: Optional[pulumi.Input[str]] = None,
            vault_id: Optional[pulumi.Input[str]] = None) -> 'VaultVerification':
        """
        Get an existing VaultVerification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] replica_region: (Updatable) The region to be created replica to. When updated,
               replica will be deleted from old region, and created to updated region.
        :param pulumi.Input[str] vault_id: The OCID of the primary vault to create replica from.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VaultVerificationState.__new__(_VaultVerificationState)

        __props__.__dict__["replica_region"] = replica_region
        __props__.__dict__["vault_id"] = vault_id
        return VaultVerification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="replicaRegion")
    def replica_region(self) -> pulumi.Output[str]:
        """
        (Updatable) The region to be created replica to. When updated,
        replica will be deleted from old region, and created to updated region.
        """
        return pulumi.get(self, "replica_region")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[str]:
        """
        The OCID of the primary vault to create replica from.
        """
        return pulumi.get(self, "vault_id")

