# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetLogAnalyticsEntityResult',
    'AwaitableGetLogAnalyticsEntityResult',
    'get_log_analytics_entity',
    'get_log_analytics_entity_output',
]

@pulumi.output_type
class GetLogAnalyticsEntityResult:
    """
    A collection of values returned by getLogAnalyticsEntity.
    """
    def __init__(__self__, are_logs_collected=None, cloud_resource_id=None, compartment_id=None, defined_tags=None, entity_type_internal_name=None, entity_type_name=None, freeform_tags=None, hostname=None, id=None, lifecycle_details=None, log_analytics_entity_id=None, management_agent_compartment_id=None, management_agent_display_name=None, management_agent_id=None, metadatas=None, name=None, namespace=None, properties=None, source_id=None, state=None, time_created=None, time_last_discovered=None, time_updated=None, timezone_region=None):
        if are_logs_collected and not isinstance(are_logs_collected, bool):
            raise TypeError("Expected argument 'are_logs_collected' to be a bool")
        pulumi.set(__self__, "are_logs_collected", are_logs_collected)
        if cloud_resource_id and not isinstance(cloud_resource_id, str):
            raise TypeError("Expected argument 'cloud_resource_id' to be a str")
        pulumi.set(__self__, "cloud_resource_id", cloud_resource_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if entity_type_internal_name and not isinstance(entity_type_internal_name, str):
            raise TypeError("Expected argument 'entity_type_internal_name' to be a str")
        pulumi.set(__self__, "entity_type_internal_name", entity_type_internal_name)
        if entity_type_name and not isinstance(entity_type_name, str):
            raise TypeError("Expected argument 'entity_type_name' to be a str")
        pulumi.set(__self__, "entity_type_name", entity_type_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if log_analytics_entity_id and not isinstance(log_analytics_entity_id, str):
            raise TypeError("Expected argument 'log_analytics_entity_id' to be a str")
        pulumi.set(__self__, "log_analytics_entity_id", log_analytics_entity_id)
        if management_agent_compartment_id and not isinstance(management_agent_compartment_id, str):
            raise TypeError("Expected argument 'management_agent_compartment_id' to be a str")
        pulumi.set(__self__, "management_agent_compartment_id", management_agent_compartment_id)
        if management_agent_display_name and not isinstance(management_agent_display_name, str):
            raise TypeError("Expected argument 'management_agent_display_name' to be a str")
        pulumi.set(__self__, "management_agent_display_name", management_agent_display_name)
        if management_agent_id and not isinstance(management_agent_id, str):
            raise TypeError("Expected argument 'management_agent_id' to be a str")
        pulumi.set(__self__, "management_agent_id", management_agent_id)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if source_id and not isinstance(source_id, str):
            raise TypeError("Expected argument 'source_id' to be a str")
        pulumi.set(__self__, "source_id", source_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_discovered and not isinstance(time_last_discovered, str):
            raise TypeError("Expected argument 'time_last_discovered' to be a str")
        pulumi.set(__self__, "time_last_discovered", time_last_discovered)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if timezone_region and not isinstance(timezone_region, str):
            raise TypeError("Expected argument 'timezone_region' to be a str")
        pulumi.set(__self__, "timezone_region", timezone_region)

    @property
    @pulumi.getter(name="areLogsCollected")
    def are_logs_collected(self) -> bool:
        """
        The Boolean flag to indicate if logs are collected for an entity for log analytics usage.
        """
        return pulumi.get(self, "are_logs_collected")

    @property
    @pulumi.getter(name="cloudResourceId")
    def cloud_resource_id(self) -> str:
        """
        The OCID of the Cloud resource which this entity is a representation of. This may be blank when the entity represents a non-cloud resource that the customer may have on their premises.
        """
        return pulumi.get(self, "cloud_resource_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="entityTypeInternalName")
    def entity_type_internal_name(self) -> str:
        """
        Internal name for the log analytics entity type.
        """
        return pulumi.get(self, "entity_type_internal_name")

    @property
    @pulumi.getter(name="entityTypeName")
    def entity_type_name(self) -> str:
        """
        Log analytics entity type name.
        """
        return pulumi.get(self, "entity_type_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The hostname where the entity represented here is actually present. This would be the output one would get if they run `echo $HOSTNAME` on Linux or an equivalent OS command. This may be different from management agents host since logs may be collected remotely.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The log analytics entity OCID. This ID is a reference used by log analytics features and it represents a resource that is provisioned and managed by the customer on their premises or on the cloud.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        lifecycleDetails has additional information regarding substeps such as management agent plugin deployment.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="logAnalyticsEntityId")
    def log_analytics_entity_id(self) -> str:
        return pulumi.get(self, "log_analytics_entity_id")

    @property
    @pulumi.getter(name="managementAgentCompartmentId")
    def management_agent_compartment_id(self) -> str:
        """
        Management agent (management-agents resource kind) compartment OCID
        """
        return pulumi.get(self, "management_agent_compartment_id")

    @property
    @pulumi.getter(name="managementAgentDisplayName")
    def management_agent_display_name(self) -> str:
        """
        Management agent (management-agents resource kind) display name
        """
        return pulumi.get(self, "management_agent_display_name")

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> str:
        """
        The OCID of the Management Agent.
        """
        return pulumi.get(self, "management_agent_id")

    @property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetLogAnalyticsEntityMetadataResult']:
        """
        Details of entity metadata information.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Log analytics entity name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, Any]:
        """
        The name/value pairs for parameter values to be used in file patterns specified in log sources.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> str:
        """
        This indicates the type of source. It is primarily for Enterprise Manager Repository ID.
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the log analytics entity.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastDiscovered")
    def time_last_discovered(self) -> str:
        """
        The date and time the resource was last discovered, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_discovered")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timezoneRegion")
    def timezone_region(self) -> str:
        """
        The timezone region of the log analytics entity.
        """
        return pulumi.get(self, "timezone_region")


class AwaitableGetLogAnalyticsEntityResult(GetLogAnalyticsEntityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsEntityResult(
            are_logs_collected=self.are_logs_collected,
            cloud_resource_id=self.cloud_resource_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            entity_type_internal_name=self.entity_type_internal_name,
            entity_type_name=self.entity_type_name,
            freeform_tags=self.freeform_tags,
            hostname=self.hostname,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            log_analytics_entity_id=self.log_analytics_entity_id,
            management_agent_compartment_id=self.management_agent_compartment_id,
            management_agent_display_name=self.management_agent_display_name,
            management_agent_id=self.management_agent_id,
            metadatas=self.metadatas,
            name=self.name,
            namespace=self.namespace,
            properties=self.properties,
            source_id=self.source_id,
            state=self.state,
            time_created=self.time_created,
            time_last_discovered=self.time_last_discovered,
            time_updated=self.time_updated,
            timezone_region=self.timezone_region)


def get_log_analytics_entity(log_analytics_entity_id: Optional[str] = None,
                             namespace: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsEntityResult:
    """
    This data source provides details about a specific Log Analytics Entity resource in Oracle Cloud Infrastructure Log Analytics service.

    Retrieve the log analytics entity with the given id.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entity = oci.LogAnalytics.get_log_analytics_entity(log_analytics_entity_id=oci_log_analytics_log_analytics_entity["test_log_analytics_entity"]["id"],
        namespace=var["log_analytics_entity_namespace"])
    ```


    :param str log_analytics_entity_id: The log analytics entity OCID.
    :param str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['logAnalyticsEntityId'] = log_analytics_entity_id
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsEntity:getLogAnalyticsEntity', __args__, opts=opts, typ=GetLogAnalyticsEntityResult).value

    return AwaitableGetLogAnalyticsEntityResult(
        are_logs_collected=pulumi.get(__ret__, 'are_logs_collected'),
        cloud_resource_id=pulumi.get(__ret__, 'cloud_resource_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        entity_type_internal_name=pulumi.get(__ret__, 'entity_type_internal_name'),
        entity_type_name=pulumi.get(__ret__, 'entity_type_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        log_analytics_entity_id=pulumi.get(__ret__, 'log_analytics_entity_id'),
        management_agent_compartment_id=pulumi.get(__ret__, 'management_agent_compartment_id'),
        management_agent_display_name=pulumi.get(__ret__, 'management_agent_display_name'),
        management_agent_id=pulumi.get(__ret__, 'management_agent_id'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        properties=pulumi.get(__ret__, 'properties'),
        source_id=pulumi.get(__ret__, 'source_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_discovered=pulumi.get(__ret__, 'time_last_discovered'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        timezone_region=pulumi.get(__ret__, 'timezone_region'))


@_utilities.lift_output_func(get_log_analytics_entity)
def get_log_analytics_entity_output(log_analytics_entity_id: Optional[pulumi.Input[str]] = None,
                                    namespace: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLogAnalyticsEntityResult]:
    """
    This data source provides details about a specific Log Analytics Entity resource in Oracle Cloud Infrastructure Log Analytics service.

    Retrieve the log analytics entity with the given id.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entity = oci.LogAnalytics.get_log_analytics_entity(log_analytics_entity_id=oci_log_analytics_log_analytics_entity["test_log_analytics_entity"]["id"],
        namespace=var["log_analytics_entity_namespace"])
    ```


    :param str log_analytics_entity_id: The log analytics entity OCID.
    :param str namespace: The Logging Analytics namespace used for the request.
    """
    ...
