""" Contains all the data models used in inputs/outputs """

from .add_document_attachment_order_multipart_data import (
    AddDocumentAttachmentOrderMultipartData,
)
from .add_document_leave_multipart_data import AddDocumentLeaveMultipartData
from .add_document_loan_multipart_data import AddDocumentLoanMultipartData
from .add_document_note_multipart_data import AddDocumentNoteMultipartData
from .add_document_processing_note_multipart_data import (
    AddDocumentProcessingNoteMultipartData,
)
from .address import Address
from .ae_action import AeAction
from .ae_assessment import AeAssessment
from .ae_assessment_action import AeAssessmentAction
from .ae_employee_state import AeEmployeeState
from .ae_exclusion_code import AeExclusionCode
from .ae_status import AeStatus
from .ae_statutory_letter import AeStatutoryLetter
from .ae_uk_worker import AeUKWorker
from .analysis_report import AnalysisReport
from .analysis_report_line import AnalysisReportLine
from .analysis_report_line_value import AnalysisReportLineValue
from .analysis_report_report_response import AnalysisReportReportResponse
from .apply_year_end_employer_json_body import ApplyYearEndEmployerJsonBody
from .attachment_order import AttachmentOrder
from .attachment_order_payment import AttachmentOrderPayment
from .attachment_order_report_response import AttachmentOrderReportResponse
from .attachment_order_type import AttachmentOrderType
from .audit_event_action import AuditEventAction
from .auth_scheme import AuthScheme
from .auto_enrolment import AutoEnrolment
from .auto_enrolment_settings import AutoEnrolmentSettings
from .auto_pilot_finalise_time import AutoPilotFinaliseTime
from .automation_settings import AutomationSettings
from .average_weekly_earnings import AverageWeeklyEarnings
from .average_weekly_earnings_result import AverageWeeklyEarningsResult
from .background_task_status import BackgroundTaskStatus
from .bank_details import BankDetails
from .bank_holiday_collection import BankHolidayCollection
from .bank_payment_instruction import BankPaymentInstruction
from .bank_payment_instruction_report_response import (
    BankPaymentInstructionReportResponse,
)
from .bank_payment_instructions_csv_format import BankPaymentInstructionsCsvFormat
from .benefit import Benefit
from .benefit_declaration_type import BenefitDeclarationType
from .benefit_details_asset_type import BenefitDetailsAssetType
from .benefit_details_car import BenefitDetailsCar
from .benefit_details_car_power_type import BenefitDetailsCarPowerType
from .benefit_details_class_1a_type import BenefitDetailsClass1AType
from .benefit_details_loan import BenefitDetailsLoan
from .benefit_details_non_class_1a_type import BenefitDetailsNonClass1AType
from .benefit_details_payment_type import BenefitDetailsPaymentType
from .benefit_details_use_of_asset_type import BenefitDetailsUseOfAssetType
from .benefit_type import BenefitType
from .bureau_settings import BureauSettings
from .calendar_entry import CalendarEntry
from .calendar_entry_type import CalendarEntryType
from .car_charge import CarCharge
from .car_charge_rate import CarChargeRate
from .change_summary import ChangeSummary
from .cis_300 import Cis300
from .cis_300_declarations import Cis300Declarations
from .cis_300_report_response import Cis300ReportResponse
from .cis_contractor import CisContractor
from .cis_details import CisDetails
from .cis_partnership import CisPartnership
from .cis_request import CisRequest
from .cis_return import CisReturn
from .cis_statement import CisStatement
from .cis_statement_list_report_response import CisStatementListReportResponse
from .cis_sub_contractor import CisSubContractor
from .cis_sub_contractor_summary import CisSubContractorSummary
from .cis_sub_contractor_summary_list_report_response import (
    CisSubContractorSummaryListReportResponse,
)
from .cis_sub_contractor_type import CISSubContractorType
from .cis_tax_status import CISTaxStatus
from .cis_verification import CisVerification
from .cis_verification_details import CisVerificationDetails
from .cookie_preference import CookiePreference
from .cost_analysis_report import CostAnalysisReport
from .cost_analysis_report_report_response import CostAnalysisReportReportResponse
from .cost_breakdown import CostBreakdown
from .cost_breakdown_breakdown import CostBreakdownBreakdown
from .cost_of_employment_report import CostOfEmploymentReport
from .cost_of_employment_report_line import CostOfEmploymentReportLine
from .cost_of_employment_report_report_response import (
    CostOfEmploymentReportReportResponse,
)
from .country import Country
from .csv_file_format import CsvFileFormat
from .deferal_period_type import DeferalPeriodType
from .department import Department
from .department_membership import DepartmentMembership
from .direct_debit_mandate import DirectDebitMandate
from .directorship_details import DirectorshipDetails
from .dps_data_type import DpsDataType
from .dps_notice import DpsNotice
from .dps_settings import DpsSettings
from .email_attachment import EmailAttachment
from .emp_refs import EmpRefs
from .employee import Employee
from .employee_benefits_report import EmployeeBenefitsReport
from .employee_benefits_report_report_response import (
    EmployeeBenefitsReportReportResponse,
)
from .employee_status import EmployeeStatus
from .employee_ytd_values import EmployeeYtdValues
from .employer import Employer
from .employer_defaults import EmployerDefaults
from .employer_email import EmployerEmail
from .employer_group import EmployerGroup
from .employer_group_membership import EmployerGroupMembership
from .employer_item import EmployerItem
from .employer_opening_balances import EmployerOpeningBalances
from .employer_settings import EmployerSettings
from .employer_template import EmployerTemplate
from .employer_template_type import EmployerTemplateType
from .employment_details import EmploymentDetails
from .entity_type import EntityType
from .eps import Eps
from .eps_account import EpsAccount
from .eps_apprenticeship_levy import EpsApprenticeshipLevy
from .eps_de_minimis_state_aid import EpsDeMinimisStateAid
from .eps_final_submission import EpsFinalSubmission
from .exb import Exb
from .exb_declarations import ExbDeclarations
from .exb_employer import ExbEmployer
from .exb_p11_db import ExbP11Db
from .exb_p11_db_class_1a import ExbP11DbClass1A
from .exb_p11_db_class_1a_adjustment import ExbP11DbClass1AAdjustment
from .exb_p11_db_class_1a_adjustments import ExbP11DbClass1AAdjustments
from .exb_p11_db_class_1a_total_benefit import ExbP11DbClass1ATotalBenefit
from .exb_p11d import ExbP11D
from .exb_p11d_employee import ExbP11DEmployee
from .exb_report_response import ExbReportResponse
from .expenses_and_benefits import ExpensesAndBenefits
from .external_data_company import ExternalDataCompany
from .external_data_provider import ExternalDataProvider
from .external_data_provider_id import ExternalDataProviderId
from .external_data_provider_type import ExternalDataProviderType
from .external_employee_mapping import ExternalEmployeeMapping
from .external_employee_mapping_status import ExternalEmployeeMappingStatus
from .external_provider_conversation import ExternalProviderConversation
from .field_modification import FieldModification
from .finalise_pay_run_pay_run_json_body import FinalisePayRunPayRunJsonBody
from .fixed_code import FixedCode
from .fps import Fps
from .fps_benefit import FpsBenefit
from .fps_car import FpsCar
from .fps_car_fuel import FpsCarFuel
from .fps_employee import FpsEmployee
from .fps_employee_details import FpsEmployeeDetails
from .fps_employee_details_partner_details import FpsEmployeeDetailsPartnerDetails
from .fps_employee_figs_to_date import FpsEmployeeFigsToDate
from .fps_employee_flexible_drawdown import FpsEmployeeFlexibleDrawdown
from .fps_employee_n_iletters_and_values import FpsEmployeeNIlettersAndValues
from .fps_employee_payment import FpsEmployeePayment
from .fps_employee_starter import FpsEmployeeStarter
from .fps_employee_starter_occ_pension import FpsEmployeeStarterOccPension
from .fps_employee_tax_code import FpsEmployeeTaxCode
from .fps_employee_trivial_commutation_payment import (
    FpsEmployeeTrivialCommutationPayment,
)
from .fps_employer_pay_id_changed import FpsEmployerPayIdChanged
from .fps_employment import FpsEmployment
from .fps_fields import FpsFields
from .fps_late_reason import FpsLateReason
from .fps_report_response import FpsReportResponse
from .from_to_dates import FromToDates
from .full_payment_submission import FullPaymentSubmission
from .full_summary_of_pay_report import FullSummaryOfPayReport
from .full_summary_of_pay_report_line import FullSummaryOfPayReportLine
from .full_summary_of_pay_report_report_response import (
    FullSummaryOfPayReportReportResponse,
)
from .furlough_calculation_basis import FurloughCalculationBasis
from .furlough_report import FurloughReport
from .furlough_report_line import FurloughReportLine
from .furlough_report_report_response import FurloughReportReportResponse
from .gender import Gender
from .gov_talk import GovTalk
from .gov_talk_error import GovTalkError
from .gov_talk_submission import GovTalkSubmission
from .gross_to_net_report import GrossToNetReport
from .gross_to_net_report_cis_line import GrossToNetReportCisLine
from .gross_to_net_report_line import GrossToNetReportLine
from .gross_to_net_report_report_response import GrossToNetReportReportResponse
from .hmrc_details import HmrcDetails
from .hmrc_liability import HmrcLiability
from .hmrc_payment import HmrcPayment
from .holiday_report import HolidayReport
from .holiday_report_line import HolidayReportLine
from .holiday_report_report_response import HolidayReportReportResponse
from .holiday_type import HolidayType
from .hourly_pay_report import HourlyPayReport
from .hourly_pay_report_line import HourlyPayReportLine
from .hourly_pay_report_report_response import HourlyPayReportReportResponse
from .hours_normally_worked import HoursNormallyWorked
from .html_email_settings import HtmlEmailSettings
from .html_insertion_point import HtmlInsertionPoint
from .import_csv_employee_multipart_data import ImportCsvEmployeeMultipartData
from .import_csv_employer_multipart_data import ImportCsvEmployerMultipartData
from .invitation import Invitation
from .item import Item
from .item_list_report_response import ItemListReportResponse
from .leave import Leave
from .leave_pay_type import LeavePayType
from .leave_settings import LeaveSettings
from .leave_type import LeaveType
from .leaver_details import LeaverDetails
from .linked_piw import LinkedPiw
from .linked_piw_result import LinkedPiwResult
from .loan import Loan
from .loan_charge import LoanCharge
from .log_entry import LogEntry
from .mail_settings import MailSettings
from .marital_status import MaritalStatus
from .mileage_allowance_payments_rate import MileageAllowancePaymentsRate
from .mileage_vehicle_type import MileageVehicleType
from .monthly_minimum import MonthlyMinimum
from .national_insurance_calculation import NationalInsuranceCalculation
from .national_insurance_calculation_base import NationalInsuranceCalculationBase
from .national_insurance_calculation_period_values import (
    NationalInsuranceCalculationPeriodValues,
)
from .national_insurance_code import NationalInsuranceCode
from .national_minimum_wage import NationalMinimumWage
from .ni_letter_error import NiLetterError
from .ni_letter_validation_report import NiLetterValidationReport
from .ni_letter_validation_report_line import NiLetterValidationReportLine
from .ni_letter_validation_report_report_response import (
    NiLetterValidationReportReportResponse,
)
from .nic_summary import NicSummary
from .nominal_code_mapping import NominalCodeMapping
from .note import Note
from .note_type import NoteType
from .nvr import Nvr
from .nvr_employee import NvrEmployee
from .nvr_employee_details import NvrEmployeeDetails
from .nvr_employment import NvrEmployment
from .nvr_request import NvrRequest
from .opening_balances import OpeningBalances
from .overseas_employer_details import OverseasEmployerDetails
from .overseas_secondment_status import OverseasSecondmentStatus
from .p11 import P11
from .p11_detailed import P11Detailed
from .p11_detailed_ni_values import P11DetailedNiValues
from .p11_detailed_report_response import P11DetailedReportResponse
from .p11_line import P11Line
from .p11_ni_and_stat_payments_line import P11NiAndStatPaymentsLine
from .p11_ni_and_stat_payments_totals_line import P11NiAndStatPaymentsTotalsLine
from .p11_ni_values import P11NiValues
from .p11_paye_line import P11PayeLine
from .p11_paye_summary import P11PayeSummary
from .p11_paye_totals_line import P11PayeTotalsLine
from .p11_report_response import P11ReportResponse
from .p11d_asset_available import P11DAssetAvailable
from .p11d_asset_available_collection import P11DAssetAvailableCollection
from .p11d_asset_transferred_collection import P11DAssetTransferredCollection
from .p11d_car import P11DCar
from .p11d_car_collection import P11DCarCollection
from .p11d_car_free_fuel_withdrawn import P11DCarFreeFuelWithdrawn
from .p11d_desc_other import P11DDescOther
from .p11d_expenses import P11DExpenses
from .p11d_loan import P11DLoan
from .p11d_loan_collection import P11DLoanCollection
from .p11d_other import P11DOther
from .p11d_payment_collection import P11DPaymentCollection
from .p11d_single_item import P11DSingleItem
from .p11d_vans import P11DVans
from .p32 import P32
from .p32_report_response import P32ReportResponse
from .papdis_document import PapdisDocument
from .papdis_document_report_response import PapdisDocumentReportResponse
from .papdis_employee import PapdisEmployee
from .papdis_employee_assessment import PapdisEmployeeAssessment
from .papdis_employee_contact import PapdisEmployeeContact
from .papdis_employee_contact_postal_address import PapdisEmployeeContactPostalAddress
from .papdis_employee_contribution import PapdisEmployeeContribution
from .papdis_employee_exit import PapdisEmployeeExit
from .papdis_employee_identity import PapdisEmployeeIdentity
from .papdis_employee_name import PapdisEmployeeName
from .papdis_employee_pay import PapdisEmployeePay
from .papdis_employer import PapdisEmployer
from .papdis_message_function_code import PapdisMessageFunctionCode
from .papdis_payroll_period import PapdisPayrollPeriod
from .papdis_pension_provider import PapdisPensionProvider
from .papdis_version import PapdisVersion
from .partner_details import PartnerDetails
from .pay_basis import PayBasis
from .pay_code import PayCode
from .pay_code_calculation_type import PayCodeCalculationType
from .pay_code_multiplier_type import PayCodeMultiplierType
from .pay_line import PayLine
from .pay_method import PayMethod
from .pay_options import PayOptions
from .pay_options_import import PayOptionsImport
from .pay_period_event_type import PayPeriodEventType
from .pay_periods import PayPeriods
from .pay_run import PayRun
from .pay_run_changes import PayRunChanges
from .pay_run_cost_summary import PayRunCostSummary
from .pay_run_csv_type import PayRunCsvType
from .pay_run_entry import PayRunEntry
from .pay_run_journal import PayRunJournal
from .pay_run_payment import PayRunPayment
from .pay_run_state import PayRunState
from .pay_run_state_change import PayRunStateChange
from .pay_run_state_change_reason import PayRunStateChangeReason
from .pay_run_summary_line import PayRunSummaryLine
from .pay_run_summary_line_i_enumerable_report_response import (
    PayRunSummaryLineIEnumerableReportResponse,
)
from .pay_run_totals import PayRunTotals
from .pay_schedule import PaySchedule
from .pay_schedule_period import PaySchedulePeriod
from .pay_schedule_period_event import PaySchedulePeriodEvent
from .pay_schedule_period_events_config import PaySchedulePeriodEventsConfig
from .payee import Payee
from .payee_type import PayeeType
from .payment_date_type import PaymentDateType
from .payments_csv_mapping import PaymentsCsvMapping
from .payments_csv_mapping_column import PaymentsCsvMappingColumn
from .payments_csv_mapping_type import PaymentsCsvMappingType
from .payroll_value_type import PayrollValueType
from .payrun_email import PayrunEmail
from .payrun_payments_report import PayrunPaymentsReport
from .payrun_payments_report_report_response import PayrunPaymentsReportReportResponse
from .payslip import Payslip
from .payslip_customisation import PayslipCustomisation
from .payslip_line import PayslipLine
from .payslip_line_type import PayslipLineType
from .payslip_report_response import PayslipReportResponse
from .pdf_paper_margins import PdfPaperMargins
from .pdf_paper_orientation import PdfPaperOrientation
from .pdf_paper_size import PdfPaperSize
from .pdf_password_type import PdfPasswordType
from .pension import Pension
from .pension_administrator import PensionAdministrator
from .pension_contribution_level_type import PensionContributionLevelType
from .pension_contributions_submission import PensionContributionsSubmission
from .pension_csv_format import PensionCsvFormat
from .pension_provider import PensionProvider
from .pension_rule import PensionRule
from .pension_scheme import PensionScheme
from .pension_selection import PensionSelection
from .pension_summary import PensionSummary
from .pensioner_payroll import PensionerPayroll
from .personal_details import PersonalDetails
from .post import Post
from .pro_rata_rule import ProRataRule
from .processing_note import ProcessingNote
from .recoverable_amounts import RecoverableAmounts
from .report import Report
from .report_custom_css_option import ReportCustomCssOption
from .report_pack import ReportPack
from .report_response import ReportResponse
from .right_to_work import RightToWork
from .right_to_work_document_type import RightToWorkDocumentType
from .right_to_work_report import RightToWorkReport
from .right_to_work_report_line import RightToWorkReportLine
from .right_to_work_report_report_response import RightToWorkReportReportResponse
from .role import Role
from .rti_agent import RtiAgent
from .rti_contact import RtiContact
from .rti_employee_address import RtiEmployeeAddress
from .rti_employee_name import RtiEmployeeName
from .rti_sender_type import RtiSenderType
from .rti_submission_settings import RtiSubmissionSettings
from .rti_validation_warning import RtiValidationWarning
from .rti_validation_warning_type import RtiValidationWarningType
from .smtp_encryption import SmtpEncryption
from .smtp_settings import SmtpSettings
from .starter_declaration import StarterDeclaration
from .starter_details import StarterDetails
from .statutory_pay import StatutoryPay
from .statutory_pay_report import StatutoryPayReport
from .statutory_pay_report_line import StatutoryPayReportLine
from .statutory_pay_report_report_response import StatutoryPayReportReportResponse
from .string_string_key_value_pair import StringStringKeyValuePair
from .student_loan import StudentLoan
from .student_loan_recovered import StudentLoanRecovered
from .submission_status import SubmissionStatus
from .tag import Tag
from .tax_and_ni import TaxAndNi
from .tax_bracket import TaxBracket
from .tax_code_change import TaxCodeChange
from .tax_code_change_report import TaxCodeChangeReport
from .tax_code_change_report_report_response import TaxCodeChangeReportReportResponse
from .tax_code_change_values import TaxCodeChangeValues
from .tax_year import TaxYear
from .teachers_pension_details import TeachersPensionDetails
from .teachers_pension_employment_type import TeachersPensionEmploymentType
from .tenant import Tenant
from .tenant_billing_settings import TenantBillingSettings
from .tenant_email import TenantEmail
from .tenant_html_insertion import TenantHtmlInsertion
from .tenant_item import TenantItem
from .tiered_pension import TieredPension
from .tiered_pension_rate import TieredPensionRate
from .umbrella_payment import UmbrellaPayment
from .umbrella_reconciliation_report import UmbrellaReconciliationReport
from .umbrella_reconciliation_report_line import UmbrellaReconciliationReportLine
from .umbrella_reconciliation_report_report_response import (
    UmbrellaReconciliationReportReportResponse,
)
from .umbrella_settings import UmbrellaSettings
from .update_fav_icon_tenant_multipart_data import UpdateFavIconTenantMultipartData
from .update_logo_employer_multipart_data import UpdateLogoEmployerMultipartData
from .update_logo_tenant_multipart_data import UpdateLogoTenantMultipartData
from .update_photo_account_multipart_data import UpdatePhotoAccountMultipartData
from .update_photo_employee_multipart_data import UpdatePhotoEmployeeMultipartData
from .usage_bill import UsageBill
from .user import User
from .user_authorization import UserAuthorization
from .user_category import UserCategory
from .user_display_preferences import UserDisplayPreferences
from .user_industry import UserIndustry
from .user_job_type import UserJobType
from .userstart_page import UserstartPage
from .utm_info import UtmInfo
from .value_override import ValueOverride
from .variance_report import VarianceReport
from .variance_report_report_response import VarianceReportReportResponse
from .veteran_details import VeteranDetails
from .webhook import Webhook
from .webhook_event import WebhookEvent
from .webhook_payload import WebhookPayload
from .worker_group import WorkerGroup
from .working_pattern import WorkingPattern
from .year_end import YearEnd
from .year_end_tax_code_change import YearEndTaxCodeChange
from .ytd_pay_run_multipart_data import YtdPayRunMultipartData
from .ytd_report import YtdReport
from .ytd_report_report_response import YtdReportReportResponse
from .ytd_value import YtdValue
