#ifndef RCIM_CLIENT_H
#define RCIM_CLIENT_H

/* Warning, this file is autogenerated by cbindgen. Don't modify this manually. */

#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>

#if defined(_WIN32) && defined(USE_AS_DLL)
  #define RC_API _declspec(dllexport)
#else
  #define RC_API
#endif

/**
 * 应用前后台状态，用于心跳省电、保活策略
 */
typedef enum RcimAppState {
  /**
   * App 处于前台
   */
  RcimAppState_Foreground = 0,
  /**
   * App 处于后台
   */
  RcimAppState_Background = 1,
  /**
   * App 被系统挂起 (目前仅 iOS 使用)
   */
  RcimAppState_Hangup = 2,
  /**
   * App 进程结束，例如 App 被杀死 (目前仅 iOS 使用)
   */
  RcimAppState_Terminate = 3,
} RcimAppState;

/**
 * 地区码，不同地区合理配置就近接入的服务器地址
 */
typedef enum RcimAreaCode {
  /**
   * 北京数据中心
   */
  RcimAreaCode_Bj = 1,
  /**
   * 新加坡数据中心
   */
  RcimAreaCode_Sg = 2,
  /**
   * 北美数据中心
   */
  RcimAreaCode_Na = 3,
  /**
   * 新加坡 B 企业合作数据中心
   */
  RcimAreaCode_SgB = 4,
  /**
   * 沙特数据中心
   */
  RcimAreaCode_Sa = 5,
} RcimAreaCode;

/**
 * 聊天室成员事件类型
 */
typedef enum RcimChatroomMemberActionType {
  /**
   * 退出聊天室
   */
  RcimChatroomMemberActionType_Quit = 0,
  /**
   * 加入聊天室
   */
  RcimChatroomMemberActionType_Join = 1,
} RcimChatroomMemberActionType;

/**
 * 聊天室禁言类型
 */
typedef enum RcimChatroomMemberBannedEventType {
  /**
   * 解除指定聊天室中用户禁言
   */
  RcimChatroomMemberBannedEventType_UnmuteUser = 0,
  /**
   * 禁言指定聊天室中用户
   */
  RcimChatroomMemberBannedEventType_MuteUsers = 1,
  /**
   * 解除聊天室全体禁言
   */
  RcimChatroomMemberBannedEventType_UnmuteAll = 2,
  /**
   * 聊天室全体禁言
   */
  RcimChatroomMemberBannedEventType_MuteAll = 3,
  /**
   * 移出禁言用户白名单
   */
  RcimChatroomMemberBannedEventType_RemoveWhitelist = 4,
  /**
   * 添加禁言用户白名单
   */
  RcimChatroomMemberBannedEventType_AddWhitelist = 5,
  /**
   * 解除用户聊天室全局禁言
   */
  RcimChatroomMemberBannedEventType_UnmuteGlobal = 6,
  /**
   * 用户聊天室全局禁言
   */
  RcimChatroomMemberBannedEventType_MuteGlobal = 7,
} RcimChatroomMemberBannedEventType;

/**
 * 聊天室封禁事件
 */
typedef enum RcimChatroomMemberBlockedEventType {
  /**
   * 解封
   */
  RcimChatroomMemberBlockedEventType_Unblock = 0,
  /**
   * 封禁
   */
  RcimChatroomMemberBlockedEventType_Block = 1,
} RcimChatroomMemberBlockedEventType;

/**
 * 聊天室多端同步事件类型
 */
typedef enum RcimChatroomMultiClientSyncEventType {
  /**
   * 多端登录同步用户离开聊天室
   * 1. 同一用户在一个终端离开聊天室，通知另一个终端
   * 2. 用户多端加入聊天室场景：用户在 Android 端加入聊天室，在 Web 端登录后又加入一个新聊天室，自动将用户从上一个聊天室踢出
   */
  RcimChatroomMultiClientSyncEventType_Quit = 0,
  /**
   * 多端登录同步用户加入聊天室，同一用户在一个终端加入聊天室，通知另一个终端
   */
  RcimChatroomMultiClientSyncEventType_Join = 1,
} RcimChatroomMultiClientSyncEventType;

/**
 * 聊天室多端同步离开事件类型
 */
typedef enum RcimChatroomMultiClientSyncQuitType {
  /**
   * 自己主动离开
   */
  RcimChatroomMultiClientSyncQuitType_Manual = 1,
  /**
   * 多端加入互踢导致离开
   */
  RcimChatroomMultiClientSyncQuitType_Kick = 2,
} RcimChatroomMultiClientSyncQuitType;

/**
 * 聊天室状态
 */
typedef enum RcimChatroomStatus {
  /**
   * 空闲状态
   */
  RcimChatroomStatus_Idle = 0,
  /**
   * 加入中
   */
  RcimChatroomStatus_Joining = 1,
  /**
   * 已加入
   */
  RcimChatroomStatus_Joined = 2,
  /**
   * 加入失败
   */
  RcimChatroomStatus_JoinFailed = 3,
  /**
   * 离开中
   */
  RcimChatroomStatus_Leaving = 4,
  /**
   * 已离开
   */
  RcimChatroomStatus_Left = 5,
  /**
   * 离开失败
   */
  RcimChatroomStatus_LeaveFailed = 6,
  /**
   * 手动销毁
   */
  RcimChatroomStatus_DestroyManually = 7,
  /**
   * 自动销毁
   */
  RcimChatroomStatus_DestroyAuto = 8,
} RcimChatroomStatus;

/**
 * 公有云、私有云类型
 */
typedef enum RcimCloudType {
  /**
   * 公有云
   */
  RcimCloudType_PublicCloud = 0,
  /**
   * 主流私有云
   */
  RcimCloudType_PrivateCloud = 1,
  /**
   * 非主流私有云，密钥序列以 104 开头，较早期个别私有云客户仍在使用
   */
  RcimCloudType_PrivateCloud104,
} RcimCloudType;

/**
 * 连接状态，将 ConnectionStatus 适配 C 语言
 */
typedef enum RcimConnectionStatus {
  /**
   * 等待状态
   */
  RcimConnectionStatus_Idle = 0,
  /**
   * 连接中
   */
  RcimConnectionStatus_Connecting = 1,
  /**
   * 连接成功
   */
  RcimConnectionStatus_Connected = 2,
  /**
   * 断开连接中
   */
  RcimConnectionStatus_Disconnecting = 3,
  /**
   * 无法连接，当网络恢复后，SDK 自动连接
   */
  RcimConnectionStatus_DisconnectNetworkUnavailable = 10,
  /**
   * 无法连接，调用了 disconnect 接口，主动退出
   */
  RcimConnectionStatus_DisconnectUserLogout = 11,
  /**
   * 无法连接，License 授权过期（私有云专属）
   */
  RcimConnectionStatus_DisconnectLicenseExpired = 12,
  /**
   * 无法连接，License 不匹配（私有云专属）
   */
  RcimConnectionStatus_DisconnectLicenseMismatch = 13,
  /**
   * 无法连接，SDK 信令版本和服务信令版本不一致
   * @note 一般不会出现该问题，如果出现请联系融云
   */
  RcimConnectionStatus_DisconnectIllegalProtocolVersion = 14,
  /**
   * 无法连接，客户端（移动端 TCP 连接建立时）`info` 字段格式错误
   * @note 一般不会出现该问题，如果出现请联系融云
   */
  RcimConnectionStatus_DisconnectIdReject = 15,
  /**
   * 无法连接，不支持的平台类型，一般小程序或 PC 未开通
   * @note 一般不会出现该问题，如果出现请联系融云
   */
  RcimConnectionStatus_DisconnectPlatformUnavailable = 16,
  /**
   * 无法连接，Token 无法解析，或 Token 已过期，请更换 Token 重新连接
   * @note 经常发生在切换开发环境的时候，例如 app 用开发环境的 Token，服务端用生产环境的 appKey，或者相反的场景
   * @discussion 当发生该错误的时候检查一下 APP 使用的 appKey 和 APP Server 使用的 appKey 是否相同
   */
  RcimConnectionStatus_DisconnectTokenIncorrect = 17,
  /**
   * 无法连接，触发了防黑产规则
   * @note 请 APP 服务自查
   */
  RcimConnectionStatus_DisconnectNotAuthorized = 18,
  /**
   * 无法连接，包名不合法（移动端使用）
   * @note 一般不会出现该问题，如果出现请联系融云
   */
  RcimConnectionStatus_DisconnectPackageNameInvalid = 19,
  /**
   * 无法连接，该 AppKey 已经封禁或删除
   * @note 请自行检查融云管理后台该 AppKey 的状态
   */
  RcimConnectionStatus_DisconnectAppBlockOrDelete = 20,
  /**
   * 无法连接，该用户 ID 已经被封禁
   * @note 请自行检查融云管理后台该用户 ID 的状态
   */
  RcimConnectionStatus_DisconnectUserBlocked = 21,
  /**
   * 无法连接，用户被同账号其他端踢下线，给用户提示被踢下线
   */
  RcimConnectionStatus_DisconnectUserKicked = 22,
  /**
   * 无法连接，Token 已过期，请重新获取 Token 再连接
   */
  RcimConnectionStatus_DisconnectTokenExpired = 23,
  /**
   * 无法连接，Token 中携带 deviceId 时，检测 Token 中 deviceId 与链接设备 deviceId 不一致
   */
  RcimConnectionStatus_DisconnectDeviceError = 24,
  /**
   * 无法连接，Web 端设置安全域名后，连接端域名不在安全域名范围内
   * @note 一般不会出现该问题，如果出现请联系融云
   */
  RcimConnectionStatus_DisconnectHostnameError = 25,
  /**
   * 无法连接，开启 `禁止把已在线客户端踢下线` 开关后，该错误码标识已有同类型端在线，禁止链接
   */
  RcimConnectionStatus_DisconnectOtherDeviceLogin = 26,
  /**
   * 无法连接，连接总数量超过服务设定的并发限定值（私有云专属）
   */
  RcimConnectionStatus_DisconnectConcurrentLimitError = 27,
  /**
   * 无法连接，客户端连错环境，引发连接拒绝；如使用开发环境 AppKey 连接到生产环境
   */
  RcimConnectionStatus_DisconnectClusterError = 28,
  /**
   * 无法连接，开启 AppServer 联合鉴权功能后，到 AppServer 认证失败
   * @note 一般不会出现该问题，如果出现请联系融云
   */
  RcimConnectionStatus_DisconnectAppAuthFailed = 29,
  /**
   * 无法连接，一次性 Token 已经被使用过，重新获取 Token 进行连接
   */
  RcimConnectionStatus_DisconnectOneTimePasswordUsed = 30,
  /**
   * 无法连接，Token 绑定的平台与登录平台不符
   */
  RcimConnectionStatus_DisconnectPlatformError = 31,
  /**
   * 无法连接，用户账号已销户，不再进行连接
   */
  RcimConnectionStatus_DisconnectUserDeleteAccount = 32,
  /**
   * 无法连接，连接超时，需要调用 connect 接口重新进行连接，一般是设备的网络原因
   * @note connect 接口传入的超时时间，在这个时间范围内没有连接成功才会报该错误
   */
  RcimConnectionStatus_DisconnectConnectionTimeout = 33,
  /**
   * 无法连接，数据库打开失败
   * @note 由用户决定如何处理，用户可以将数据库备份之后再重连
   */
  RcimConnectionStatus_DisconnectDatabaseOpenFailed = 34,
} RcimConnectionStatus;

/**
 * 会话类型
 */
typedef enum RcimConversationType {
  /**
   * 未支持类型，可能是新增会话类型，需升级最新版本 SDK
   */
  RcimConversationType_NotSupportedYet = 0,
  /**
   * 私聊
   */
  RcimConversationType_Private = 1,
  /**
   * 讨论组
   */
  RcimConversationType_Discussion = 2,
  /**
   * 群组
   */
  RcimConversationType_Group = 3,
  /**
   * 聊天室
   */
  RcimConversationType_Chatroom = 4,
  /**
   * 客服
   */
  RcimConversationType_CustomerService = 5,
  /**
   * 系统
   */
  RcimConversationType_System = 6,
  /**
   * 应用公众服务
   */
  RcimConversationType_AppPublicService = 7,
  /**
   * 公众服务平台
   */
  RcimConversationType_PublicService = 8,
  /**
   * push 推送
   */
  RcimConversationType_PushService = 9,
  /**
   * 超级群
   */
  RcimConversationType_UltraGroup = 10,
  /**
   * 加密会话（仅对部分私有云用户开放，公有云用户不适用）
   */
  RcimConversationType_Encrypted = 11,
  /**
   * RTC 音视频通话类型
   */
  RcimConversationType_RtcRoom = 12,
} RcimConversationType;

/**
 * 数据库状态
 */
typedef enum RcimDatabaseStatus {
  /**
   * 未打开
   */
  RcimDatabaseStatus_Idle = 0,
  /**
   * 数据库打开成功
   */
  RcimDatabaseStatus_OpenSuccess = 1,
  /**
   * 数据库打开失败
   */
  RcimDatabaseStatus_OpenFailed = 2,
  /**
   * 数据库升级中
   */
  RcimDatabaseStatus_Upgrading = 3,
  /**
   * 数据库升级成功
   */
  RcimDatabaseStatus_UpgradeSuccess = 4,
  /**
   * 数据库升级失败
   */
  RcimDatabaseStatus_UpgradeFailed = 5,
  /**
   * 数据库错误
   */
  RcimDatabaseStatus_Error = 127,
} RcimDatabaseStatus;

/**
 * Rust 日志调式等级
 *
 * @deprecated     是否有存在价值，待确认
 */
typedef enum RcimDevLogLevel {
  RcimDevLogLevel_Error = 1,
  RcimDevLogLevel_Warn = 2,
  RcimDevLogLevel_Info = 3,
  RcimDevLogLevel_Debug = 4,
  RcimDevLogLevel_Trace = 5,
} RcimDevLogLevel;

/**
 * 断开连接模式
 */
typedef enum RcimDisconnectMode {
  /**
   * 断开连接后，保持 Push 通知。服务收到后，直接断开。
   */
  RcimDisconnectMode_KeepPush = 2,
  /**
   * 断开连接后，关闭 Push 通知。服务收到后，会先发 ACK 再断开。
   */
  RcimDisconnectMode_NoPush = 4,
} RcimDisconnectMode;

/**
 * 错误码
 */
typedef enum RcimEngineError {
  /**
   * 成功
   */
  RcimEngineError_Success = 0,
  /**
   * 被对方加入黑名单，发送消息失败
   */
  RcimEngineError_RejectedByBlackList = 405,
  /**
   * 对方开启了只接收白名单的信息，但己方不在白名单中，发送消息失败
   */
  RcimEngineError_NotWhitelisted = 407,
  /**
   * 在单聊中已被禁言
   */
  RcimEngineError_ForbiddenInPrivateChat = 20106,
  /**
   * 系统会话不支持发送该消息
   */
  RcimEngineError_ConversationNotSupportMessage = 20109,
  /**
   * 发送消息频率过高，1 秒钟最多只允许发送 5 条消息
   */
  RcimEngineError_MessageSendOverFrequency = 20604,
  /**
   * 请求超出了调用频率限制，请稍后再试
   */
  RcimEngineError_RequestOverFrequency = 20607,
  /**
   * 发送的消息中包含敏感词（发送方发送失败，接收方不会收到消息）
   */
  RcimEngineError_MessageIncludeSensitiveWord = 21501,
  /**
   * 消息中敏感词已经被替换（接收方可以收到被替换之后的消息）
   */
  RcimEngineError_MessageReplacedSensitiveWord = 21502,
  /**
   * 不在该群组中
   */
  RcimEngineError_NotInGroup = 22406,
  /**
   * 在群组中已被禁言
   */
  RcimEngineError_ForbiddenInGroupChat = 22408,
  /**
   * 在该聊天室中已被禁言
   */
  RcimEngineError_ForbiddenInChatroom = 23408,
  /**
   * 已被踢出聊天室
   */
  RcimEngineError_ChatroomKicked = 23409,
  /**
   * 聊天室不存在
   */
  RcimEngineError_ChatroomNotExist = 23410,
  /**
   * 聊天室成员超限，开发者可以提交工单申请聊天室人数限制变更。
   */
  RcimEngineError_ChatroomIsFull = 23411,
  /**
   * 不在该聊天室中
   */
  RcimEngineError_NotInChatroom = 23406,
  /**
   * 获取用户失败
   */
  RcimEngineError_GetUserError = 23407,
  /**
   * 聊天室接口参数无效。请确保参数不为 NULL 且有效。
   */
  RcimEngineError_ChatroomInvalidParameter = 23412,
  /**
   * 查询聊天室历史消息异常。
   */
  RcimEngineError_QueryChatroomHistoryError = 23413,
  /**
   * 聊天室云存储业务未开通。
   */
  RcimEngineError_RoamingServiceUnavailableChatroom = 23414,
  /**
   * 聊天室的 kv 属性个数超限，单个聊天室默认上限为 100 个
   */
  RcimEngineError_ChatroomKvCountExceed = 23423,
  /**
   * 没有权限修改聊天室中已存在的属性值
   */
  RcimEngineError_ChatroomKvOverwriteInvalidKey = 23424,
  /**
   * 超过聊天室中状态设置频率，1 个聊天室 1 秒钟最多设置和删除状态 100 次
   */
  RcimEngineError_ChatroomKvCallAPIExceed = 23425,
  /**
   * 聊天室属性自定义设置，您可以在开发者后台免费基础功能页面中开启该功能。
   */
  RcimEngineError_ChatroomKvStoreUnavailable = 23426,
  /**
   * 聊天室属性不存在
   */
  RcimEngineError_ChatroomKvNotExist = 23427,
  /**
   * 聊天室批量设置或删除 kv 部分不成功
   */
  RcimEngineError_ChatroomKvNotAllSuccess = 23428,
  /**
   * 聊天室 kv 设置/删除个数超限，批量操作个数最多 10 个
   */
  RcimEngineError_ChatroomKvLimit = 23429,
  /**
   * 聊天室设置 kv 失败，出现在两人或者多端同时操作一个 kv。如果出现该错误，为避免和其他端同时操作，请延时一定时间再试
   */
  RcimEngineError_ChatroomKvConcurrentError = 23431,
  /**
   * 撤回消息参数无效，请确认撤回消息参数是否正确的填写。
   */
  RcimEngineError_RecallParameterInvalid = 25101,
  /**
   * 未开通单群聊云存储服务
   */
  RcimEngineError_MessageStorageServiceUnavailable = 25102,
  /**
   * IMLib 撤回消息可以撤回自己发送的消息和别人发送的消息，IM 服务有开关，控制只可以撤回自己发送的消息，当服务该开关打开时，撤回别人的消息会报这个错误
   */
  RcimEngineError_RecallMessageUserInvalid = 25107,
  /**
   * 远程推送设置参数无效，请确认是否正确的填写了远程推送参数
   */
  RcimEngineError_PushSettingParameterInvalid = 26001,
  /**
   * 本地会话状态的版本号低于服务端值，需要等待会话状态同步完成
   */
  RcimEngineError_SettingSyncFailed = 26002,
  /**
   * 消息 uid 为空串或 NULL
   */
  RcimEngineError_InvalidArgumentMessageUid = 26009,
  /**
   * 请求上传 token 时文件大小错误
   */
  RcimEngineError_RequestUploadTokenSizeError = 26107,
  /**
   * 无效的公众号。(由会话类型和 Id 所标识的公众号会话是无效的)
   */
  RcimEngineError_InvalidPublicService = 29201,
  /**
   * 未连接或连接已关闭
   */
  RcimEngineError_ConnectionClosed = 30001,
  /**
   * 正在断开连接中
   * Rust
   */
  RcimEngineError_ConnectionClosing = 30027,
  /**
   * Publish & Query 请求响应超时 `SOCKET_SIGNAL_TIMEOUT`
   */
  RcimEngineError_SocketRecvTimeout = 30003,
  /**
   * 导航请求失败
   */
  RcimEngineError_NaviReqFailed = 30004,
  /**
   * 导航请求超时
   */
  RcimEngineError_NaviReqTimeout = 30005,
  /**
   * 消息大小超限，消息体（序列化成 json 格式之后的内容）
   */
  RcimEngineError_MsgSizeOutOfLimit = 30016,
  /**
   * cmp 信令发送超时
   */
  RcimEngineError_SocketSendTimeout = 30022,
  /**
   * 导航请求携带 Token 错误
   */
  RcimEngineError_NaviRespTokenIncorrect = 30024,
  /**
   * License 不匹配（私有云 - 鸿蒙平台）
   */
  RcimEngineError_NaviLicenseMismatch = 30026,
  /**
   * Http 请求失败
   */
  RcimEngineError_HttpReqFailed = 34026,
  /**
   * Http 请求超时
   */
  RcimEngineError_HttpReqTimeout = 34027,
  /**
   * 信令版本错误
   *
   * 来源：ConnectAckCode = 1 | DisconnectAckCode = 8
   */
  RcimEngineError_ConnectIllegalProtocolVersion = 31001,
  /**
   * 客户端 info 字段格式错误，正确格式：{平台类型}-{设备信息}-{sdk 版本}。
   *
   * 来源：ConnectAckCode = 2
   */
  RcimEngineError_ConnectIdReject = 31002,
  /**
   * 不支持的平台类型，一般小程序或 PC 未开通
   *
   * 来源：ConnectAckCode = 3
   */
  RcimEngineError_ConnectPlatformUnavailable = 31003,
  /**
   * 无法连接，Token 无法解析，或 Token 已过期，请更换 Token 重新连接
   *
   * @note 经常发生在切换开发环境的时候，例如 app 用开发环境的 Token，服务端用生产环境的 appKey，或者相反的场景
   * @discussion 当发生该错误的时候检查一下 APP 使用的 appKey 和 APP Server 使用的 appKey 是否相同
   *
   * 来源：ConnectAckCode = 4
   */
  RcimEngineError_ConnectTokenIncorrect = 31004,
  /**
   * App 校验未通过（开通了 App 校验功能，但是校验未通过）
   *
   * 来源：ConnectAckCode = 5
   */
  RcimEngineError_ConnectNotAuthorized = 31005,
  /**
   * 连接重定向，需要清空导航缓存
   *
   * 来源：ConnectAckCode = 6 | DisconnectAckCode = 6
   */
  RcimEngineError_ConnectRedirect = 31006,
  /**
   * 包名与后台注册信息不匹配，仅移动端使用
   *
   * 来源：ConnectAckCode = 7
   */
  RcimEngineError_ConnectPackageNameInvalid = 31007,
  /**
   * 该 AppKey 已经封禁或删除
   *
   * 来源：ConnectAckCode = 8
   */
  RcimEngineError_ConnectAppBlockOrDelete = 31008,
  /**
   * 无法连接，该用户 ID 已经被封禁
   * @note 请自行检查融云管理后台该用户 ID 的状态
   *
   * 来源：ConnectAckCode = 9
   */
  RcimEngineError_ConnectUserBlocked = 31009,
  /**
   * cmp 异常断开错误错误
   * cmp 服务连接成功后，通知 SDK 用户被同账号其他端踢下线
   * 给用户提示，告知已被提掉线
   */
  RcimEngineError_DisconnectUserKicked = 31010,
  /**
   * cmp 服务连接成功后，通知 SDK 用户被封禁
   * 给用户提示，告知已被封禁
   */
  RcimEngineError_DisconnectUserBlocked = 31011,
  /**
   * cmp 服务连接成功后，通知 SDK 用户主动退出
   */
  RcimEngineError_DisconnectUserLogout = 31012,
  /**
   * Socket 连接异常
   */
  RcimEngineError_SocketConnectionFailed = 31014,
  /**
   * Socket 关闭输出流失败
   */
  RcimEngineError_SocketShutdownFailed = 31015,
  /**
   * 连接取消
   */
  RcimEngineError_ConnectionCancel = 31016,
  /**
   * 通知 SDK Token 过期，APP 重新请求 Token
   *
   * 来源：ConnectAckCode = 10 | DisconnectAckCode = 7
   */
  RcimEngineError_ConnectTokenExpired = 31020,
  /**
   * Token 中携带 deviceId 时，检测 Token 中 deviceId 与链接设备 deviceId 不一致
   *
   * 来源：ConnectAckCode = 11
   */
  RcimEngineError_ConnectDeviceError = 31021,
  /**
   * 链路加密认证失败 (移动端链路加密认证失败需要清空导航缓存)
   *
   * 来源：ConnectAckCode = 12
   */
  RcimEngineError_ConnectHostnameError = 31022,
  /**
   * 开启 `禁止把已在线客户端踢下线` 开关后，该错误码标识已有同类型端在线，禁止链接
   *
   * 来源：ConnectAckCode = 13
   */
  RcimEngineError_ConnectOtherDeviceLogin = 31023,
  /**
   * 连接总数量超过服务设定的并发限定值（私有云专属）
   *
   * 来源：ConnectAckCode = 14
   */
  RcimEngineError_ConnectConcurrentLimitError = 31024,
  /**
   * 客户端连错环境，引发连接拒绝；如使用开发环境 app_key 连接到生产环境
   *
   * 来源：ConnectAckCode = 15
   */
  RcimEngineError_ConnectClusterError = 31025,
  /**
   * 开启 AppServer 联合鉴权功能后，到 AppServer 认证失败
   *
   * 来源：ConnectAckCode = 16
   */
  RcimEngineError_ConnectAppAuthFailed = 31026,
  /**
   * 一次性 token 已经被使用过，需要重新请求 Token
   *
   * 来源：ConnectAckCode = 17
   */
  RcimEngineError_ConnectOneTimePasswordUsed = 31027,
  /**
   * Token 绑定的平台与登录平台不符
   *
   * 来源：ConnectAckCode = 18
   */
  RcimEngineError_ConnectPlatformError = 31028,
  /**
   * 用户账号已销户，不再进行连接，给用户提示，告知账号已注销
   *
   * 来源：ConnectAckCode = 19 | DisconnectAckCode = 9
   */
  RcimEngineError_ConnectUserDeleteAccount = 31029,
  /**
   * 导航请求证书过期
   *
   * 来源：ConnectAckCode = 20
   */
  RcimEngineError_ConnectLicenseExpired = 31030,
  /**
   * Kv 存储器未打开
   */
  RcimEngineError_KvStoreNotOpened = 31510,
  /**
   * Kv 存储器打开失败
   */
  RcimEngineError_KvStoreOpenFailed = 31511,
  /**
   * Kv 存储器读写错误
   */
  RcimEngineError_KvStoreIOError = 31512,
  /**
   * Kv 存储器序列化错误
   */
  RcimEngineError_KvStoreSerializationError = 31513,
  /**
   * Json 解析错误
   */
  RcimEngineError_JsonParserFailed = 31610,
  /**
   * 图片转换错误
   */
  RcimEngineError_ImageFormatError = 31611,
  /**
   * 请求文件上传 Token 时错误
   */
  RcimEngineError_RequestUploadTokenError = 31612,
  /**
   * 获取文件上传 Token 时错误
   */
  RcimEngineError_GetUploadTokenError = 31613,
  /**
   * 小视频消息压缩失败
   */
  RcimEngineError_SightMessageCompressError = 31614,
  /**
   * 请求已取消
   */
  RcimEngineError_RequestCanceled = 33200,
  /**
   * 多媒体消息/文件正在下载
   */
  RcimEngineError_DownloadRequestExist = 33202,
  /**
   * 请求已暂停
   */
  RcimEngineError_RequestPaused = 33204,
  /**
   * 下载任务不存在
   */
  RcimEngineError_DownloadTaskNotExist = 33205,
  /**
   * 上传任务不存在
   * Rust
   */
  RcimEngineError_UploadTaskNotExist = 33206,
  /**
   * 用户自定义消息上传下载失败
   * Rust
   */
  RcimEngineError_MediaMessageHandlerError = 33207,
  /**
   * 连接被拒绝，需要清空导航缓存
   */
  RcimEngineError_ConnectRefused = 32061,
  /**
   * 将消息存储到本地数据时失败。发送或插入消息时，消息需要存储到本地数据库，当存库失败时，会回调此错误码
   */
  RcimEngineError_MessageSavedError = 33000,
  /**
   * 连接进行中
   */
  RcimEngineError_ConnectionInProcess = 33006,
  /**
   * 历史消息云存储业务未开通
   */
  RcimEngineError_CloudStorageForHistoryMessageDisable = 33007,
  /**
   * 连接已存在
   */
  RcimEngineError_ConnectionExists = 34001,
  /**
   * GIF 消息文件大小超出限制
   */
  RcimEngineError_GifMessageSizeOutOfLimit = 34003,
  /**
   * 无法连接，连接超时，需要调用 connect 接口重新进行连接，一般是设备的网络原因
   *
   * @note connect 接口传入的超时时间，在这个时间范围内没有连接成功才会报该错误
   */
  RcimEngineError_ConnectionTimeout = 34006,
  /**
   * 消息不能被扩展，只支持单群聊
   */
  RcimEngineError_MessageCantExpand = 34008,
  /**
   * 消息扩展字段超限
   */
  RcimEngineError_MessageExpansionSizeLimitExceed = 34010,
  /**
   * 上传媒体消息失败
   */
  RcimEngineError_UploadMediaFailed = 34011,
  /**
   * 群已读回执版本不支持
   */
  RcimEngineError_GroupReadReceiptVersionNotSupport = 34014,
  /**
   * 用户级别设置未开通
   */
  RcimEngineError_UserSettingUnavailable = 34016,
  /**
   * 未注册的消息类型
   */
  RcimEngineError_MessageNotRegistered = 34021,
  /**
   * 消息扩展不支持该会话类型
   */
  RcimEngineError_MessageExpandConversationTypeNotMatch = 34025,
  /**
   * 不支持超级群会话
   */
  RcimEngineError_InvalidArgumentUltraGroupNotSupport = 34022,
  /**
   * 构建 `RcimEngineBuilderParam` 时传入的 app_key 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentAppKey = 34105,
  /**
   * 开发者接口调用时传入的时间戳非法
   */
  RcimEngineError_InvalidArgumentTimestamp = 34202,
  /**
   * 开发者接口调用时传入 MessageContent 非法
   */
  RcimEngineError_InvalidArgumentMessageContent = 34205,
  /**
   * 参数 Message 列表非法
   */
  RcimEngineError_InvalidArgumentMessageVec = 34206,
  /**
   * 开发者接口调用时传入的 ConversationType 非法
   */
  RcimEngineError_InvalidArgumentConversationType = 34209,
  /**
   * 开发者接口调用时传入的 targetId 非法
   */
  RcimEngineError_InvalidArgumentTargetId = 34210,
  /**
   * 开发者接口调用时传入的 MessageExpansion 非法
   */
  RcimEngineError_InvalidParameterMessageExpansion = 34220,
  /**
   * 开发者调用频道相关接口时传入的 channelId 非法
   */
  RcimEngineError_InvalidArgumentChannelId = 34211,
  /**
   * 开发者 sendMediaMessage 传入的 Message.content 不是多媒体消息
   */
  RcimEngineError_InvalidArgumentContentNotMedia = 34223,
  /**
   * 传入的文件名为空
   */
  RcimEngineError_InvalidArgumentFileNameEmpty = 33201,
  /**
   * 开发者接口调用时传入的时间字符串不合法，格式为 "HH:MM:SS"
   */
  RcimEngineError_InvalidArgumentTimeString = 34224,
  /**
   * 开发者接口调用时传入的枚举值超出定义范围
   * 注：因 C 枚举类型入参超范围时，会因 Undefined Behavior 无法预知结果，不能准确判断。
   * 因此根据 https://github.com/rust-lang/rust-memory-model/issues/41 建议，改由平台层确保传入的枚举值在合法范围内。
   * 仅 C_FFI 层使用（暂未使用）
   */
  RcimEngineError_InvalidEnumOutOfRange = 34225,
  /**
   * 免打扰级别非法
   */
  RcimEngineError_InvalidArgumentPushNotificationMuteLevel = 34228,
  /**
   *  messageIds 参数为 NULL 或者数组长度为 0
   */
  RcimEngineError_InvalidArgumentMessageIdVec = 34229,
  /**
   * 开发者接口调用时传入的 count 非法
   */
  RcimEngineError_InvalidArgumentCount = 34232,
  /**
   * 开发者调用接口传入的 local path 地址不存在
   */
  RcimEngineError_InvalidArgumentMediaLocalPath = 34234,
  /**
   * 开发者调用接口传入的 mediaUrl 地址为空
   */
  RcimEngineError_InvalidArgumentMediaUrl = 34235,
  /**
   * 开发者调用接口传入的 message 参数为空
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentMessage = 34243,
  /**
   * 开发者调用接口传入的 sentStatus 参数错误
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentSentStatus = 34244,
  /**
   * 聊天室设置 kv 失败，参数 key 非法
   */
  RcimEngineError_ChatroomKvInvalidKey = 34260,
  /**
   * 聊天室设置 kv 失败，参数 key 数组非法
   */
  RcimEngineError_ChatroomKvInvalidKeyVec = 34261,
  /**
   * 聊天室设置 kv 失败，参数 value 非法
   */
  RcimEngineError_ChatroomKvInvalidValue = 34262,
  /**
   * 聊天室设置 kv 失败，参数 key 和 value 数组非法
   */
  RcimEngineError_ChatroomKvInvalidKeyValueVec = 34263,
  /**
   * 参数 MessageDirection 为空
   */
  RcimEngineError_InvalidArgumentMessageDirectionEmpty = 34267,
  /**
   * 开发者接口调用时传入的 objectName 非法
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentObjectName = 34271,
  /**
   * 参数 limit 非法
   */
  RcimEngineError_InvalidArgumentLimit = 34279,
  /**
   * 参数 MessageDirection 非法（发送消息时没有使用 Send）
   */
  RcimEngineError_InvalidArgumentMessageDirection = 34280,
  /**
   * 设置免打扰的 span minutes 非法，支持范围 [1, 1439]
   */
  RcimEngineError_InvalidArgumentSpanMinutes = 34283,
  /**
   * 开发者接口调用时传入的 ConversationTypeVec 列表非法
   */
  RcimEngineError_InvalidArgumentConversationTypeVec = 34284,
  /**
   * 调用 `rcim_engine_builder_set_navi_server` 时，传入的 url 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentNaviUrl = 34286,
  /**
   * 开发者接口调用时传入的 ConversationIdentifierVec 列表非法
   */
  RcimEngineError_InvalidArgumentConversationIdentifierVec = 34287,
  /**
   * 当前会话类型不支持定向消息
   */
  RcimEngineError_DirectionalMessageNotSupport = 34296,
  /**
   * 消息正在阅后即焚倒计时中，无法开始阅后即焚倒计时
   * 调用 message_begin_destruct 可能出现
   */
  RcimEngineError_MessageDestructing = 34297,
  /**
   * 消息没有在阅后即焚倒计时，无法停止倒计时
   * 调用 message_stop_destruct 可能出现
   */
  RcimEngineError_MessageNotDestructing = 23298,
  /**
   * 接口传入的 `RcimReceivedStatus*` 为 NULL 时返回
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidParameterReceivedStatus = 34230,
  /**
   * 开发者接口调用时传入的 user_id 非法
   */
  RcimEngineError_InvalidParameterUserId = 34214,
  /**
   * 定向消息的 user_ids 非法
   */
  RcimEngineError_InvalidParameterUserList = 34215,
  /**
   * 数据库未打开
   */
  RcimEngineError_DatabaseNotOpened = 34301,
  /**
   * 数据库打开错误
   */
  RcimEngineError_DatabaseOpenFailed = 34302,
  /**
   * 数据库读写错误
   */
  RcimEngineError_DatabaseIOError = 34303,
  /**
   * 数据库序没有查到数据
   */
  RcimEngineError_DatabaseTargetNotFound = 34304,
  /**
   * 网络数据转换失败
   */
  RcimEngineError_NetDataParserFailed = 34305,
  /**
   * 数据库线程错误
   */
  RcimEngineError_DatabaseThreadError = 34316,
  /**
   * 调用接口的同时，引擎已释放
   */
  RcimEngineError_EngineDropped = 34400,
  /**
   * 小视频时间长度超出限制，默认小视频时长上限为 2 分钟
   * Android,iOS,Web
   */
  RcimEngineError_SightMsgDurationLimit = 34002,
  /**
   * 接口传入的 `RcimEngineSync*` 为 NULL 时返回
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentEngineSync = 34401,
  /**
   * 接口传入的 `RcimEngineBuilder*` 为 NULL 时返回
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentEngineBuilder = 34402,
  /**
   * 构建 `RcimEngineBuilderParam` 时，传入的 device_id 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentDeviceId = 34403,
  /**
   * 构建 `RcimEngineBuilderParam` 时，传入的 package_name 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentPackageName = 34404,
  /**
   * 构建 `RcimEngineBuilderParam` 时，传入的 sdk_version 或 sdk_version_vec 为 NULL，或 sdk_version_vec_len = 0
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentSdkVersion = 34405,
  /**
   * 调用 `rcim_engine_builder_set_store_path` 或 `rcim_engine_builder_set_file_path` 时，传入的 path 为 NULL
   */
  RcimEngineError_InvalidArgumentFileStoragePath = 34406,
  /**
   * 调用 `rcim_engine_connect` 时传入的 token 为 NULL 或长度超范围
   */
  RcimEngineError_InvalidArgumentToken = 34407,
  /**
   * 开发者调用接口传入的 messageId 参数非法
   */
  RcimEngineError_InvalidArgumentMessageId = 34408,
  /**
   * 调用 `rcim_engine_register_message_types` 时传入的 type_vec 为 NULL 或 type_vec_len 为 0
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentMessageType = 34409,
  /**
   * 无法解析成 MediaMessage
   */
  RcimEngineError_InvalidArgumentNotMediaMessage = 34410,
  /**
   * 用户 ID 为空
   */
  RcimEngineError_InvalidArgumentUserIdEmpty = 34411,
  /**
   * 发送语音消息时，传入的语音长度非法
   */
  RcimEngineError_InvalidArgumentAudioDuration = 34413,
  /**
   * 日志插入时参数无效
   */
  RcimEngineError_InvalidArgumentLogInfo = 34414,
  /**
   * 接口传入的 RcimEngineBuilderParam* 为 NULL   时返回
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentEngineBuilderParam = 34415,
  /**
   * 构建 `RcimEngineBuilderParam` 时，传入的 device_model 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentDeviceModel = 34416,
  /**
   * 构建 `RcimEngineBuilderParam` 时，传入的 device_manufacturer 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentDeviceManufacturer = 34417,
  /**
   * 接口传入的 push_token_vec 为 NULL 或 push_token_vec_len 为 0 时返回
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentPushTokenVec = 34418,
  /**
   * 接口传入的 push_type 为 NULL 时返回
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentPushType = 34419,
  /**
   * 接口传入的 push_token 为 NULL 时返回
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentPushToken = 34420,
  /**
   * 开发者接口调用时传入的 SenderId 非法 All: 34421
   */
  RcimEngineError_InvalidArgumentSenderId = 34421,
  /**
   * 免打扰级别数组非法
   */
  RcimEngineError_InvalidArgumentPushNotificationMuteLevelVec = 34422,
  /**
   * 调用 `rcim_engine_get_connection_status` 时传入的 out_status 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentConnectionStatus = 34423,
  /**
   * 调用 `rcim_engine_get_version` 时传入的 version 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentVersion = 34424,
  /**
   * 构建 `RcimEngineBuilderParam` 时，传入的 os_version 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentOsVersion = 34425,
  /**
   * 构建 `RcimEngineBuilderParam` 时，传入的 app_version 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentAppVersion = 34426,
  /**
   * 构建 `rcim_engine_builder_set_statistic_server` 时，传入的 url 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentStatisticUrl = 34427,
  /**
   * 构建 rcim_engine_save_text_message_draft 时，掺入的 draft 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentDraft = 34428,
  /**
   * 构建 rcim_engine_search_local_conversations 时，插入的 keyword 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentKeyword = 34429,
  /**
   * 开发者接口调用时传入的 offset 非法
   */
  RcimEngineError_InvalidArgumentOffset = 34430,
  /**
   * 开发者接口调用时传入的 object_name_vec 非法
   */
  RcimEngineError_InvalidArgumentObjectNameVec = 34431,
  /**
   * 开发者接口调用时传入的 time_interval 非法
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentTimeInterval = 34432,
  /**
   * 开发者接口调用时传入的 timeout_sec 非法
   */
  RcimEngineError_InvalidArgumentTimeoutSeconds = 34433,
  /**
   * 消息做阅后即焚时，阅后即焚时长非法，时长必须 > 0
   */
  RcimEngineError_InvalidArgumentDestructDuration = 34434,
  /**
   * 接口传入的 unique_id 非法时返回
   */
  RcimEngineError_InvalidArgumentUniqueId = 34435,
  /**
   * 接口传入的 out_unique_id 为 NULL 时返回
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentOutUniqueId = 34436,
  /**
   * 接口传入的 out_user_id 为 NULL 时返回
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentOutUserId = 34437,
  /**
   * 接口传入的 extra 为 NULL 时返回
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentExtra = 34438,
  /**
   * 加入聊天室 Id 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentChatroomId = 36001,
  /**
   * RTC 发送信令方法名为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentRtcMethodName = 36002,
  /**
   * RTC 发送 KV 信令 Key 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentRtcKey = 36003,
  /**
   * RTC 发送 KV 信令 Value 为 NULL
   * 仅 C_FFI 层使用
   */
  RcimEngineError_InvalidArgumentRtcValue = 36004,
  /**
   * 服务返回错误 (RTC) -----------------------------------------------------------------------
   * user id is not in room
   */
  RcimEngineError_CallNotInRoom = 40001,
  /**
   * internal error
   */
  RcimEngineError_CallInternalError = 40002,
  /**
   * server has no roominfo
   */
  RcimEngineError_CallHasNoRoom = 40003,
  /**
   * userId is Empty
   */
  RcimEngineError_CallInvalidUserId = 40004,
  /**
   * limit error
   */
  RcimEngineError_CallLimitError = 40005,
  /**
   * param error
   */
  RcimEngineError_CallParamError = 40006,
  /**
   * get token error
   */
  RcimEngineError_CallTokenError = 40007,
  /**
   * db error
   */
  RcimEngineError_CallDbError = 40008,
  /**
   * json error
   */
  RcimEngineError_CallJsonError = 40009,
  /**
   * not open voip error
   */
  RcimEngineError_CallNotOpen = 40010,
  /**
   * Room type is not created roomType error
   */
  RcimEngineError_CallRoomTypeError = 40011,
  /**
   * The User have no auth
   */
  RcimEngineError_CallNoAuthUser = 40012,
  /**
   * has no config MCU Address
   */
  RcimEngineError_CallHasNoConfigMcuAddress = 40015,
  /**
   * not allow video broadcast
   */
  RcimEngineError_CallNotAllowVideoBroadcast = 40016,
  /**
   * not allow audio broadcast
   */
  RcimEngineError_CallNotAllowAudioBroadcast = 40017,
  /**
   * get token failed
   */
  RcimEngineError_CallGetTokenError = 40018,
  /**
   * user is blocked
   */
  RcimEngineError_CallUserIsBlocked = 40021,
  /**
   * invite room is not exist
   */
  RcimEngineError_CallInviteRoomNotExist = 40022,
  /**
   * invite user is not exist
   */
  RcimEngineError_CallInviteUserNotInRoom = 40023,
  /**
   * invite is progress
   */
  RcimEngineError_CallInviteInProgress = 40024,
  /**
   * cancel invite but is not progress
   */
  RcimEngineError_CallCancelInviteNotProgress = 40025,
  /**
   * answer invite but is not progress
   */
  RcimEngineError_CallAnswerInviteNotProgress = 40026,
  /**
   * answer invite timeout
   */
  RcimEngineError_CallAnswerInviteTimeout = 40027,
  /**
   * ping not progress
   */
  RcimEngineError_CallPingNotProgress = 40028,
  /**
   * room already exist
   */
  RcimEngineError_CallRoomAlreadyExist = 40029,
  /**
   * room type not support this operation
   */
  RcimEngineError_CallRoomTypeNotSupport = 40030,
  /**
   * identity change type error
   */
  RcimEngineError_CallIdentityChangeTypeError = 40031,
  /**
   * already join room
   */
  RcimEngineError_CallAlreadyJoinRoom = 40032,
  /**
   * config or gatewayUrl is null
   */
  RcimEngineError_CallNotAllowCrossApp = 40033,
  /**
   * user is not allowed for rtc
   */
  RcimEngineError_CallUserNotAllowedForRtc = 40034,
  /**
   * concurrent limit error
   */
  RcimEngineError_CallConcurrentLimitError = 40130,
  /**
   * rtc expired error
   */
  RcimEngineError_CallExpiredError = 40131,
  /**
   * 服务返回错误 (callplus) ------------------------------------------------------------------
   * unknown call error
   */
  RcimEngineError_CallplusUnknownError = 41000,
  /**
   * db error
   */
  RcimEngineError_CallplusDbError = 41001,
  /**
   * json error
   */
  RcimEngineError_CallplusJsonError = 41002,
  /**
   * invalid json format
   */
  RcimEngineError_CallplusInvalidJsonFormat = 41003,
  /**
   * missing parameters
   */
  RcimEngineError_CallplusMissingParameters = 41004,
  /**
   * operation not permitted
   */
  RcimEngineError_CallplusOperationNotPermitted = 41005,
  /**
   * circuit breaker open
   */
  RcimEngineError_CallplusCircuitBreakerOpen = 41006,
  /**
   * the method is not implemented
   */
  RcimEngineError_CallplusMethodNotImplement = 41007,
  /**
   * the calling user is not registered with the call server
   */
  RcimEngineError_CallplusCallingUserNotRegistCallServer = 41008,
  /**
   * the current version does not support new version call
   */
  RcimEngineError_CallplusNotSupportNewCall = 41009,
  /**
   * this call is not exist or ended
   */
  RcimEngineError_CallplusCallNotExist = 41010,
  /**
   * single call cannot exceed 2 persons
   */
  RcimEngineError_CallplusSingleCallOverload = 41011,
  /**
   * group call exceeds quorum
   */
  RcimEngineError_CallplusGroupCallOverload = 41012,
  /**
   * The operation has expired
   */
  RcimEngineError_CallplusOperationHasExpired = 41013,
  /**
   * your device is already calling
   */
  RcimEngineError_CallplusDeviceHasCalling = 41014,
  /**
   * the user is not the user of the call
   */
  RcimEngineError_CallplusCallUserNotInCall = 41015,
  /**
   * the corresponding data has been cleared after expiration
   */
  RcimEngineError_CallplusDataHasExpired = 41016,
  /**
   * the streamReadyTime that you reported is invalid
   */
  RcimEngineError_CallplusStreamReadyTimeInvalid = 41018,
  /**
   * single call cannot call itself
   */
  RcimEngineError_CallplusCallNotSelf = 41019,
  /**
   * the session status does not exist
   */
  RcimEngineError_CallplusStateNotExist = 41020,
  /**
   * hangup operation is not allowed to be called in the current state
   */
  RcimEngineError_CallplusHangupNotAllowed = 41021,
  /**
   * accept operation is not allowed to be called in the current state
   */
  RcimEngineError_CallplusAcceptNotAllowed = 41022,
  /**
   * the operation is not allowed to be called in the current state
   */
  RcimEngineError_CallplusOperationNotAllowed = 41025,
  /**
   * this transactionId is not incorrect or this transaction is ended. this operation cannot be performed
   */
  RcimEngineError_CallplusTransactionNotExist = 41100,
  /**
   * There is already an audio and video upgrade or downgrade in progress
   */
  RcimEngineError_CallplusMediaTypeSwitching = 41101,
  /**
   * upgrading audio to video has been cancelled by the initiator
   */
  RcimEngineError_CallplusAudioToVideoCancel = 41150,
  /**
   * it is an audio call at present, and no degradation is required
   */
  RcimEngineError_CallplusVideoToAudioNoRequired = 41151,
  /**
   * it is a video call at present, and no upgradation is required
   */
  RcimEngineError_CallplusAudioToVideoNoRequired = 41152,
  /**
   * the cseqId of this type does not provide compensation data or has expired
   */
  RcimEngineError_CallplusNoCompensationData = 41200,
  /**
   * 暂不支持
   */
  RcimEngineError_NotSupportedYet = 99999,
} RcimEngineError;

/**
 * 日志等级，与大数据平台对齐
 */
typedef enum RcimLogLevel {
  /**
   * 不打印日志
   */
  RcimLogLevel_None = 0,
  /**
   * 打印错误日志
   */
  RcimLogLevel_Error = 1,
  /**
   * 打印警告日志
   */
  RcimLogLevel_Warn = 2,
  /**
   * 打印流程日志
   */
  RcimLogLevel_Info = 3,
  /**
   * 打印调试日志
   */
  RcimLogLevel_Debug = 4,
} RcimLogLevel;

/**
 * 细分日志来源
 */
typedef enum RcimLogSource {
  RcimLogSource_RUST = 0,
  RcimLogSource_FFI = 1,
  RcimLogSource_IMLib = 2,
  RcimLogSource_IMKit = 3,
  RcimLogSource_RTCLib = 4,
  RcimLogSource_CallLib = 5,
  RcimLogSource_CallPlus = 6,
} RcimLogSource;

/**
 * 日志业务类型
 */
typedef enum RcimLogType {
  RcimLogType_IM = 0,
  RcimLogType_RTC = 1,
} RcimLogType;

/**
 * 自定义处理多媒体文件处理结果
 */
typedef enum RcimMediaHandlerError {
  RcimMediaHandlerError_Success = 0,
  RcimMediaHandlerError_Canceled = 1,
  RcimMediaHandlerError_Paused = 2,
  RcimMediaHandlerError_Failed = 3,
} RcimMediaHandlerError;

/**
 * 敏感消息源触发类型
 */
typedef enum RcimMessageBlockSourceType {
  RcimMessageBlockSourceType_Default = 0,
  RcimMessageBlockSourceType_Extension = 1,
  RcimMessageBlockSourceType_Modification = 2,
} RcimMessageBlockSourceType;

/**
 * 消息拦截类型
 */
typedef enum RcimMessageBlockType {
  RcimMessageBlockType_None = 0,
  RcimMessageBlockType_BlockGlobal = 1,
  RcimMessageBlockType_BlockCustom = 2,
  RcimMessageBlockType_BlockThirdParty = 3,
} RcimMessageBlockType;

/**
 * 消息的发送方向
 */
typedef enum RcimMessageDirection {
  /**
   * 发送
   * Android: false
   * iOS: MessageDirection_SEND = 1
   */
  RcimMessageDirection_Send = 1,
  /**
   * 接收
   * Android: true
   * iOS: MessageDirection_RECEIVE = 2
   */
  RcimMessageDirection_Receive = 2,
} RcimMessageDirection;

/**
 * 消息计数、存储类型
 */
typedef enum RcimMessageFlag {
  /**
   * 不存储本地数据库，不计入未读数
   */
  RcimMessageFlag_None = 0,
  /**
   * 存储本地数据库，不计入未读数
   */
  RcimMessageFlag_Save = 1,
  /**
   * 存储本地数据库，计入未读数
   */
  RcimMessageFlag_Count = 3,
  /**
   * 不存储本地数据库，不计入未读数
   * 在线可以收取，不在线消息会被抛弃
   */
  RcimMessageFlag_Status = 16,
} RcimMessageFlag;

/**
 * 网络类型，将 NetworkType 适配 C 语言
 */
typedef enum RcimNetworkType {
  /**
   * 无网络
   */
  RcimNetworkType_None = 0,
  /**
   * WiFi
   */
  RcimNetworkType_Wifi = 1,
  /**
   * 有线网络，例如电脑接了网线
   */
  RcimNetworkType_Wired = 2,
  /**
   * 蜂窝数据网络 2G
   */
  RcimNetworkType_Cellular2G = 3,
  /**
   * 蜂窝数据网络 3G
   */
  RcimNetworkType_Cellular3G = 4,
  /**
   * 蜂窝数据网络 4G
   */
  RcimNetworkType_Cellular4G = 5,
  /**
   * 蜂窝数据网络 5G
   */
  RcimNetworkType_Cellular5G = 6,
} RcimNetworkType;

/**
 * 时间顺序
 */
typedef enum RcimOrder {
  /**
   * 降序
   */
  RcimOrder_Descending = 0,
  /**
   * 升序
   */
  RcimOrder_Ascending = 1,
} RcimOrder;

/**
 * 平台码，不同平台接入需选择对应平台码
 */
typedef enum RcimPlatform {
  RcimPlatform_Android = 0,
  RcimPlatform_IOS = 1,
  RcimPlatform_HarmonyOS = 2,
  RcimPlatform_Windows = 3,
  RcimPlatform_MacOS = 4,
  RcimPlatform_Linux = 5,
  RcimPlatform_Electron = 6,
  RcimPlatform_Web = 7,
  /**
   * 未知平台，新增枚举时在此之前添加
   */
  RcimPlatform_Unknown = 127,
} RcimPlatform;

/**
 * 公众号菜单子菜单类型
 */
typedef enum RcimPublicServiceMenuItemType {
  /**
   * 包含子菜单的一组菜单
   */
  RcimPublicServiceMenuItemType_Group = 0,
  /**
   * 包含查看事件的菜单
   */
  RcimPublicServiceMenuItemType_View = 1,
  /**
   * 包含点击事件的菜单
   */
  RcimPublicServiceMenuItemType_Click = 2,
} RcimPublicServiceMenuItemType;

/**
 * 通知消息免打扰等级
 */
typedef enum RcimPushNotificationMuteLevel {
  /**
   * 全部消息通知
   * 注意：超级群设置全部消息通知时
   * 1. @ 消息一定收到推送通知
   * 2. 普通消息的推送频率受到服务端默认推送频率设置的影响，无法做到所有普通消息都通知
   */
  RcimPushNotificationMuteLevel_All = -1,
  /**
   * 未设置（向上查询群或者 APP 级别设置）,存量数据中 0 表示未设置
   */
  RcimPushNotificationMuteLevel_Default = 0,
  /**
   * 群聊和超级群 @所有人 + @自己 时通知
   */
  RcimPushNotificationMuteLevel_Mention = 1,
  /**
   * 群聊和超级群 @自己 时通知，其它情况不通知
   */
  RcimPushNotificationMuteLevel_MentionUsers = 2,
  /**
   * 群聊和超级群 @所有人 时通知，其他情况都不通知
   */
  RcimPushNotificationMuteLevel_MentionAll = 4,
  /**
   * 消息通知被屏蔽，不接收任何消息通知
   */
  RcimPushNotificationMuteLevel_Blocked = 5,
} RcimPushNotificationMuteLevel;

typedef enum RcimSentStatus {
  /**
   * 发送中
   */
  RcimSentStatus_SENDING = 10,
  /**
   * 发送失败
   */
  RcimSentStatus_FAILED = 20,
  /**
   * 已发送
   */
  RcimSentStatus_SENT = 30,
  /**
   * 对方已接收
   */
  RcimSentStatus_RECEIVED = 40,
  /**
   * 对方已读
   */
  RcimSentStatus_READ = 50,
  /**
   * 对方已销毁
   */
  RcimSentStatus_DESTROYED = 60,
  /**
   * 已取消发送
   */
  RcimSentStatus_CANCELED = 70,
} RcimSentStatus;

/**
 * 引擎构建器
 */
typedef struct RcimEngineBuilder RcimEngineBuilder;

/**
 * 同步接口引擎类
 */
typedef struct RcimEngineSync RcimEngineSync;

/**
 * SDK 版本号信息
 */
typedef struct RcimSDKVersion {
  /**
   * SDK 名称，字符串长度限制 1-64 字符
   */
  const char *name;
  /**
   * SDK 版本号，字符串长度限制 1-64 字符
   */
  const char *version;
} RcimSDKVersion;

/**
 * EngineBuilder 构建时传入的参数列表，仅包含必填参数，即无默认值的参数；对于有默认值的参数，需经过接口改变其值
 * 注：C 语言特性要求，构造时每个成员变量必须显示赋值，否则为赋值的变量可能为任意值，导致无法预料的后果。
 */
typedef struct RcimEngineBuilderParam {
  /**
   * App 应用标识
   */
  const char *app_key;
  /**
   * 客户端平台类型
   */
  enum RcimPlatform platform;
  /**
   * 客户端设备标识，尽量在构建时一次性传入
   * 注：鸿蒙目前因为设备 ID 获取为异步接口，不能在引擎构建时第一时间传入
   * 可以暂时传 NULL，然后需要在创建 engine 后调用 set_device_id 设置
   */
  const char *device_id;
  /**
   * 客户端包名（如："cn.xxx.im"）
   */
  const char *package_name;
  /**
   * 调用此库的平台层 imlib 版本号，供大数据统计和服务确认连接版本
   */
  const char *imlib_version;
  /**
   * 设备型号（如：iPhoneX），供大数据统计
   */
  const char *device_model;
  /**
   * 设备厂商（如：Apple），供大数据统计
   */
  const char *device_manufacturer;
  /**
   * 操作系统版本号（如：iOS_14.0），供大数据统计
   */
  const char *os_version;
  /**
   * 当前环境中所有 SDK 版本号，需包含 imlib_ver 键值对，
   * 构建完成后会自动添加 rustlib_ver 键值对，供大数据统计
   * 如：{ "imlib": "4.0.0", "imkit": "2.0.0" }
   */
  const struct RcimSDKVersion *sdk_version_vec;
  /**
   * sdk_ver_vec 的数组长度
   */
  int32_t sdk_version_vec_len;
  /**
   * 调用此库的 App 版本号，供大数据统计
   */
  const char *app_version;
} RcimEngineBuilderParam;

/**
 * 数据库状态监听
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param status_c     数据库状态码
 */
typedef void (*RcimDatabaseStatusLsr)(const void *context, enum RcimDatabaseStatus status_c);

/**
 * 推送配置信息
 */
typedef struct RcimPushTokenInfo {
  /**
   * push 类型 eg：harmony "OHOS"，必填
   */
  const char *push_type;
  /**
   * push token 内容，必填
   */
  const char *push_token;
} RcimPushTokenInfo;

/**
 * 连接状态监听
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param status       连接状态码
 */
typedef void (*RcimConnectionStatusLsr)(const void *context, enum RcimConnectionStatus status);

/**
 * 连接接口回调
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code         连接结果码
 * @param user_id      连接成功时，返回用户 ID；失败时，返回 NULL 指针。Rust 负责释放
 */
typedef void (*RcimConnectCb)(const void *context, enum RcimEngineError code, const char *user_id);

/**
 * 公共的只返回错误码回调
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code             结果码
 */
typedef void (*RcimEngineErrorCb)(const void *context, enum RcimEngineError code);

/**
 * 消息的接受状态，包括是否已读、是否已下载、是否多端接收等
 */
typedef struct RcimReceivedStatus {
  bool is_read;
  bool is_listened;
  bool is_download;
  bool is_retrieved;
  bool is_multiple_received;
} RcimReceivedStatus;

/**
 * 已读回执信息
 */
typedef struct RcimReadReceiptUserInfo {
  /**
   * 发送已读回执用户 ID
   */
  const char *sender_id;
  /**
   * 已读回执时间戳
   */
  uint64_t timestamp;
} RcimReadReceiptUserInfo;

typedef struct RcimReadReceiptInfo {
  /**
   * 是否为需要回执的消息（true: 需要回执的消息；false: 普通消息）
   */
  bool is_read_receipt_message;
  /**
   * 是否发送过消息回执响应，仅对消息接收方有效
   */
  bool has_respond;
  /**
   * 会话中响应过该消息回执的成员
   */
  const struct RcimReadReceiptUserInfo *respond_user_vec;
  int32_t respond_user_vec_len;
} RcimReadReceiptInfo;

typedef struct RcimReadReceiptInfoV2 {
  /**
   * 是否发送过消息回执响应，仅对消息接收方有效
   */
  bool has_respond;
  /**
   * 会话中响应过该消息回执的成员
   */
  const struct RcimReadReceiptUserInfo *respond_user_vec;
  int32_t respond_user_vec_len;
  /**
   * 已读成员数
   */
  uint32_t read_count;
  /**
   * 所有成员数
   */
  uint32_t total_count;
} RcimReadReceiptInfoV2;

typedef struct RcimIosConfig {
  /**
   * iOS 平台通知栏分组 ID
   * 相同的 thread-id 推送分为一组
   * iOS10 开始支持
   */
  const char *thread_id;
  /**
   * iOS 标识推送的类型
   * 如果不设置后台默认取消息类型字符串，如 RC:TxtMsg
   */
  const char *category;
  /**
   * iOS 平台通知覆盖 ID
   * apnsCollapseId 相同时，新收到的通知会覆盖老的通知，最大 64 字节
   * iOS10 开始支持
   */
  const char *apns_collapse_id;
  /**
   * iOS 富文本推送内容
   */
  const char *rich_media_uri;
  /**
   * iOS 推送级别。默认值 "active"
   * "passive" 被动通知：即并不需要及时关注的通知，类似餐馆推荐通知
   * "active"   主动通知（默认的）：默认的通知，即人们可能想知道的，类似最喜欢的体育比赛的最新比分
   * "time-sensitive" 时效性通知：需要人们立刻注意的通知，类似账户安全问题或快递动态
   * "critical" 重要通知：关于个人健康或直接影响到设备拥有者的公共安全事件且需要立刻关注的，这类通知很少，一般是来自公共政府机构或健康 App。
   */
  const char *interruption_level;
} RcimIosConfig;

typedef struct RcimAndroidConfig {
  /**
   * Android 平台 Push 唯一标识
   * 目前支持小米、华为推送平台，默认开发者不需要进行设置，当消息产生推送时，消息的 messageUId 作为 notificationId 使用。
   */
  const char *notification_id;
  /**
   * 小米的渠道 ID
   * 该条消息针对小米使用的推送渠道，如开发者集成了小米推送，需要指定 channelId 时，可向 Android 端研发人员获取，channelId 由开发者自行创建。
   */
  const char *mi_channel_id;
  /**
   * 小米 Large icon 链接
   * 由于小米官方已停止支持该能力，该字段/方法已失效
   * 华为的渠道 ID
   * 该条消息针对华为使用的推送渠道，如开发者集成了华为推送，需要指定 channelId 时，可向 Android 端研发人员获取，channelId 由开发者自行创建。
   */
  const char *hw_channel_id;
  /**
   * 华为推送消息级别
   * 消息级别包括 "NORMAL", "LOW"
   */
  const char *hw_importance;
  /**
   * 华为通知栏消息右侧大图标 URL
   */
  const char *hw_image_url;
  /**
   * 华为推送消息分类：
   * - 社交通讯：即时通讯 [IM],音频、视频通话 [VOIP]
   * - 服务提醒：订阅 [SUBSCRIPTION],出行 [TRAVEL],健康 [HEALTH],工作事项提醒 [WORK],帐号动态 [ACCOUNT],订单&物流 [EXPRESS],财务 [FINANCE],系统提示 [SYSTEM_REMINDER],邮件 [MAIL]
   * - 资讯营销类：内容资讯/新闻/财经动态/生活资讯/社交动态/调研/其他 [MARKETING]
   * - 营销活动：产品促销/功能推荐/运营活动/MARKETING
   *
   * 更多信息请参考华为消息分类标准文档：https://developer.huawei.com/consumer/cn/doc/development/HMSCore-Guides/message-classification-0000001149358835
   *
   * 默认值为 NULL，如果为 NULL，则以服务配置为准
   */
  const char *hw_category;
  /**
   * 荣耀推送消息级别
   * 消息级别包括 "NORMAL", "LOW"
   */
  const char *honor_importance;
  /**
   * 荣耀通知栏消息右侧大图标 URL
   */
  const char *honor_image_url;
  /**
   * OPPO 的渠道 ID
   * 该条消息针对 OPPO 使用的推送渠道，如开发者集成了 OPPO 推送，需要指定 channelId 时，可向 Android 端研发人员获取，channelId 由开发者自行创建。
   */
  const char *oppo_channel_id;
  /**
   * VIVO 推送消息分类
   *
   * 系统消息分类
   * 即时消息 [IM],账号与资产 [ACCOUNT],日程待办 [TODO],设备信息 [DEVICE_REMINDER],订单与物流 [ORDER],订阅提醒 [SUBSCRIPTION]
   * 运营消息分类
   * 新闻 [NEWS],内容推荐 [CONTENT],运营活动 [MARKETING],社交动态 [SOCIAL]
   * 更多信息请参考 Vivo 消息分类标准文档：https://dev.vivo.com.cn/documentCenter/doc/359
   *
   * 默认值为 NULL，如果为 NULL，则以服务配置为准
   */
  const char *vivo_category;
  /**
   * VIVO 推送通道类型
   * 开发者集成了 VIVO 推送，需要指定推送类型时，可进行设置。
   * 目前可选值 "0"(运营消息) 和  "1"(系统消息)
   */
  const char *vivo_type;
  /**
   * FCM 通知的频道 ID
   * 该应用程序必须使用此频道 ID 创建一个频道，然后才能收到带有该频道 ID 的任何通知。如果您未在请求中发送此频道 ID，或者如果应用尚未创建提供的频道 ID，则 FCM 使用应用清单中指定的频道 ID。
   */
  const char *fcm_channel_id;
  /**
   * FCM 通知类型推送时所使用的分组 ID
   */
  const char *fcm_collapse_key;
  /**
   * FCM 通知类型的推送所使用的通知图片 URL
   */
  const char *fcm_image_url;
} RcimAndroidConfig;

typedef struct RcimHarmonyConfig {
  /**
   * HarmonyOS 通知栏消息右侧大图标 URL
   * 通知栏右侧图片，格式支持 png、jpg、jpeg、heif、gif、bmp，图片长*宽 < 25000 像素，图片不满足要求的情况下，终端不能显示通知消息。
   */
  const char *image_url;
  /**
   * HarmonyOS 推送消息分类：
   * 社交通讯：消息自分类标识，默认为空。category 取值必须为大写字母
   * 默认值为 NULL，如果为 NULL，则以服务配置为准
   * 更多信息请参考鸿蒙通知消息分类标准文档：https://developer.huawei.com/consumer/cn/doc/development/HMSCore-Guides/message-classification-0000001149358835
   */
  const char *category;
} RcimHarmonyConfig;

typedef struct RcimPushConfig {
  /**
   * 通知栏是否屏蔽通知标题（true: 不显示通知标题；false: 显示通知标题）
   * 默认情况下融云单聊消息通知标题为用户名、群聊消息为群名称，设置后不会再显示通知标题。
   * 此属性只针目标用户为 iOS 平台时有效，Android 第三方推送平台的通知标题为必填项，所以暂不支持
   */
  bool disable_push_title;
  /**
   * 默认标题显示规则：内置消息：单聊通知标题显示为发送者名称，群聊通知标题显示为群名称。自定义消息：默认不显示标题。
   */
  const char *push_title;
  /**
   * 推送内容。
   */
  const char *push_content;
  /**
   * 远程推送附加信息。
   */
  const char *push_data;
  /**
   * 是否强制显示通知详情。推送越权设置，当目标用户设置推送不显示消息详情时，可通过此功能，强制设置该条消息显示推送详情。
   */
  bool force_show_detail_content;
  /**
   * iOS config
   *
   * <br>内部成员属性，传入空指针表示无效值，空串视为有效值；<br/>
   * 空串会被 encode 并传递给服务端<br/>且空串在业务上目前是无意义的，但以后有变为有意义的可能性<br/>
   * 比如：表示一些默认场景值，所以平台侧要保证不随意传入空串
   *
   */
  const struct RcimIosConfig *ios_config;
  /**
   * Android config
   *
   * <br>内部成员属性，传入空指针表示无效值，空串视为有效值；<br/>
   * 空串会被 encode 并传递给服务端<br/>且空串在业务上目前是无意义的，但以后有变为有意义的可能性<br/>
   * 比如：表示一些默认场景值，所以平台侧要保证不随意传入空串
   *
   */
  const struct RcimAndroidConfig *android_config;
  /**
   * Harmony config
   *
   * <br>内部成员属性，传入空指针表示无效值，空串视为有效值；<br/>
   * 空串会被 encode 并传递给服务端<br/>且空串在业务上目前是无意义的，但以后有变为有意义的可能性<br/>
   * 比如：表示一些默认场景值，所以平台侧要保证不随意传入空串
   *
   */
  const struct RcimHarmonyConfig *harmony_config;
} RcimPushConfig;

/**
 * 消息包装结构体
 */
typedef struct RcimMessageBox {
  /**
   * 会话类型
   */
  enum RcimConversationType conv_type;
  /**
   * 目标 ID
   */
  const char *target_id;
  /**
   * 所属会话的业务标识，长度限制 20 字符
   */
  const char *channel_id;
  /**
   * 数据库消息表递增 ID
   */
  int64_t message_id;
  /**
   * 消息方向
   */
  enum RcimMessageDirection direction;
  /**
   * 发送者 ID
   */
  const char *sender_id;
  const struct RcimReceivedStatus *received_status;
  enum RcimSentStatus sent_status;
  int64_t received_time;
  int64_t sent_time;
  /**
   * 消息的类型名
   */
  const char *object_name;
  /**
   * 消息内容 内置消息大都是 json 字符串，自定义消息可能是其他格式
   */
  const char *content;
  /**
   * 可被搜索的内容，只做为入参，不做出参，返回的消息该字段为空
   */
  const char *searchable_words;
  /**
   * 服务端生产的消息唯一 ID（在同一个 AppKey 下全局唯一）
   */
  const char *uid;
  /**
   * 消息的附加字段
   * Android: extra
   * iOS: extra
   * C++: extra_content_
   */
  const char *extra;
  /**
   * 群阅读回执信息
   */
  const struct RcimReadReceiptInfo *read_receipt_info;
  /**
   * 群阅读回执信息 V2
   */
  const struct RcimReadReceiptInfoV2 *read_receipt_info_v2;
  /**
   * 是否在收到消息的时候发送通知
   * Android: messageConfig
   * iOS: messageConfig
   * C++: disable_notification_
   */
  bool is_notification_disabled;
  /**
   * 消息推送配置
   * Android: messagePushConfig
   * iOS: messagePushConfig
   *
   * 内部成员属性，传入空指针表示无效值，空串视为有效值；
   * 空串会被 encode 并传递给服务端<br/>且空串在业务上目前是无意义的，但以后有变为有意义的可能性
   * 比如：表示一些默认场景值，所以平台侧要保证不随意传入空串
   *
   */
  const struct RcimPushConfig *push_config;
  /**
   * 是否是离线消息，只在接收消息的回调方法中有效，如果消息为离线消息，则为 true，其他情况均为 false
   * Android: isOffLine
   * iOS: isOffLine
   */
  bool is_offline;
  /**
   * 消息是否可以包含扩展信息
   * 该属性在消息发送时确定，发送之后不能再做修改
   * 扩展信息只支持单聊、群聊、超级群，其它会话类型不能设置扩展信息
   *
   * Android: extSupport
   * iOS: canIncludeExpansion
   * C++: ext_support_
   */
  bool is_ext_supported;
  /**
   * 必须是 json 字符串，形如 "{"key1":"value1","key2":"value2"}"
   * 否则会被返回 Json 解析错误
   *
   * Android: extMsg
   * iOS: expansionDicEx
   * C++: ext_msg_
   */
  const char *ext_content;
} RcimMessageBox;

/**
 * 收到拉取消息回调时，携带的接受信息
 */
typedef struct RcimReceivedInfo {
  int32_t left;
  bool has_package;
  bool is_offline;
} RcimReceivedInfo;

/**
 * 消息接收监听
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param msg_box      消息体，Rust 负责释放
 * @param info         接收消息信息，Rust 负责释放
 */
typedef void (*RcimMessageReceivedLsr)(const void *context,
                                       const struct RcimMessageBox *msg_box,
                                       const struct RcimReceivedInfo *info);

/**
 * 离线消息接收完成
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 */
typedef void (*RcimOfflineMessageSyncCompletedLsr)(const void *context);

/**
 * 获取消息入库搜索关键词监听回调
 * rust 通过此接口回调 C 获取消息入库搜索关键词
 *
 * @since v0.8.0
 *
 * @param callback_context      来自于 RcimMessageSearchableWordsCbLsr 的 callback_context 参数，C 首次回调后，Rust 释放，不可多次回调
 * @param searchable_words      可搜索内容，C 负责释放
 */
typedef void (*RcimMessageSearchableWordsCb)(const void *callback_context,
                                             const char *searchable_words);

/**
 * 获取消息入库搜索关键词监听
 * rust 通过此接口回调 C 通过回调方式获取消息入库搜索关键词，
 *
 * @since v0.8.0
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param obj_name         消息类型，rust 负责释放
 * @param content          消息内容 同 RcimMessageBox::content 字段，rust 负责释放
 * @param callback_context 回调上下文指针，不可回调多次，C 首次回调后，Rust 释放
 * @param searchable_words 回调的函数指针
 */
typedef void (*RcimMessageSearchableWordsCbLsr)(const void *context,
                                                const char *obj_name,
                                                const char *content,
                                                const void *callback_context,
                                                RcimMessageSearchableWordsCb searchable_words);

/**
 * 获取消息入库搜索关键词监听回调
 * rust 通过此接口回调 C 通过回调 压缩小视频消息
 *
 * @since v0.10.0
 *
 * @param callback_context      来自于 SightCompressCbLsr 的 callback_context 参数，C 首次回调后，Rust 释放，不可多次回调
 * @param compressed_path       压缩后的本地地址，C 负责释放
 */
typedef void (*RcimSightCompressCb)(const void *callback_context, const char *compressed_path);

/**
 * 小视频消息压缩回调监听
 * rust 通过此接口回调 C 通过回调 压缩小视频消息
 *
 * @since v0.10.0
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param target_width     压缩后的目标宽度
 * @param target_height    压缩后的目标高度
 * @param path             要压缩视频的本地地址，rust 负责释放
 * @param callback_context 回调上下文指针，不可回调多次，C 首次回调后，Rust 释放
 * @param callback         回调的函数指针
 */
typedef void (*RcimSightCompressCbLsr)(const void *context,
                                       uint32_t target_width,
                                       uint32_t target_height,
                                       const char *path,
                                       const void *callback_context,
                                       RcimSightCompressCb callback);

typedef struct RcimRecallNotificationMessage {
  /**
   * 序列化后的字符串，包含用户信息、扩展信息、@ 信息
   */
  const char *base_info;
  const char *operator_id;
  /**
   * 消息撤回时间
   */
  int64_t recall_time;
  /**
   * 原消息的消息类型名
   */
  const char *original_object_name;
  /**
   * 被撤回的原消息
   */
  const char *original_content;
  /**
   * 撤回的文本消息的内容
   */
  const char *recall_content;
  /**
   * 撤回消息的发送时间
   */
  int64_t action_time;
  /**
   * 是否是管理员操作
   */
  bool is_admin;
  /**
   * 是否已删除本地消息，即不保留小灰条提示
   */
  bool is_deleted;
} RcimRecallNotificationMessage;

/**
 * 撤回消息监听
 *
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param msg_box              消息体，Rust 负责释放
 * @param recall_notify        撤回消息通知，Rust 负责释放
 */
typedef void (*RcimRecallMessageLsr)(const void *context,
                                     const struct RcimMessageBox *msg_box,
                                     const struct RcimRecallNotificationMessage *recall_notify);

/**
 * 消息拦截信息
 */
typedef struct RcimMessageBlockInfo {
  /**
   * 会话类型
   */
  enum RcimConversationType conv_type;
  /**
   * 目标 ID
   */
  const char *target_id;
  /**
   * 所属会话的业务标识，长度限制 20 字符
   */
  const char *channel_id;
  /**
   * 服务端生产的消息唯一 ID（在同一个 AppKey 下全局唯一）
   */
  const char *uid;
  /**
   * 附加信息
   */
  const char *extra;
  /**
   * 消息拦截类型
   */
  enum RcimMessageBlockType block_type;
  /**
   * 消息源触发类型
   * 0 默认，原始消息
   * 1 消息扩展
   * 2 消息修改 目前只支持超级群
   */
  enum RcimMessageBlockSourceType source_type;
  /**
   * 源内容
   * sourceType=1 或 2 时返回；
   * 1 扩展内容 2 消息内容 目前只支持超级群
   */
  const char *source_content;
} RcimMessageBlockInfo;

/**
 * 消息拦截监听
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param msg_block_info   拦截消息信息，Rust 负责释放
 */
typedef void (*RcimMessageBlockedLsr)(const void *context,
                                      const struct RcimMessageBlockInfo *msg_block_info);

/**
 * 一期仅作占位
 */
typedef struct RcimSendMessageOption {
  /**
   * 是否属于 VoIP 推送
   */
  bool is_voip_push;
  /**
   * 消息指定接收者数组指针
   */
  const char *const *user_ids;
  /**
   * 消息指定接收者数组长度
   */
  int32_t user_ids_len;
  /**
   * 消息是否被加密
   */
  bool encrypted;
} RcimSendMessageOption;

/**
 * 返回错误码 + 单条消息回调
 *
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code                 结果码
 * @param msg_box              指向查询结果消息体指针的指针（无消息返回 NULL），C 负责释放
 */
typedef void (*RcimCodeMessageCb)(const void *context,
                                  enum RcimEngineError code,
                                  const struct RcimMessageBox *msg_box);

/**
 * 返回单条消息的回调
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param msg_box      消息体，Rust 负责释放
 */
typedef void (*RcimMessageCb)(const void *context, const struct RcimMessageBox *msg_box);

/**
 * 发送群聊已读回执消息信息
 */
typedef struct RcimSendReadReceiptResponseMessageData {
  /**
   * 原消息发送者 ID
   */
  const char *sender_id;
  /**
   * 原消息 UID
   */
  const char *message_uid;
} RcimSendReadReceiptResponseMessageData;

/**
 * 获取多条消息回调
 *
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code                 结果码
 * @param msg_box_vec          消息数组指针，Rust 负责释放
 * @param msg_box_vec_len      消息数组长度
 */
typedef void (*RcimGetMessageListCb)(const void *context,
                                     enum RcimEngineError code,
                                     const struct RcimMessageBox *msg_box_vec,
                                     int32_t msg_box_vec_len);

/**
 * 返回单条消息的回调，与 RcimMessageCb 的区别在于此回调用于设置监听的接口
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param msg_box      消息体，Rust 负责释放
 */
typedef void (*RcimMessageNotifyLsr)(const void *context, const struct RcimMessageBox *msg_box);

/**
 * 群组中某人发起了回执请求，会话中其余人会收到该请求，并回调此方法。
 *
 * @param context        上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param conv_type      会话类型
 * @param target_id      会话目标 ID，Rust 负责释放
 * @param channel_id     会话的业务标识，Rust 负责释放
 * @param message_uid    请求已读回执的消息 UID，Rust 负责释放
 */
typedef void (*RcimReadReceiptRequestLsr)(const void *context,
                                          enum RcimConversationType conv_type,
                                          const char *target_id,
                                          const char *channel_id,
                                          const char *message_uid);

/**
 * 群组中发起了回执请求的用户，当收到接收方的响应时，会回调此方法。
 *
 * @param context               上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param conv_type             会话类型
 * @param target_id             会话目标 ID，Rust 负责释放
 * @param channel_id            会话的业务标识，Rust 负责释放
 * @param message_uid           请求已读回执的消息 UID，Rust 负责释放
 * @param respond_user_vec      已读成员数组指针，Rust 负责释放
 * @param respond_user_vec_len  已读成员数组长度
 */
typedef void (*RcimReadReceiptResponseLsr)(const void *context,
                                           enum RcimConversationType conv_type,
                                           const char *target_id,
                                           const char *channel_id,
                                           const char *message_uid,
                                           const struct RcimReadReceiptUserInfo *respond_user_vec,
                                           int32_t respond_user_vec_len);

/**
 * 群聊已读 V2 的已读成员信息
 */
typedef struct RcimReadReceiptV2ReaderInfo {
  /**
   * 已读用户 userid
   */
  const char *user_id;
  /**
   * 已读时间
   */
  int64_t read_time;
} RcimReadReceiptV2ReaderInfo;

/**
 * 已读回执 v2 消息的已读用户列表
 *
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code                 结果码
 * @param total_count          总人数
 * @param reader_vec           已读用户数组指针，Rust 负责释放
 * @param reader_vec_len       已读用户数组长度
 */
typedef void (*RcimGetReadReceiptV2ReaderListCb)(const void *context,
                                                 enum RcimEngineError code,
                                                 uint32_t total_count,
                                                 const struct RcimReadReceiptV2ReaderInfo *reader_vec,
                                                 int32_t reader_vec_len);

/**
 * 群组中消息发送方，当收到的已读回执 V2 响应时，会回调此方法
 *
 * @param context               上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param conv_type             会话类型
 * @param target_id             会话目标 ID，Rust 负责释放
 * @param channel_id            会话的业务标识，Rust 负责释放
 * @param message_uid           请求已读回执的消息 UID，Rust 负责释放
 * @param read_count            已读人数
 * @param total_count           总人数
 */
typedef void (*RcimReadReceiptResponseV2Lsr)(const void *context,
                                             enum RcimConversationType conv_type,
                                             const char *target_id,
                                             const char *channel_id,
                                             const char *message_uid,
                                             uint32_t read_count,
                                             uint32_t total_count);

/**
 * 多媒体消息上传进度回调
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param msg_box      消息体，Rust 负责释放
 * @param progress     上传进度，[0, 100] 的整数
 */
typedef void (*RcimSendMessageOnProgressCb)(const void *context,
                                            const struct RcimMessageBox *msg_box,
                                            uint8_t progress);

/**
 * 消息自定义上传下载进度回调
 *
 * @since v0.16.0
 *
 * @param context      回调进度与结果的上下文指针，Rust 释放
 * @param progress     进度，[0, 100] 的整数
 */
typedef void (*RcimMediaHandlerProgressCb)(const void *context, int32_t progress);

/**
 * 消息自定义上传下载结果回调
 *
 * @since v0.16.0
 *
 * @param context      回调进度与结果的上下文指针，Rust 释放
 * @param ret          上传下载结果
 * @param value        上传下载成功后的返回值，上传返回远端地址，下载返回本地路径，C 负责释放
 */
typedef void (*RcimMediaHandlerResultCb)(const void *context,
                                         enum RcimMediaHandlerError ret,
                                         const char *value);

/**
 * 消息自定义上传下载回调
 *
 * @since v0.16.0
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param msg_box          消息体，Rust 负责释放
 * @param cb_context       回调进度与结果的上下文指针，Rust 负责释放
 * @param progress_cb      进度回调的函数指针
 * @param result_cb        结果回调的函数指针
 */
typedef void (*RcimMediaMessageHandlerCb)(const void *context,
                                          const struct RcimMessageBox *msg_box,
                                          const void *cb_context,
                                          RcimMediaHandlerProgressCb progress_cb,
                                          RcimMediaHandlerResultCb result_cb);

/**
 * 多媒体文件下载回调
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code         结果码
 * @param path         下载后的本地地址，Rust 负责释放
 */
typedef void (*RcimDownloadMediaCb)(const void *context, enum RcimEngineError code, const char *path);

/**
 * 多媒体消息下载进度回调
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param message_id   消息 ID
 * @param progress     下载进度，[0, 100] 的整数
 */
typedef void (*RcimDownloadMessageProgressCb)(const void *context,
                                              int64_t message_id,
                                              uint8_t progress);

/**
 * 多媒体文件下载进度回调
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param unique_id    下载唯一标识
 * @param progress     下载进度，[0, 100] 的整数
 */
typedef void (*RcimDownloadFileProgressCb)(const void *context,
                                           const char *unique_id,
                                           uint8_t progress);

/**
 * 撤回消息回调
 *
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code                 结果码
 * @param recall_notify        撤回消息通知，Rust 负责释放
 */
typedef void (*RcimRecallMessageCb)(const void *context,
                                    enum RcimEngineError code,
                                    const struct RcimRecallNotificationMessage *recall_notify);

typedef struct RcimMessageType {
  /**
   * 消息标签名称
   */
  const char *object_name;
  /**
   * 消息本地存储类型
   */
  enum RcimMessageFlag flag;
  /**
   * 是否为多媒体消息
   */
  bool is_media_message;
} RcimMessageType;

/**
 * 消息扩展 kv 信息
 */
typedef struct RcimMessageExpansionKvInfo {
  /**
   * 消息扩展 kv 名称，取值范围 [1, 32]
   */
  const char *key;
  /**
   * 消息扩展 kv 对应的值，取值范围 [1, 4096]
   */
  const char *value;
} RcimMessageExpansionKvInfo;

/**
 * 消息扩展更新监听
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param kv_vec           kv 数组，Rust 负责释放
 * @param kv_vec_len       kv 数组长度
 * @param msg_box          消息体，Rust 负责释放
 */
typedef void (*RcimMessageExpansionKvUpdateLsr)(const void *context,
                                                const struct RcimMessageExpansionKvInfo *kv_vec,
                                                int32_t kv_vec_len,
                                                const struct RcimMessageBox *msg_box);

/**
 * 消息扩展移除监听
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param key_vec          key 数组，Rust 负责释放
 * @param key_vec_len      kv 数组长度
 * @param msg_box          消息体，Rust 负责释放
 */
typedef void (*RcimMessageExpansionKvRemoveLsr)(const void *context,
                                                const char *const *key_vec,
                                                int32_t key_vec_len,
                                                const struct RcimMessageBox *msg_box);

/**
 * 返回 bool 类型的通用回调接口
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code         结果码
 * @param value        结果值
 */
typedef void (*RcimGetBoolCb)(const void *context, enum RcimEngineError code, bool value);

/**
 * 阅后即焚 ------------------------------------------------------------------------------------
 * 消息阅后即焚开始监听
 *
 * @since 0.11.0
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param msg_box      消息体，Rust 负责释放
 * @param left_duration 阅后即焚时长，单位为秒，消息每经过 1 秒，就触发一次。当 left_duration 为 0 时，SDK 会将本地该消息和远端该消息删除，聊天页面需要将该消息从消息列表移除
 * @warning 国内不允许带阅后即焚功能的 App 上架
 */
typedef void (*RcimMessageDestructingLsr)(const void *context,
                                          const struct RcimMessageBox *msg_box,
                                          int32_t left_duration);

/**
 * 消息阅后即焚停止监听
 *
 * @since 0.11.0
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param msg_box      消息体，Rust 负责释放
 * @warning 国内不允许带阅后即焚功能的 App 上架
 */
typedef void (*RcimMessageDestructionStopLsr)(const void *context,
                                              const struct RcimMessageBox *msg_box);

typedef struct RcimConversationStatusChangeItem {
  /**
   * 会话类型
   */
  enum RcimConversationType conv_type;
  /**
   * 会话目标 ID，可为 NULL，例如：按照会话类型设置免打扰
   */
  const char *target_id;
  /**
   * 会话频道 ID，可为 NULL
   */
  const char *channel_id;
  /**
   * 更新时间
   */
  int64_t update_time;
  /**
   * 以下状态属性，一般更新了哪些状态，就会有哪些状态的值，否则为 NULL。
   *
   * 置顶时间，可为 NULL
   */
  const int64_t *pin_time;
  /**
   * 置顶状态，可为 NULL
   */
  const bool *is_pinned;
  /**
   * 免打扰，可为 NULL
   */
  const enum RcimPushNotificationMuteLevel *mute_level;
} RcimConversationStatusChangeItem;

/**
 * 会话状态变更监听
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param status_vec       会话状态变更项数组指针，Rust 负责释放
 * @param status_vec_len   会话状态变更项数组长度
 */
typedef void (*RcimConversationStatusLsr)(const void *context,
                                          const struct RcimConversationStatusChangeItem *status_vec,
                                          int32_t status_vec_len);

typedef struct RcimTypingStatus {
  /**
   * 目标 ID
   */
  const char *user_id;
  /**
   * 所属会话的业务标识，长度限制 20 字符
   */
  const char *object_name;
  /**
   * 发送时间
   */
  uint64_t sent_time;
} RcimTypingStatus;

/**
 * 输入状态监听
 * @param context                          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param conv_type                        待删除消息的会话类型，不支持聊天室
 * @param target_id                        待删除消息的会话目标 ID，非 NULL 必传，Rust 负责释放
 * @param channel_id                       待删除消息的频道 ID，可为 NULL，Rust 负责释放
 * @param typing_status                    消息状态，可为 NULL，Rust 负责释放
 * @param typing_status_vec_len            消息状态指针数组长度
 */
typedef void (*RcimTypingStatusLsr)(const void *context,
                                    enum RcimConversationType conv_type,
                                    const char *target_id,
                                    const char *channel_id,
                                    const struct RcimTypingStatus *typing_status,
                                    int32_t typing_status_vec_len);

typedef struct RcimConversation {
  enum RcimConversationType conv_type;
  const char *target_id;
  const char *channel_id;
  /**
   * 未读消息数
   */
  int32_t unread_message_count;
  /**
   * 是否置顶
   */
  bool is_pinned;
  /**
   * 最后一条接收消息时间
   */
  int64_t last_received_time;
  /**
   * 最后一条发送消息时间
   */
  int64_t last_sent_time;
  /**
   * 最后一次操作时间
   */
  int64_t last_operate_time;
  const char *object_name;
  const char *sender_user_id;
  int64_t last_message_id;
  /**
   * 最后一条消息内容 内置消息大都是 json 字符串，自定义消息可能是其他格式
   */
  const char *last_message_content;
  const char *draft;
  enum RcimPushNotificationMuteLevel mute_level;
  int32_t mentioned_count;
  /**
   * 匹配到的会话内消息数，只有在搜索会话时才会有值
   */
  uint32_t match_count;
} RcimConversation;

/**
 * 获取本地会话结果回调
 *
 * @param context                  上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code                     结果码
 * @param conv                     会话对象指针，在 callback 调用后，Rust 负责释放
 */
typedef void (*RcimGetConversationCb)(const void *context,
                                      enum RcimEngineError code,
                                      const struct RcimConversation *conv);

/**
 * 获取本地会话结果回调
 *
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code                 结果码
 * @param conv_raw_vec         会话对象指针数组，在 callback 调用后，Rust 负责释放
 * @param conv_raw_vec_len     会话对象指针数组长度
 */
typedef void (*RcimGetConversationListCb)(const void *context,
                                          enum RcimEngineError code,
                                          const struct RcimConversation *conv_raw_vec,
                                          int32_t conv_raw_vec_len);

typedef struct RcimConversationIdentifier {
  enum RcimConversationType conv_type;
  const char *target_id;
  const char *channel_id;
} RcimConversationIdentifier;

/**
 * 获取本地会话置顶状态回调
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code             结果码
 *
 */
typedef void (*RcimGetLocalConversationMuteLevelCb)(const void *context,
                                                    enum RcimEngineError code,
                                                    enum RcimPushNotificationMuteLevel mute_level);

/**
 * 获取推送免打扰设置的回调
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code             结果码
 * @param start_time       免打扰的开始时间，格式为 "HH:MM:SS"，非 NULL 必传，Rust 负责释放
 * @param duration_min     免打扰的持续时长（分钟）
 * @param mute_level       免打扰级别
 */
typedef void (*RcimGetNoDisturbingCb)(const void *context,
                                      enum RcimEngineError code,
                                      const char *start_time,
                                      int32_t duration_min,
                                      enum RcimPushNotificationMuteLevel mute_level);

/**
 * 获取会话草稿回调
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code           结果码
 * @param draft            草稿内容，Rust 负责释放
 */
typedef void (*RcimGetTextMessageDraftCb)(const void *context,
                                          enum RcimEngineError code,
                                          const char *draft);

/**
 * 获取数量回调
 *
 * @param context       上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code          结果码
 * @param count         数量返回值
 */
typedef void (*RcimGetCountCb)(const void *context, enum RcimEngineError code, int64_t count);

/**
 * 会话已读状态监听
 *
 * @since 0.10.0
 *
 * @param context                  上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param conv_type                同步已读的会话类型
 * @param target_id                同步已读的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id               同步已读的频道 ID，可为 NULL，C 负责释放
 * @param timestamp                同步已读的时间戳，发送时间小于等于该值的所有消息都会被清除未读状态，消息的具体发送时间，不能小于等于 0
 */
typedef void (*RcimConversationReadStatusLsr)(const void *context,
                                              enum RcimConversationType conv_type,
                                              const char *target_id,
                                              const char *channel_id,
                                              int64_t timestamp);

typedef struct RcimChatroomJoinedInfo {
  /**
   * 聊天室创建时间
   */
  int64_t create_time;
  /**
   * 聊天室总人数
   */
  int32_t member_count;
  /**
   * 是否全局禁言
   */
  bool is_all_chatroom_banned;
  /**
   * 是否当前用户被禁言
   */
  bool is_current_user_banned;
  /**
   * 当前用户是否在此聊天室被禁言
   */
  bool is_current_chatroom_banned;
  /**
   * 当前用户是否在此聊天室的白名单中
   */
  bool is_current_chatroom_in_whitelist;
} RcimChatroomJoinedInfo;

/**
 * 聊天室状态监听器
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code         错误码，在 status 为 RcimChatroomStatus::JoinFailed 和 RcimChatroomStatus::LeaveFailed 时有错误信息，其它情况为 RcimEngineError::Success
 * @param room_id      聊天室 ID，Rust 负责释放
 * @param status       聊天室状态
 * @param response     聊天室信息，只有 status 为 RcimChatroomStatus::Joined 时有效，Rust 负责释放
 */
typedef void (*RcimChatroomStatusLsr)(const void *context,
                                      enum RcimEngineError code,
                                      const char *room_id,
                                      enum RcimChatroomStatus status,
                                      const struct RcimChatroomJoinedInfo *response);

/**
 * 聊天室成员事件信息
 */
typedef struct RcimChatroomMemberActionInfo {
  /**
   * 用户 ID
   */
  const char *user_id;
  /**
   * 事件类型
   */
  enum RcimChatroomMemberActionType action_type;
} RcimChatroomMemberActionInfo;

/**
 * 聊天室成员变化信息
 */
typedef struct RcimChatroomMemberChangeInfo {
  /**
   * 聊天室 ID
   */
  const char *room_id;
  /**
   * 用户 ID
   */
  int32_t member_count;
  /**
   * 用户事件数组
   */
  const struct RcimChatroomMemberActionInfo *action_vec;
  /**
   * 用户事件数组长度
   */
  int32_t action_vec_len;
} RcimChatroomMemberChangeInfo;

/**
 * 聊天室成员变化监听
 *
 * @param context 上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param change_info 成员变化信息，Rust 负责释放
 */
typedef void (*RcimChatroomMemberChangedLsr)(const void *context,
                                             const struct RcimChatroomMemberChangeInfo *change_info);

/**
 * 聊天室禁言信息
 */
typedef struct RcimChatroomMemberBannedInfo {
  /**
   * 聊天室 ID
   */
  const char *room_id;
  /**
   * 事件类型
   */
  enum RcimChatroomMemberBannedEventType event_type;
  /**
   * 禁言时长，单位毫秒，范围为 [1 * 60_000, 43_200 * 60_000]
   */
  int64_t duration_time;
  /**
   * 操作时间，单位毫秒
   */
  int64_t operate_time;
  /**
   * 用户 ID 数组
   */
  const char *const *user_id_vec;
  /**
   * 用户 ID 数组长度
   */
  int32_t user_id_vec_len;
  /**
   * 附加信息
   */
  const char *extra;
} RcimChatroomMemberBannedInfo;

/**
 * 聊天室禁言监听
 *
 * @param context 上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param ban_info 禁言信息，Rust 负责释放
 */
typedef void (*RcimChatroomMemberBannedLsr)(const void *context,
                                            const struct RcimChatroomMemberBannedInfo *ban_info);

/**
 * 聊天室封禁信息
 */
typedef struct RcimChatroomMemberBlockedInfo {
  /**
   * 聊天室 ID
   */
  const char *room_id;
  /**
   * 事件类型
   */
  enum RcimChatroomMemberBlockedEventType event_type;
  int64_t duration_time;
  /**
   * 操作时间，单位毫秒
   */
  int64_t operate_time;
  /**
   * 用户 ID 数组
   */
  const char *const *user_id_vec;
  /**
   * 用户 ID 数组长度
   */
  int32_t user_id_vec_len;
  /**
   * 附加信息
   */
  const char *extra;
} RcimChatroomMemberBlockedInfo;

/**
 * 聊天室用户封禁监听
 *
 * @param context 上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param block_info 封禁信息，Rust 负责释放
 */
typedef void (*RcimChatroomMemberBlockedLsr)(const void *context,
                                             const struct RcimChatroomMemberBlockedInfo *block_info);

/**
 * 聊天室封禁信息
 */
typedef struct RcimChatroomMultiClientSyncInfo {
  /**
   * 聊天室 ID
   */
  const char *room_id;
  /**
   * 事件类型
   */
  enum RcimChatroomMultiClientSyncEventType event_type;
  /**
   * 离开类型，event_type 为 quit 是有效
   */
  enum RcimChatroomMultiClientSyncQuitType quit_type;
  /**
   * 同步通知的变更时间，单位毫秒
   */
  int64_t time;
  /**
   * 附加信息
   */
  const char *extra;
} RcimChatroomMultiClientSyncInfo;

/**
 * 聊天室多端同步监听
 *
 * @param context 上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param sync_info 同步信息，Rust 负责释放
 */
typedef void (*RcimChatroomMultiClientSyncLsr)(const void *context,
                                               const struct RcimChatroomMultiClientSyncInfo *sync_info);

/**
 * 加入聊天室结果回调
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code         结果码
 * @param info         加入聊天室的信息，只有 code 为 RcimEngineError::Success 时有效
 */
typedef void (*RcimJoinChatroomCb)(const void *context,
                                   enum RcimEngineError code,
                                   const struct RcimChatroomJoinedInfo *info);

/**
 * 加入已存在的房间回调
 */
typedef RcimJoinChatroomCb RcimJoinExistingChatroomCb;

typedef struct RcimChatroomUserInfo {
  /**
   * 用户 ID
   */
  const char *user_id;
  /**
   * 加入聊天室时间
   */
  int64_t join_time;
} RcimChatroomUserInfo;

/**
 * 聊天室信息
 */
typedef struct RcimChatroomInfo {
  /**
   * 聊天室 ID
   */
  const char *room_id;
  /**
   * 当前聊天室用户总人数
   */
  int32_t total_user_count;
  /**
   * 查询用户信息列表中，用户的加入顺序
   */
  enum RcimOrder join_order;
  /**
   * 查询用户信息列表
   */
  const struct RcimChatroomUserInfo *user_info_vec;
  /**
   * 查询用户信息列表的长度
   */
  int32_t user_info_vec_len;
} RcimChatroomInfo;

typedef void (*RcimGetChatroomInfoCb)(const void *context,
                                      enum RcimEngineError code,
                                      const struct RcimChatroomInfo *room_info);

/**
 * 聊天室 kv 同步监听
 *
 * @param context 上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param room_id 聊天室 ID
 */
typedef void (*RcimChatroomKvSyncLsr)(const void *context, const char *room_id);

/**
 * 聊天室 kv 信息
 */
typedef struct RcimChatroomKvInfo {
  /**
   * 聊天室属性名称，取值范围 [1, 128]
   */
  const char *key;
  /**
   * 聊天室属性对应的值，取值范围 [1, 4096]
   */
  const char *value;
} RcimChatroomKvInfo;

/**
 * 聊天室 kv 更新监听
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param room_id          聊天室 ID
 * @param kv_vec           kv 数组，Rust 负责释放
 * @param kv_vec_len       kv 数组长度
 */
typedef void (*RcimChatroomKvChangedLsr)(const void *context,
                                         const char *room_id,
                                         const struct RcimChatroomKvInfo *kv_vec,
                                         int32_t kv_vec_len);

/**
 * 聊天室 kv 删除监听
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param room_id          聊天室 ID，Rust 负责释放
 * @param kv_vec           kv 数组，Rust 负责释放
 * @param kv_vec_len       kv 数组长度
 */
typedef void (*RcimChatroomKvDeleteLsr)(const void *context,
                                        const char *room_id,
                                        const struct RcimChatroomKvInfo *kv_vec,
                                        int32_t kv_vec_len);

/**
 * 聊天室 Kv 错误信息
 */
typedef struct RcimChatroomKeyErrorInfo {
  const char *key;
  enum RcimEngineError error;
} RcimChatroomKeyErrorInfo;

/**
 * 设置 kv 的结果回调
 *
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code                 结果码
 * @param failed_vec           失败的 kv 数组，Rust 负责释放
 * @param failed_vec_len       失败的 kv 数组长度
 */
typedef void (*RcimChatroomKvCb)(const void *context,
                                 enum RcimEngineError code,
                                 const struct RcimChatroomKeyErrorInfo *failed_vec,
                                 int32_t failed_vec_len);

/**
 * 获取聊天室自定义属性回调
 *
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code                 结果码
 * @param kv_vec               kv 数组，Rust 负责释放
 * @param kv_vec_len           kv 数组长度
 */
typedef void (*RcimChatroomGetKvCb)(const void *context,
                                    enum RcimEngineError code,
                                    const struct RcimChatroomKvInfo *kv_vec,
                                    int32_t kv_vec_len);

/**
 * 日志信息
 */
typedef struct RcimLogInfo {
  /**
   * 引擎 ID，用于区分引擎多实例下的不同实例
   */
  const char *session_id;
  /**
   * 业务类型，目前大数据平台只有 IM 和 RTC 两个值
   */
  enum RcimLogType log_type;
  /**
   * 日志来源，用来标识日志埋点层级，如 RTCLib、CallLib 等，业务自己订
   */
  enum RcimLogSource source;
  /**
   * 日志等级
   */
  enum RcimLogLevel level;
  /**
   * 日志标签，日志大数据平台会根据这个字段进行聚合分析
   */
  const char *tag;
  /**
   * 日志内容
   */
  const char *content;
  /**
   * 用于异步事务的追踪 ID
   */
  int64_t trace_id;
  /**
   * 时间戳
   */
  int64_t create_time;
  /**
   * 日志埋点位置
   */
  const char *location;
} RcimLogInfo;

/**
 * 日志回调监听
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param log_info     日志数据
 */
typedef void (*RcimLogLsr)(const void *context, const struct RcimLogInfo *log_info);

/**
 * 插入日志信息
 */
typedef struct RcimInsertLogInfo {
  /**
   * 业务类型，目前大数据平台只有 IM 和 RTC 两个值
   */
  enum RcimLogType log_type;
  /**
   * 日志来源，用来标识日志埋点层级，如 RTCLib、CallLib 等，业务自己订
   */
  enum RcimLogSource source;
  /**
   * 日志等级
   */
  enum RcimLogLevel level;
  /**
   * 日志标签，日志大数据平台会根据这个字段进行聚合分析
   */
  const char *tag;
  /**
   * 日志内容
   */
  const char *content;
  /**
   * 用于异步事务的追踪 ID
   */
  int64_t trace_id;
  /**
   * 日志埋点位置信息
   */
  const char *location;
} RcimInsertLogInfo;

typedef void (*RcimDevLogLsr)(enum RcimDevLogLevel level, const char *log_str);

/**
 * 公众号菜单子菜单
 */
typedef struct RcimPublicServiceMenuItem {
  /**
   * 菜单的 ID
   */
  const char *id;
  /**
   * 菜单的标题
   */
  const char *name;
  /**
   * 菜单的 URL 链接
   */
  const char *url;
  /**
   * 菜单的类型
   */
  enum RcimPublicServiceMenuItemType menu_type;
  /**
   * 菜单的子菜单
   */
  const struct RcimPublicServiceMenuItem *sub_menu_vec;
  /**
   * 菜单的子菜单长度
   */
  int32_t sub_menu_vec_len;
} RcimPublicServiceMenuItem;

/**
 * 公众号信息
 */
typedef struct RcimPublicServiceInfo {
  /**
   * 公众号 ID
   */
  const char *target_id;
  /**
   * 公众号类型，仅支持 AppPublicService
   */
  enum RcimConversationType conv_type;
  /**
   * 公众号名称
   */
  const char *name;
  /**
   * 公众号头像
   */
  const char *portrait;
  /**
   * 公众号描述
   */
  const char *introduction;
  /**
   * 是否关注该公众服务账号
   */
  bool is_followed;
  /**
   * 菜单的子菜单
   */
  const struct RcimPublicServiceMenuItem *menu_vec;
  /**
   * 菜单的子菜单长度
   */
  int32_t menu_vec_len;
  /**
   * 公众服务账号的全局属性
   * 此公众服务账号是否设置为所有用户均关注。
   */
  bool is_global;
} RcimPublicServiceInfo;

/**
 * 获取本地订阅的公众号结果回调
 *
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code                 结果码
 * @param public_service       公众号信息，Rust 负责释放
 *
 * @remark public_service 使用时，需判断 code 为 RcimEngineError::Success，并且不为 NULL
 */
typedef void (*RcimGetPublicServiceCb)(const void *context,
                                       enum RcimEngineError code,
                                       const struct RcimPublicServiceInfo *public_service);

/**
 * 获取本地订阅的公众号列表结果回调
 *
 * @param context                  上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code                     结果码
 * @param public_service_vec       公众号信息数组，Rust 负责释放
 * @param public_service_vec_len   公众号信息数组长度
 */
typedef void (*RcimGetLocalPublicServiceListCb)(const void *context,
                                                enum RcimEngineError code,
                                                const struct RcimPublicServiceInfo *info_vec,
                                                int32_t info_vec_len);

/**
 * RTC 信令相关 ------------------------------------------------------------------------------------
 * 导航中的 rtc 配置
 */
typedef struct RcimRtcConfig {
  const char *log_server;
  const char *data_center;
  const char *jwt_token;
  bool open_gzip;
  const char *voip_call_info;
} RcimRtcConfig;

/**
 * Voip 通话信息监听
 *
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param conf             Voip 配置信息，Rust 负责释放
 */
typedef void (*RcimVoipCallInfoLsr)(const void *context, const struct RcimRtcConfig *conf);

/**
 * 发送 RTC 信令回调结果
 *
 * @since v0.10.0
 *
 * @param context        上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code           结果码
 * @param info_vec       发送结果数组，Rust 负责释放
 * @param info_vec_len   发送结果数组长度
 */
typedef void (*RcimSendRtcSignalingCb)(const void *context,
                                       enum RcimEngineError code,
                                       const uint8_t *info_vec,
                                       int32_t info_vec_len);

/**
 * RTC 心跳发送回调，主要返回请求 ID
 */
typedef void (*RcimRtcHeartBeatSendLsr)(const void *context, const char *room_id, int64_t request_id);

/**
 * RTC 心跳发送结果回调，根据 code 确定是否成功
 */
typedef void (*RcimRtcHeartBeatResultLsr)(const void *context,
                                          enum RcimEngineError code,
                                          const char *room_id,
                                          int64_t request_id,
                                          int64_t version);

/**
 * RTC 房间事件监听
 */
typedef void (*RcimRtcRoomEventLsr)(const void *context,
                                    const uint8_t *pb_buffer_vec,
                                    int32_t pb_buffer_vec_len);

/**
 * 发送 RTC kv 信令回调结果（内部方法，禁止私自调用）
 *
 * @since v0.10.0
 *
 * @param context        上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code           结果码
 * @param key            返回的 key，Rust 负责释放
 * @param value          返回的 value，Rust 负责释放
 */
typedef void (*RcimRtcSetKVSignalingCb)(const void *context,
                                        enum RcimEngineError code,
                                        const char *key,
                                        const char *value);

/**
 * RTC kv 信息，仿照 RcimMessageExpansionKvInfo
 */
typedef struct RcimRtcKvInfo {
  /**
   * Rtc 属性名称，Rtc 控制长度
   */
  const char *key;
  /**
   * Rtc 性对应的值，Rtc 控制长度
   */
  const char *value;
} RcimRtcKvInfo;

/**
 * RTC groupCall kv 变化监听
 */
typedef void (*RcimRtcKvSignalingLsr)(const void *context,
                                      const struct RcimRtcKvInfo *kv_vec,
                                      int32_t kv_vec_len);

/**
 * cmp send 监听回调，内部使用
 *
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param code       结果码
 * @param value      结果值
 * 1: publish 限频 5 次/秒
 * 2: query 限频 50 次/秒
 * 其它：如 connect、disconnect、ping 等暂无限频，不需考虑
 */
typedef void (*RcimCmpSendCb)(const void *context, int32_t value);

/**
 * 创建引擎构造器，注：所有 C 接口对象遵循谁创建谁释放原则
 *
 * @since v0.5.0
 *
 * @param builder_param            参数结构体，C 负责释放
 * @param out_builder              参数返回值，指向引擎构造器指针的指针，C 负责释放，释放方式为传入 rcim_engine_builder_build 或 rcim_destroy_engine_builder 销毁
 * @return                         调用结果码
 */
RC_API
enum RcimEngineError rcim_create_engine_builder(struct RcimEngineBuilderParam *builder_param,
                                                struct RcimEngineBuilder **out_builder);

/**
 * 直接销毁引擎构造器。可以在 rcim_engine_builder_build 前，直接调用此函数销毁引擎构造器。
 *
 * @since v0.5.0
 *
 * @param builder      引擎构造器指针，Rust 负责释放
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_destroy_engine_builder(struct RcimEngineBuilder *builder);

/**
 * 设置融云服务的云类型，若不主动设置，则默认为 PublicCloud
 * 此接口由平台层打包 SDK 时设置，跟导航取回来的配置相互印证，具体如下：
 * 平台层公有云 + 导航公有云 = 公有云逻辑
 * 平台层私有云 + 导航私有云 = 私有云逻辑
 * 平台层私有云 + 导航公有云 = 私有云逻辑（私有云客户，还没来得及部署私有云环境时，会暂时用公有云服务来对接开发）
 * 平台层公有云 + 导航私有云 = 禁止连接
 *
 * 该方法要在调用 rcim_engine_builder_build 之前执行
 *
 * @since v0.5.0
 *
 * @param builder          引擎构造器指针，C 负责释放
 * @param cloud_type       云类型，C 负责释放
 * @return                 调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_builder_set_cloud_type(struct RcimEngineBuilder *builder,
                                                        enum RcimCloudType cloud_type);

/**
 * 设置数据库是否加密
 *
 * 该方法要在调用 rcim_engine_builder_build 之前执行
 *
 * @since v0.9.0
 *
 * @param builder          引擎构造器指针，C 负责释放
 * @param is_encrypted     是否加密
 * @return                 调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_builder_set_db_encrypted(struct RcimEngineBuilder *builder,
                                                          bool is_encrypted);

/**
 * groupCall 是否开启，默认 false
 *
 * 该方法要在调用 rcim_engine_builder_build 之前执行
 *
 * @since v0.10.0
 *
 * @param builder          引擎构造器指针，C 负责释放
 * @param is_enabled       是否开启 groupCall
 * @return                 调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_builder_set_enable_group_call(struct RcimEngineBuilder *builder,
                                                               bool is_enabled);

/**
 * 设置断线重连时是否踢出重连设备，默认 false
 * 如果不允许多端登录，设置 true 时，SDK 重连的时候发现此时已有别的设备连接成功，不再强行踢出已有设备，而是踢出重连设备，否则踢出已有设备
 * 默认 false
 *
 * 该方法要在调用 rcim_engine_builder_build 之前执行
 *
 * @since v0.10.0
 *
 * @param builder          引擎构造器指针，C 负责释放
 * @param is_enabled       是否设置断线重连时是否踢出重连设备
 * @return                 调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_builder_set_enable_reconnect_kick(struct RcimEngineBuilder *builder,
                                                                   bool is_enabled);

/**
 * 设置文件存储根路径，初始化时在此路径下自动创建 RongCloud 目录，所有 SDK 相关文件都存储在其中
 *
 * 该方法要在调用 rcim_engine_builder_build 之前执行
 *
 * @since v0.5.0
 *
 * @param builder      引擎构造器指针，C 负责释放
 * @param path         文件存储根路径，C 负责释放
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_builder_set_store_path(struct RcimEngineBuilder *builder,
                                                        const char *path);

/**
 * 设置内外网环境
 * 此字段会在私有云请求导航、私有云多媒体文件鉴权中使用
 *
 * 该方法要在调用 rcim_engine_builder_build 之前执行
 *
 * @since v0.13.0
 *
 * @param builder      引擎构造器指针，C 负责释放
 * @param network_env  请求环境
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_builder_set_network_env(struct RcimEngineBuilder *builder,
                                                         const char *network_env);

/**
 * 设置文件存储根路径，初始化时在此路径下自动创建 file 目录，下载的文件存储在其中
 *
 * 该方法要在调用 rcim_engine_builder_build 之前执行
 *
 * @since v0.5.0
 *
 * @param builder      引擎构造器指针，C 负责释放
 * @param path         文件存储根路径，C 负责释放
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_builder_set_file_path(struct RcimEngineBuilder *builder,
                                                       const char *path);

/**
 * 设置导航服务器地址
 *
 * 该方法要在调用 rcim_engine_builder_build 之前执行
 *
 * @since v0.5.0
 *
 * @param builder      引擎构造器指针，C 负责释放
 * @param navi_url_vec 导航服务器地址指针列表，C 负责释放
 * @param navi_url_vec_len 导航服务器地址指针列表长度
 * @return             调用结果码
 *
 * @remark 仅限独立数据中心使用，使用前必须先联系商务开通。
 * 如果设置 naviServer，必须为有效的服务器地址：
 * 1. 如果使用 https，则设置为 https://cn.xxx.com:port 或 https://cn.xxx.com 或  cn.xxx.com【SDK 默认使用 https】，其中域名部分也可以是 IP，如果不指定端口，将默认使用 443 端口。
 * 2. 如果使用 http，则设置为 http://cn.xxx.com:port 或 http://cn.xxx.com 格式，其中域名部分也可以是 IP，如果不指定端口，将默认使用 80 端口。
 * iOS 默认只能使⽤ HTTPS 协议。如果您使⽤ http 协议，请参考 Apple 开发⽂档中的 ATS 设置说明。
 */
RC_API
enum RcimEngineError rcim_engine_builder_set_navi_server(struct RcimEngineBuilder *builder,
                                                         const char *const *navi_url_vec,
                                                         int32_t navi_url_vec_len);

/**
 * 设置统计服务器地址
 *
 * 该方法要在调用 rcim_engine_builder_build 之前执行
 *
 * @since v0.5.0
 *
 * @param builder      引擎构造器指针，C 负责释放
 * @param url          统计服务器地址，C 负责释放
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_builder_set_statistic_server(struct RcimEngineBuilder *builder,
                                                              const char *url);

/**
 * 设置数据中心区域码，若不主动设置，则默认为 Bj
 *
 * 该方法要在调用 rcim_engine_builder_build 之前执行
 *
 * @since v0.5.0
 *
 * @param builder      引擎构造器指针，C 负责释放
 * @param area_code    数据中心区域码
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_builder_set_area_code(struct RcimEngineBuilder *builder,
                                                       enum RcimAreaCode area_code);

/**
 * 构造引擎对象，并销毁引擎构造器
 *
 * @since v0.5.0
 *
 * @param builder      引擎构造器指针，Rust 负责释放
 * @param engine       参数返回值，指向引擎实例指针的指针，C 负责释放
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_builder_build(struct RcimEngineBuilder *builder,
                                               struct RcimEngineSync **out_engine);

/**
 * 销毁引擎对象，会自动断开连接
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，Rust 负责释放
 * @return             调用结果码
 */
RC_API enum RcimEngineError rcim_destroy_engine(struct RcimEngineSync *engine);

/**
 * 设置数据库状态监听
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     数据库状态监听回调函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_database_status_listener(const struct RcimEngineSync *engine,
                                                              const void *context,
                                                              RcimDatabaseStatusLsr listener);

/**
 * 获取当前 SDK (RustLib) 的版本号
 *
 * @since v0.5.0       rcim_engine_get_version
 * @from v0.11.0       rename to rcim_engine_get_sdk_version
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param out_ver      参数返回值，SDK 版本号，C 负责释放
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_get_sdk_version(const struct RcimEngineSync *engine,
                                                 char **out_ver);

/**
 * 设置设备 ID
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param device_id    设备 ID，C 负责释放
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_device_id(const struct RcimEngineSync *engine,
                                               const char *device_id);

/**
 * 设置设备 pushToken
 *
 * 该方法要在调用 rcim_engine_builder_build 之后执行，且必须确保 device_id 有值
 * @remark 鸿蒙系统由于异步获取 device_id 需要在 rcim_engine_set_device_id 之后调用此接口，否则会导致 pushToken 无法上报
 *
 * @since v0.5.0
 *
 * @param engine                   引擎实例指针，非 NULL 必传，C 负责释放
 * @param token_info_vec           对象 RcimPushTokenInfo 数组指针，非 NULL 必传，C 负责释放
 * @param token_info_vec_len       RcimPushTokenInfo 类型数组长度
 * @return                         调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_push_token(const struct RcimEngineSync *engine,
                                                const struct RcimPushTokenInfo *token_info_vec,
                                                int32_t token_info_vec_len);

/**
 * 获取本地时间与服务器时间的时间差。
 * 通过当前本地时间 - 此接口返回的时间，即当前服务器时间。
 *
 * @since v0.13.0
 *
 * @param engine         引擎构造器指针，C 负责释放
 * @param out_delta_time 参数返回值，本地时间与服务器时间的时间差
 * @return               调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_get_delta_time(const struct RcimEngineSync *engine,
                                                int64_t *out_delta_time);

/**
 * 获取登录用户 ID
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param out_user_id      参数返回值，用户 ID，C 负责释放
 * @return                 调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_get_user_id(const struct RcimEngineSync *engine,
                                             char **out_user_id);

/**
 * 设置连接状态监听
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     连接状态监听回调函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_connection_status_listener(const struct RcimEngineSync *engine,
                                                                const void *context,
                                                                RcimConnectionStatusLsr listener);

/**
 * 获取当前连接状态
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param out_status       参数返回值，连接状态，C 负责释放
 * @return                 调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_get_connection_status(const struct RcimEngineSync *engine,
                                                       enum RcimConnectionStatus *out_status);

/**
 * 连接融云服务，成功后返回 token 对应的 user_id
 *
 * @since v0.5.0
 *
 * 整个流程以服务返回结果为标志，判定连接是否成功。数据库在连接之前先按缓存的 user_id 尝试打开，
 * 等连接成功后，还需根据真正登录的 user_id 再次判定打开是否正确，如果打开错了需要更正。如果打开
 * 失败则直接判断连接失败
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param token            通过 ServerAPI 或 开发者后台获取，代表用户的连接 token，C 负责释放
 * @param timeout_sec      设置连接超时时长：
 *     timeout_sec = 0     不设置超时时长，一直连接直到成功或失败
 *     timeout_sec > 0     在对应的时间内连接未成功则返回超时错误；连接成功后 SDK 会接管所有的重连逻辑
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         连接结果回调
 */
RC_API
void rcim_engine_connect(const struct RcimEngineSync *engine,
                         const char *token,
                         int32_t timeout_sec,
                         const void *context,
                         RcimConnectCb callback);

/**
 * 断开与融云服务的连接
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param mode         断开连接模式
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback     断开连接的回调函数指针
 */
RC_API
void rcim_engine_disconnect(const struct RcimEngineSync *engine,
                            enum RcimDisconnectMode mode,
                            const void *context,
                            RcimEngineErrorCb callback);

/**
 * 通知 App 状态发生变化，指导 Rust 层切换心跳模式等操作
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param state        App 切换后的状态，即当前状态
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_notify_app_state_changed(const struct RcimEngineSync *engine,
                                                          enum RcimAppState state);

/**
 * 通知 App 网络状态发生变化
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param network_type     网络变化后的类型，即当前网络类型
 * @return                 调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_notify_network_changed(const struct RcimEngineSync *engine,
                                                        enum RcimNetworkType network_type);

/**
 * 设置消息接收监听
 * 接收离线消息时，如果消息量过大，会出现回调中 has_package 为 true，但实际已没有消息的情况
 * 需通过 rcim_engine_set_offline_message_sync_completed_listener 接口设置的 RcimOfflineMessageSyncCompletedLsr 回调确定离线消息拉取完成
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     消息接收监听回调函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_message_received_listener(const struct RcimEngineSync *engine,
                                                               const void *context,
                                                               RcimMessageReceivedLsr listener);

/**
 * 离线消息接收完成 远端消息同步完成回调，每次连接成功触发一次 远端没有消息的时候，连接成功后会立即触发
 * 远端有大量历史消息的时候，连接成功会等待消息接收完成之后触发
 *
 * @since v0.10.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_offline_message_sync_completed_listener(const struct RcimEngineSync *engine,
                                                                             const void *context,
                                                                             RcimOfflineMessageSyncCompletedLsr listener);

/**
 * 设置获取消息入库搜索关键词监听
 * rust 通过此接口回调 C 获取消息入库搜索关键词
 *
 * @since v0.8.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     消息获取入库搜索关键词监听回调函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_message_searchable_words_callback_listener(const struct RcimEngineSync *engine,
                                                                                const void *context,
                                                                                RcimMessageSearchableWordsCbLsr listener);

/**
 * 设置小视频压缩回调监听，此借口必须设置且不能为空，否则发送小视频消息报错
 * rust 通过此接口回调 C 做小视频压缩，并回调压缩后的视频地址
 *
 * @since v0.10.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     小视频压缩监听回调函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_sight_compress_callback_listener(const struct RcimEngineSync *engine,
                                                                      const void *context,
                                                                      RcimSightCompressCbLsr listener);

/**
 * 设置撤回消息监听
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     撤回消息监听回调函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_message_recalled_listener(const struct RcimEngineSync *engine,
                                                               const void *context,
                                                               RcimRecallMessageLsr listener);

/**
 * 设置消息拦截监听
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     消息拦截监听回调函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_message_blocked_listener(const struct RcimEngineSync *engine,
                                                              const void *context,
                                                              RcimMessageBlockedLsr listener);

/**
 * 发送普通消息
 *
 * MessageBox 以下属性为不可为 NULL 字段：
 * - conv_type:         会话类型，不支持超级群和聊天室
 * - target_id:         会话目标 ID
 * - channel_id:        所属会话的业务标识，长度限制 20 字符
 * - content:           消息内容
 *
 * @since v0.5.0
 *
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param msg_box      消息体，非 NULL 必传，C 负责释放
 * @param option       附加配置，可为 NULL，C 负责释放
 * @param ret_cb       发送结果回调，可为 NULL
 * @param saved_cb     成功入库后回调，可为 NULL。如遇入库失败，通过 `RcimMessageCb` 触发失败回调。如果消息不需要入库，不会触发回调
 */
RC_API
void rcim_engine_send_message(const struct RcimEngineSync *engine,
                              const struct RcimMessageBox *msg_box,
                              const struct RcimSendMessageOption *option,
                              const void *context,
                              RcimCodeMessageCb ret_cb,
                              RcimMessageCb saved_cb);

/**
 * 发送某个会话中的消息阅读回执
 *
 * @since v0.11.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type            会话类型，仅支持 RcimConversationType::Private 和 RcimConversationType::Encrypted 类型
 * @param target_id            会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id           会话频道 ID，可为 NULL，C 负责释放
 * @param timestamp            会话中已读的最后一条消息的发送时间戳，必须大于 0
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             发送结果回调，可为 NULL
 */
RC_API
void rcim_engine_send_read_receipt_message(const struct RcimEngineSync *engine,
                                           enum RcimConversationType conv_type,
                                           const char *target_id,
                                           const char *channel_id,
                                           int64_t timestamp,
                                           const void *context,
                                           RcimCodeMessageCb callback);

/**
 * 发起群聊消息已读回执请求
 *
 * @since v0.11.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param message_uid          待发起已读回执请求消息 UID，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             发送结果回调，可为 NULL
 */
RC_API
void rcim_engine_send_read_receipt_request(const struct RcimEngineSync *engine,
                                           const char *message_uid,
                                           const void *context,
                                           RcimEngineErrorCb callback);

/**
 * 发起群聊消息已读回执响应
 *
 * @since v0.11.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type            会话类型
 * @param target_id            会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id           会话频道 ID，可为 NULL，C 负责释放
 * @param msg_info_vec         已读消息数据数组指针，C 负责释放
 * @param msg_info_vec_len     已读消息数据数组长度
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             发送结果回调，可为 NULL
 */
RC_API
void rcim_engine_send_read_receipt_response(const struct RcimEngineSync *engine,
                                            enum RcimConversationType conv_type,
                                            const char *target_id,
                                            const char *channel_id,
                                            const struct RcimSendReadReceiptResponseMessageData *msg_info_vec,
                                            int32_t msg_info_vec_len,
                                            const void *context,
                                            RcimGetMessageListCb callback);

/**
 * 单聊中收到消息回执的回调
 *
 * @since v0.11.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     消息接收监听回调函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_read_receipt_received_listener(const struct RcimEngineSync *engine,
                                                                    const void *context,
                                                                    RcimMessageNotifyLsr listener);

/**
 *  群组中某人发起了回执请求，会话中其余人会收到该请求，并回调此方法。
 *
 * @since v0.11.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     消息接收监听回调函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_read_receipt_request_listener(const struct RcimEngineSync *engine,
                                                                   const void *context,
                                                                   RcimReadReceiptRequestLsr listener);

/**
 * 群组中发起了回执请求的用户，当收到接收方的响应时，会回调此方法。
 *
 * @since v0.11.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     消息接收监听回调函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_read_receipt_response_listener(const struct RcimEngineSync *engine,
                                                                    const void *context,
                                                                    RcimReadReceiptResponseLsr listener);

/**
 * 发起群聊消息已读回执 V2 响应
 *
 * @since v0.16.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type            会话类型
 * @param target_id            会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id           会话频道 ID，可为 NULL，C 负责释放
 * @param msg_info_vec         已读消息 UID 数组指针，C 负责释放
 * @param msg_info_vec_len     已读消息 UID 数组长度
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             发送结果回调，可为 NULL
 */
RC_API
void rcim_engine_send_read_receipt_response_v2(const struct RcimEngineSync *engine,
                                               enum RcimConversationType conv_type,
                                               const char *target_id,
                                               const char *channel_id,
                                               const char *const *msg_info_vec,
                                               int32_t msg_info_vec_len,
                                               const void *context,
                                               RcimGetMessageListCb callback);

/**
 * 获取消息已读用户列表（V2）
 *
 * @since v0.16.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type            会话类型
 * @param target_id            会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id           会话频道 ID，可为 NULL，C 负责释放
 * @param msg_uid              查询消息 UID，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             发送结果回调，可为 NULL
 */
RC_API
void rcim_engine_get_read_receipt_v2_readers(const struct RcimEngineSync *engine,
                                             enum RcimConversationType conv_type,
                                             const char *target_id,
                                             const char *channel_id,
                                             const char *msg_uid,
                                             const void *context,
                                             RcimGetReadReceiptV2ReaderListCb callback);

/**
 * 群组中消息发送方，当收到的已读回执 V2 响应时，会回调此方法
 * 消息接收方调用 `rcim_engine_send_read_receipt_response_v2` 方法后，消息的发送方触发此监听回调
 *
 * @since v0.16.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     消息已读回执 V2 接收监听回调函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_read_receipt_response_v2_listener(const struct RcimEngineSync *engine,
                                                                       const void *context,
                                                                       RcimReadReceiptResponseV2Lsr listener);

/**
 * 取消发送中的多媒体消息
 * 正在发送中的请求会回调 RcimEngineError::RequestCanceled
 *
 * @since 0.16.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param message_id       消息 ID
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调函数指针
 */
RC_API
void rcim_engine_cancel_send_media_message(const struct RcimEngineSync *engine,
                                           int64_t message_id,
                                           const void *context,
                                           RcimEngineErrorCb callback);

/**
 * 发送多媒体消息
 *
 * MessageBox 以下属性为不可为 NULL 字段：
 * - conv_type:         会话类型，不支持超级群和聊天室
 * - target_id:         会话目标 ID
 * - channel_id:        所属会话的业务标识，长度限制 20 字符
 * - content:           消息内容
 *
 * @since v0.5.0
 *
 * 非多媒体消息请调用 rcim_engine_send_message 接口
 *
 * @param engine            引擎实例指针，非 NULL 必传，C 负责释放
 * @param msg_box           消息体，非 NULL 必传，C 负责释放
 * @param option            附加配置，可为 NULL，C 负责释放
 * @param ret_cb            发送结果回调，可为 NULL
 * @param saved_cb          成功入库后回调，可为 NULL。如遇入库失败，通过 RcimMessageCb 触发失败回调。如果消息不需要入库，不会触发回调
 * @param progress_cb       多媒体文件进度回调，可为 NULL。回调 progress 为 [0, 100] 的整数。
 * @param upload_handler_cb 自定义上传文件回调，可为 NULL。如果消息需要自定义上传，则必须设置此字段。如果调用了 `rcim_engine_cancel_send_media_message` 接口取消本消息发送，则不可再使用此字段回调进度与结果，否则会出现野指针异常。
 */
RC_API
void rcim_engine_send_media_message(const struct RcimEngineSync *engine,
                                    const struct RcimMessageBox *msg_box,
                                    const struct RcimSendMessageOption *option,
                                    const void *context,
                                    RcimCodeMessageCb ret_cb,
                                    RcimMessageCb saved_cb,
                                    RcimSendMessageOnProgressCb progress_cb,
                                    RcimMediaMessageHandlerCb upload_handler_cb);

/**
 * 多媒体消息下载文件，并把文件下载的文件地址保存到数据库，并通过回调返回下载进度
 * 如果中途调用 rcim_engine_cancel_download_media_message 取消下载，则回调 RcimEngineError::RequestCanceled
 *
 * @since 0.11.0
 *
 * @param engine              引擎实例指针，非 NULL 必传，C 负责释放
 * @param message_id          消息 ID
 * @param context             上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback            结果回调函数指针
 * @param progress_cb         进度回调函数指针
 * @param download_handler_cb 自定义下载文件回调，可为 NULL。如果消息需要自定义下载，则必须设置此字段。如果调用了 `rcim_engine_cancel_download_media_message` 接口取消下载本消息，则不可再使用此字段回调进度与结果，否则会出现野指针异常。
 */
RC_API
void rcim_engine_download_media_message(const struct RcimEngineSync *engine,
                                        int64_t message_id,
                                        const void *context,
                                        RcimDownloadMediaCb callback,
                                        RcimDownloadMessageProgressCb progress_cb,
                                        RcimMediaMessageHandlerCb download_handler_cb);

/**
 * 取消下载中的多媒体消息
 * 正在下载中的请求会回调 RcimEngineError::RequestCanceled
 * 取消下载会删除本地已下载的部分，再次下载会重新下载
 *
 * @since 0.11.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param message_id       消息 ID
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调函数指针
 */
RC_API
void rcim_engine_cancel_download_media_message(const struct RcimEngineSync *engine,
                                               int64_t message_id,
                                               const void *context,
                                               RcimEngineErrorCb callback);

/**
 * 暂停下载中的多媒体消息
 * 正在下载中的请求会回调 RcimEngineError::RequestPaused
 * 如果下载的文件服务器支持断点下载，暂停后再次下载相同的消息可以继续下载
 *
 * @since 0.15.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param message_id       消息 ID
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调函数指针
 */
RC_API
void rcim_engine_pause_download_media_message(const struct RcimEngineSync *engine,
                                              int64_t message_id,
                                              const void *context,
                                              RcimEngineErrorCb callback);

/**
 * 已废弃，使用 download_file_with_unique_id 代替
 * 多媒体消息下载文件，并通过回调返回下载进度。
 * 如果中途调用 rcim_engine_cancel_download_file 取消下载，则回调 RcimEngineError::RequestCanceled。
 * 如果中途调用 rcim_engine_pause_download_file 取消下载，则回调 RcimEngineError::RequestPaused。
 * 会将 file_name 中的特殊替换为下划线。如 abc@123.png 会被替换为 abc_123.png。(Android 端公有云逻辑)
 * 如果多次请求 file_name 相同，后一次下载会加入序号，如 abc.png，abc(1).png，abc(2).png。
 *
 * @since 0.12.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param remote_url       远端地址，非 NULL 必传，C 负责释放
 * @param file_name        本地保存的文件名，非 NULL 必传，C 负责释放
 * @param out_unique_id    参数返回值，下载唯一标识，非 NULL 必传，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调函数指针
 * @param progress_cb      进度回调函数指针
 */
RC_API
void rcim_engine_download_file_with_progress(const struct RcimEngineSync *engine,
                                             const char *remote_url,
                                             const char *file_name,
                                             char **out_unique_id,
                                             const void *context,
                                             RcimDownloadMediaCb callback,
                                             RcimDownloadFileProgressCb progress_cb);

/**
 * 多媒体消息下载文件，并通过回调返回下载进度。
 * 如果中途调用 rcim_engine_cancel_download_file 取消下载，则回调 RcimEngineError::RequestCanceled。
 * 如果中途调用 rcim_engine_pause_download_file 取消下载，则回调 RcimEngineError::RequestPaused。
 * 会将 file_name 中的特殊替换为下划线。如 abc@123.png 会被替换为 abc_123.png。(Android 端公有云逻辑)
 * 如果多次请求 file_name 相同，后一次下载会加入序号，如 abc.png，abc(1).png，abc(2).png。
 *
 * @since 0.15.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param unique_id        下载唯一标识，非 NULL 必传，C 负责释放
 * @param remote_url       远端地址，非 NULL 必传，C 负责释放
 * @param file_name        本地保存的文件名，非 NULL 必传，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调函数指针
 * @param progress_cb      进度回调函数指针
 */
RC_API
void rcim_engine_download_file_with_unique_id(const struct RcimEngineSync *engine,
                                              const char *unique_id,
                                              const char *remote_url,
                                              const char *file_name,
                                              const void *context,
                                              RcimDownloadMediaCb callback,
                                              RcimDownloadFileProgressCb progress_cb);

/**
 * 取消下载中的多媒体文件
 * 正在下载中的请求会回调 RcimEngineError::RequestCanceled
 * 取消下载会删除本地已下载的部分，再次下载会重新下载
 *
 * @since 0.12.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param unique_id        下载唯一标识，非 NULL 必传，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调函数指针
 */
RC_API
void rcim_engine_cancel_download_file(const struct RcimEngineSync *engine,
                                      const char *unique_id,
                                      const void *context,
                                      RcimEngineErrorCb callback);

/**
 * 暂停下载中的多媒体文件
 * 正在下载中的请求会回调 RcimEngineError::RequestPaused
 * 如果下载的文件服务器支持断点下载，暂停后再次使用相同的 unique_id 可以继续下载
 *
 * @since 0.15.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param unique_id        下载唯一标识，非 NULL 必传，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调函数指针
 */
RC_API
void rcim_engine_pause_download_file(const struct RcimEngineSync *engine,
                                     const char *unique_id,
                                     const void *context,
                                     RcimEngineErrorCb callback);

/**
 * 撤回消息
 *
 * MessageBox 以下属性会被使用：
 * - conv_type:            会话类型，不支持超级群和聊天室
 * - target_id:            会话目标 ID
 * - channel_id:           所属会话的业务标识，长度限制 20 字符
 * - message_id:           消息 ID
 * - uid:                  服务端生产的消息唯一 ID，如要携带该字段需要保证入库后是唯一的
 * - sentTime:             发送时间，不能小于等于 0，取值范围 [1, INT64_MAX]
 * - content:              消息内容
 * - object_name:          消息的类型名
 * - push_config:          消息推送配置，如果需要配送推送，需要设置该字段
 *
 * 以上字段中 conv_type、target_id、channel_id、uid 做了强制校验，其他字段需由调用者进行校验
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param msg_box_c        待撤回的消息对象指针，非 NULL 必传，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         撤回消息结果回调，可为 NULL
 */
RC_API
void rcim_engine_recall_message(const struct RcimEngineSync *engine,
                                const struct RcimMessageBox *msg_box_c,
                                const void *context,
                                RcimRecallMessageCb callback);

/**
 * 注册自定义消息类型
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param msg_type_vec         消息类型数组指针，C 负责释放
 * @param msg_type_vec_len     消息类型数组长度
 * @return                     调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_register_message_types(const struct RcimEngineSync *engine,
                                                        const struct RcimMessageType *msg_type_vec,
                                                        int32_t msg_type_vec_len);

/**
 * 通过 uid 获取本地消息
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param uid              消息 uid，非 NULL 必传，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         获取消息的回调函数指针
 */
RC_API
void rcim_engine_get_local_message_by_uid(const struct RcimEngineSync *engine,
                                          const char *uid,
                                          const void *context,
                                          RcimCodeMessageCb callback);

/**
 * 从本地数据库中，根据指定消息 ID 获取消息
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param msg_id           待查询消息的消息 ID，非 NULL 必传，C 负责释放
 *                         在 IMKit 中通过创建 RCMessage 赋值 -1，来做一些本地逻辑，意为临时插入 UI 的消息;
 *                         在 IMLib 中通过 -1 调用获取历史消息接口，效果等同于 0，为兼容原有 IMLib 逻辑，不能改为 u64
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         获取消息的回调函数指针
 */
RC_API
void rcim_engine_get_local_message_by_id(const struct RcimEngineSync *engine,
                                         int64_t msg_id,
                                         const void *context,
                                         RcimCodeMessageCb callback);

/**
 * 从本地数据库指定会话中，批量获取指定发送时间前后的一批类型消息
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type            待查询消息的会话类型
 * @param target_id            待查询消息的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id           待查询消息的频道 ID，可为 NULL，C 负责释放
 * @param obj_name_vec         待查询消息的消息类型指针列表，如果为 NULL 则表示获取全部类型消息，C 负责释放
 * @param obj_name_vec_len     待查询消息的消息类型指针列表长度
 * @param send_time            待查询消息的发送时间，若为 0 则代表最近一条消息的发送时间，取值范围 [0, INT64_MAX]
 * @param before_count         获取此时间之前的消息数量，建议取 200 以内以免过大占用内存，取值范围 [0, INT32_MAX]
 * @param after_count          获取此时间之后的消息数量，建议取 200 以内以免过大占用内存，取值范围 [0, INT32_MAX]
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             获取消息的回调函数指针
 */
RC_API
void rcim_engine_get_local_history_messages_by_time(const struct RcimEngineSync *engine,
                                                    enum RcimConversationType conv_type,
                                                    const char *target_id,
                                                    const char *channel_id,
                                                    const char *const *obj_name_vec,
                                                    int32_t obj_name_vec_len,
                                                    int64_t send_time,
                                                    int32_t before_count,
                                                    int32_t after_count,
                                                    const void *context,
                                                    RcimGetMessageListCb callback);

/**
 * 从本地数据库指定会话中，获取指定会话多个成员指定类型消息
 *
 * @since v0.11.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type            待查询消息的会话类型
 * @param target_id            待查询消息的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id           待查询消息的频道 ID，可为 NULL，C 负责释放
 * @param sender_id_ver        待查询消息发送者指针列表，不可为空，C 负责释放
 * @param sender_id_ver_len    待查询消息发送者指针列表长度
 * @param obj_name_vec         待查询消息的消息类型指针列表，如果为 NULL 则表示获取全部类型消息，C 负责释放
 * @param obj_name_vec_len     待查询消息的消息类型指针列表长度
 * @param count                返回的搜索结果数量，传 0 默认取值为 100，取值范围 [0, 100]
 * @param start_time           查询时间，单位：毫秒，0 表示不限制时间
 * @param order                待查询消息的返回排序。
 *                               Ascending：升序，拉取比 send_time 时间戳大的消息；
 *                               Descending：降序，拉取比 send_time 时间戳小的消息
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             获取本地消息的回调函数指针
 */
RC_API
void rcim_engine_get_local_history_messages_by_senders(const struct RcimEngineSync *engine,
                                                       enum RcimConversationType conv_type,
                                                       const char *target_id,
                                                       const char *channel_id,
                                                       const char *const *sender_id_ver,
                                                       int32_t sender_id_ver_len,
                                                       const char *const *obj_name_vec,
                                                       int32_t obj_name_vec_len,
                                                       int32_t count,
                                                       int64_t start_time,
                                                       enum RcimOrder order,
                                                       const void *context,
                                                       RcimGetMessageListCb callback);

/**
 * 从本地数据库指定会话中，批量获取指定消息 ID 前后的一批类型消息
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type            待查询消息的会话类型
 * @param target_id            待查询消息的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id           待查询消息的频道 ID，可为 NULL，C 负责释放
 * @param obj_name_vec         消息类型指针列表，如果为 NULL 则表示获取全部类型消息，C 负责释放
 * @param obj_name_vec_len     消息类型指针列表长度
 * @param msg_id               待查询的消息 ID
 * @param before_count         获取此时间之前的消息数量，建议取 200 以内以免过大占用内存，不能和 after_count 同时为 0，取值范围 [0, INT32_MAX]
 * @param after_count          获取此时间之后的消息数量，建议取 200 以内以免过大占用内存，不能和 before_count 同时为 0，取值范围 [0, INT32_MAX]
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             获取消息的回调函数指针
 */
RC_API
void rcim_engine_get_local_history_messages_by_id(const struct RcimEngineSync *engine,
                                                  enum RcimConversationType conv_type,
                                                  const char *target_id,
                                                  const char *channel_id,
                                                  const char *const *obj_name_vec,
                                                  int32_t obj_name_vec_len,
                                                  int64_t msg_id,
                                                  int32_t before_count,
                                                  int32_t after_count,
                                                  const void *context,
                                                  RcimGetMessageListCb callback);

/**
 * 从远端服务器指定会话中，批量获取指定发送时间一侧方向的消息，同时可选择是否排除本地已入库的消息
 *
 * @since v0.5.0
 *
 * @param engine                   引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type                待查询消息的会话类型，支持单聊、群聊、聊天室
 * @param target_id                待查询消息的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id               待查询消息的频道 ID，可为 NULL，C 负责释放
 * @param send_time                待查询消息的发送时间，若为 0 则代表最近一条消息的发送时间，取值范围 [0, INT64_MAX]
 * @param count                    待查询消息的个数，取值范围 [1, 100]，不能为负数或者 0
 * @param order                    待查询消息的返回排序。
 *                                     Ascending：升序，拉取比 send_time 时间戳大的消息；
 *                                     Descending：降序，拉取比 send_time 时间戳小的消息
 * @param is_include_local         待查询消息是否包含本地已入库的消息，true：包含本地数据库存在的消息，false：仅返回数据库中不存在的消息
 * @param context                  上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback                 获取消息的回调函数指针
 */
RC_API
void rcim_engine_get_remote_history_messages(const struct RcimEngineSync *engine,
                                             enum RcimConversationType conv_type,
                                             const char *target_id,
                                             const char *channel_id,
                                             int64_t send_time,
                                             int32_t count,
                                             enum RcimOrder order,
                                             bool is_include_local,
                                             const void *context,
                                             RcimGetMessageListCb callback);

/**
 * 根据消息发送时间，清除本地历史消息
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type        待清除消息的会话类型
 * @param target_id        待清除消息的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       待清除消息的频道 ID，可为 NULL，C 负责释放
 * @param le_send_time     待清除消息的锚点发送时间，清除小于等于这个时间的所有历史消息，若为 0 则代表清除所有消息，取值范围 [0, INT64_MAX]
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调，可为 NULL
 */
RC_API
void rcim_engine_clean_local_history_messages(const struct RcimEngineSync *engine,
                                              enum RcimConversationType conv_type,
                                              const char *target_id,
                                              const char *channel_id,
                                              int64_t le_send_time,
                                              const void *context,
                                              RcimEngineErrorCb callback);

/**
 * 从远端服务器指定会话中，清除指定发送时间之前（含）的消息
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param conv_type        待清除消息的会话类型
 * @param target_id        待清除消息的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       待清除消息的频道 ID，可为 NULL，C 负责释放
 * @param le_send_time     待清除消息的锚点发送时间，清除小于等于这个时间的所有历史消息，若为 0 则代表清除所有消息，取值范围 [0, INT64_MAX]
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         清除远端历史消息的回调函数指针
 */
RC_API
void rcim_engine_clean_remote_history_messages(const struct RcimEngineSync *engine,
                                               enum RcimConversationType conv_type,
                                               const char *target_id,
                                               const char *channel_id,
                                               int64_t le_send_time,
                                               const void *context,
                                               RcimEngineErrorCb callback);

/**
 * 向本地数据库中，批量插入接收消息（该消息只插入本地数据库，实际不会发送给服务器和对方）
 *
 * RcimMessageBox 下列属性会被入库，其他属性会被抛弃：
 * - conv_type:         会话类型，不支持超级群和聊天室
 * - target_id:         会话目标 ID
 * - channel_id:        所属会话的业务标识，长度限制 20 字符
 * - uid:               服务端生产的消息唯一 ID，如要携带该字段需要保证入库后是唯一的
 * - direction:         消息方向
 * - sender_id:         发送者 ID
 * - received_status:   接收状态
 * - sent_status:       发送状态
 * - content:           消息内容
 * - sentTime:          发送时间，不能小于等于 0，取值范围 [1, INT64_MAX]
 * - extra:             扩展信息
 * - object_name:       消息类型
 *
 * 以上字段中 conv_type、target_id、channel_id 做了强制校验，其他字段需由调用者进行校验
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param msg_box_vec          待插入的消息数组指针，非 NULL 必传，C 负责释放
 * @param msg_box_vec_len      待插入的消息数组长度，取值范围 [1, 500]
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             插入消息结果回调，可为 NULL
 */
RC_API
void rcim_engine_insert_local_messages(const struct RcimEngineSync *engine,
                                       const struct RcimMessageBox *msg_box_vec,
                                       int32_t msg_box_vec_len,
                                       const void *context,
                                       RcimEngineErrorCb callback);

/**
 * 向本地数据库中，插入单条消息（该消息只插入本地数据库，实际不会发送给服务器和对方）
 *
 * RcimMessageBox 下列属性会被入库，其他属性会被抛弃：
 * - conv_type:         会话类型
 * - target_id:         会话目标 ID
 * - channel_id:        所属会话的业务标识，长度限制 20 字
 * - uid:               服务端生产的消息唯一 ID，如要携带该
 * - direction:         消息方向
 * - sender_id:         发送者 ID
 * - received_status:   接收状态
 * - sent_status:       发送状态
 * - content:           消息内容
 * - sentTime:          发送时间，不能小于等于 0，取值范围 [1, INT64_MAX]
 * - extra:             扩展信息
 * - object_name:       消息类型
 *
 * 以上字段中 conv_type、target_id、channel_id 做了强制校验，其他字段需由调用者进行校验
 *
 * @since 0.10.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param msg_box              待插入的消息指针，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             插入消息结果回调，可为 NULL
 */
RC_API
void rcim_engine_insert_local_message(const struct RcimEngineSync *engine,
                                      const struct RcimMessageBox *msg_box,
                                      const void *context,
                                      RcimCodeMessageCb callback);

/**
 * 删除当前会话所有的本地消息
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type        待删除消息的会话类型，不支持聊天室
 * @param target_id        待删除消息的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       待删除消息的频道 ID，可为 NULL，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调，可为 NULL
 */
RC_API
void rcim_engine_delete_local_messages(const struct RcimEngineSync *engine,
                                       enum RcimConversationType conv_type,
                                       const char *target_id,
                                       const char *channel_id,
                                       const void *context,
                                       RcimEngineErrorCb callback);

/**
 * 根据消息 ID 数组，批量删除本地消息
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param msg_id_vec       待删除的消息 ID 数组指针，非 NULL 必传，C 负责释放
 * @param msg_id_vec_len   待删除的消息 ID 数组长度，取值范围 [1, 1000]
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调，可为 NULL
 */
RC_API
void rcim_engine_delete_local_messages_by_ids(const struct RcimEngineSync *engine,
                                              const int64_t *msg_id_vec,
                                              int32_t msg_id_vec_len,
                                              const void *context,
                                              RcimEngineErrorCb callback);

/**
 * 批量删除某个会话中的指定远端消息（同时删除对应的本地消息），不支持聊天室。
 *
 * @description  一次批量操作仅支持删除属于同一个会话的消息，请确保消息列表中的所有消息来自同一会话。
 *
 * RcimMessageBox 以下属性会被使用：
 * - conv_type:         会话类型，不支持超级群和聊天室
 * - target_id:         会话目标 ID
 * - channel_id:        所属会话的业务标识，长度限制 20 字符
 * - uid:               服务端生产的消息唯一 ID，如要携带该字段需要保证入库后是唯一的
 * - sentTime:          发送时间，不能小于等于 0，取值范围 [1, INT64_MAX]
 * - direction:         消息方向
 *
 * 以上字段中 conv_type、target_id、channel_id 做了强制校验，其他字段需由调用者进行校验
 *
 * @since v0.6.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type            会话类型
 * @param target_id            会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id           频道 ID，可为 NULL，C 负责释放
 * @param msg_box_vec          待删除的消息数组指针，非 NULL 必传，C 负责释放
 * @param msg_box_vec_len      待删除的消息数组长度，取值范围 [1, 100]
 * @param is_delete_local      是否删除本地消息，如果为 true 则同时删除远端和本地消息，否则仅删除远端消息
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             删除消息结果回调，可为 NULL
 */
RC_API
void rcim_engine_delete_remote_messages(const struct RcimEngineSync *engine,
                                        enum RcimConversationType conv_type,
                                        const char *target_id,
                                        const char *channel_id,
                                        const struct RcimMessageBox *msg_box_vec,
                                        int32_t msg_box_vec_len,
                                        bool is_delete_local,
                                        const void *context,
                                        RcimEngineErrorCb callback);

/**
 * 根据关键字搜索指定会话中的本地消息。
 *
 * @since v0.7.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type        会话类型
 * @param target_id        会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       频道 ID，可为 NULL，C 负责释放
 * @param keyword          搜索关键字，非 NULL 必传，C 负责释放，长度范围 [1, 256]
 * @param count            返回的搜索结果数量，传 0 时会返回所有搜索到的消息，非 0 时根据 start_time 逐页返回，取值范围 [0, 100]
 * @param start_time       查询的起始发送时间，返回小于该时间的消息；如果为 0，则查询全部。当分页时，可以传入上一次查询的最后一条消息的发送时间，取值范围 [0, INT64_MAX]
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         获取本地消息的回调函数指针
 */
RC_API
void rcim_engine_search_local_messages(const struct RcimEngineSync *engine,
                                       enum RcimConversationType conv_type,
                                       const char *target_id,
                                       const char *channel_id,
                                       const char *keyword,
                                       int32_t count,
                                       int64_t start_time,
                                       const void *context,
                                       RcimGetMessageListCb callback);

/**
 * 根据关键字搜索指定消息类型的本地消息。
 *
 * @since v0.8.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type            会话类型
 * @param target_id            会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id           频道 ID，可为 NULL，C 负责释放
 * @param keyword              搜索关键字，非 NULL 必传，C 负责释放，长度范围 [1, 256]
 * @param obj_name_vec         消息类型指针列表，如果为 NULL 则表示获取全部类型消息，C 负责释放
 * @param obj_name_vec_len     消息类型指针列表长度，取值范围 [0, 300]
 * @param count                返回的搜索结果数量，传 0 时会返回所有搜索到的消息，非 0 时根据 start_time 逐页返回，取值范围 [0, 100]
 * @param start_time           查询的起始发送时间，返回小于该时间的消息；如果为 0，则查询全部。当分页时，可以传入上一次查询的最后一条消息的发送时间，取值范围 [0, INT64_MAX]
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             获取本地消息的回调函数指针
 */
RC_API
void rcim_engine_search_local_messages_by_object_name(const struct RcimEngineSync *engine,
                                                      enum RcimConversationType conv_type,
                                                      const char *target_id,
                                                      const char *channel_id,
                                                      const char *keyword,
                                                      const char *const *obj_name_vec,
                                                      int32_t obj_name_vec_len,
                                                      int32_t count,
                                                      int64_t start_time,
                                                      const void *context,
                                                      RcimGetMessageListCb callback);

/**
 * 根据关键字和指定时间段搜索指定会话中的消息。
 *
 * @since v0.8.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type        会话类型
 * @param target_id        会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       频道 ID，可为 NULL，C 负责释放
 * @param keyword          搜索关键字，非 NULL 必传，C 负责释放，长度范围 [1, 256]
 * @param count            返回的搜索结果数量，取值范围 [0, 100]
 * @param start_time       开始时间，查询包含该时间的消息，该时间需要 <= end_time，建议使用消息的发送时间
 * @param end_time         结束时间，查询包含该时间的消息，建议使用消息的发送时间
 * @param offset           偏移量，要跳过查询的数量，取值范围  [0, INT32_MAX]
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         获取本地消息的回调函数指针
 */
RC_API
void rcim_engine_search_local_messages_by_time(const struct RcimEngineSync *engine,
                                               enum RcimConversationType conv_type,
                                               const char *target_id,
                                               const char *channel_id,
                                               const char *keyword,
                                               int32_t count,
                                               int64_t start_time,
                                               int64_t end_time,
                                               int64_t offset,
                                               const void *context,
                                               RcimGetMessageListCb callback);

/**
 * 根据用户 ID 搜索指定会话中的本地消息。
 *
 * @since v0.8.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type        会话类型
 * @param target_id        会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       频道 ID，可为 NULL，C 负责释放
 * @param user_id          用户 ID，非 NULL 必传，C 负责释放
 * @param count            返回的搜索结果数量，传 0 时会返回所有搜索到的消息，非 0 时根据 start_time 逐页返回，取值范围 [0, 100]
 * @param start_time       查询的起始发送时间，返回小于该时间的消息；如果为 0，则查询全部。当分页时，可以传入上一次查询的最后一条消息的发送时间，取值范围 [0, INT64_MAX]
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         获取本地消息的回调函数指针
 */
RC_API
void rcim_engine_search_local_messages_by_user_id(const struct RcimEngineSync *engine,
                                                  enum RcimConversationType conv_type,
                                                  const char *target_id,
                                                  const char *channel_id,
                                                  const char *user_id,
                                                  int32_t count,
                                                  int64_t start_time,
                                                  const void *context,
                                                  RcimGetMessageListCb callback);

/**
 * 分页搜索多个会话指定消息类型历史消息。
 * 注意：conv_type_vec、target_id_vec、channel_id_vec 都为有效数据的话，查询结果会满足所有条件。
 *
 * @since v0.11.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec        待查询消息的会话类型指针列表，且至少包含一个有效类型，C 负责释放
 * @param conv_type_vec_len    待查询消息的会话类型指针列表长度
 * @param target_id_vec        待查询消息的会话 ID 指针列表，空代表不限制，C 负责释放
 * @param target_id_vec_len    待查询消息的会话 ID 指针列表长度
 * @param channel_id_vec       待查询消息的 ChannelID 指针列表，空代表不限制，C 负责释放
 * @param channel_id_vec_len   待查询消息的 ChannelID 指针列表长度
 * @param obj_name_vec         待查询消息的消息类型指针列表，空代表获取全部类型消息，C 负责释放
 * @param obj_name_vec_len     待查询消息的消息类型指针列表长度
 * @param keyword              搜索关键字，空代表不限制，C 负责释放，长度范围 [0, 256]
 * @param count                返回的搜索结果数量，传 0 默认取值为 100，取值范围 [0, 1000]
 * @param start_time           查询时间，单位：毫秒，0 表示不限制时间
 * @param order                待查询消息的返回排序。
 *                               Ascending：升序，拉取比 send_time 时间戳大的消息；
 *                               Descending：降序，拉取比 send_time 时间戳小的消息
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             获取本地消息的回调函数指针
 */
RC_API
void rcim_engine_search_local_messages_by_multiple_conversations(const struct RcimEngineSync *engine,
                                                                 const enum RcimConversationType *conv_type_vec,
                                                                 int32_t conv_type_vec_len,
                                                                 const char *const *target_id_vec,
                                                                 int32_t target_id_vec_len,
                                                                 const char *const *channel_id_vec,
                                                                 int32_t channel_id_vec_len,
                                                                 const char *const *obj_name_vec,
                                                                 int32_t obj_name_vec_len,
                                                                 const char *keyword,
                                                                 int32_t count,
                                                                 int64_t start_time,
                                                                 enum RcimOrder order,
                                                                 const void *context,
                                                                 RcimGetMessageListCb callback);

/**
 * 设置消息扩展更新监听
 *
 * @since 0.9.0
 *
 * @param engine          引擎实例指针，非 NULL 必传，C 负责释放
 * @param context         上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener        消息扩展更新监听
 * @return                调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_message_expansion_update_listener(const struct RcimEngineSync *engine,
                                                                       const void *context,
                                                                       RcimMessageExpansionKvUpdateLsr listener);

/**
 * 设置消息扩展移除监听
 *
 * @since 0.9.0
 *
 * @param engine          引擎实例指针，非 NULL 必传，C 负责释放
 * @param context         上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener        消息扩展移除监听
 * @return                调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_message_expansion_remove_listener(const struct RcimEngineSync *engine,
                                                                       const void *context,
                                                                       RcimMessageExpansionKvRemoveLsr listener);

/**
 * 更新消息扩展属性
 *
 * @since 0.9.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param kv_vec               待设置的消息扩展数组，非 NULL 必传，C 负责释放
 * @param kv_vec_len           待设置的消息扩展数组长度，有效范围 [1, 20] ,每条消息携带扩展信息键值对最大值 300 个
 * @param msg_uid              消息 uid，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             结果回调
 */
RC_API
void rcim_engine_update_message_expansion(const struct RcimEngineSync *engine,
                                          const struct RcimMessageExpansionKvInfo *kv_vec,
                                          int32_t kv_vec_len,
                                          const char *msg_uid,
                                          const void *context,
                                          RcimEngineErrorCb callback);

/**
 * 移除消息扩展属性
 *
 * @since 0.9.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param key_vec              待删除的消息扩展 key 数组，非 NULL 必传，C 负责释放
 * @param kv_vec_len           待删除的消息扩展 key 数组长度，有效范围 [1, 20]
 * @param msg_uid              消息 uid，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             结果回调
 */
RC_API
void rcim_engine_remove_message_expansion(const struct RcimEngineSync *engine,
                                          const char *const *key_vec,
                                          int32_t key_vec_len,
                                          const char *msg_uid,
                                          const void *context,
                                          RcimEngineErrorCb callback);

/**
 * 修改本地数据库的消息发送状态（内部方法，禁止私自调用）
 *
 * @since 0.10.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param message_id           消息 ID，必须 > 0
 * @param sent_status          消息发送状态
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             结果回调
 *
 * @warning 消息的发送状态会影响消息 UI 展示，原则上只能由 SDK 内部维护，不建议外部进行修改
 */
RC_API
void rcim_engine_set_message_sent_status(const struct RcimEngineSync *engine,
                                         int64_t message_id,
                                         enum RcimSentStatus sent_status,
                                         const void *context,
                                         RcimEngineErrorCb callback);

/**
 * 修改消息接收状态
 *
 * @since 0.12.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param message_id           消息 ID，必须 > 0
 * @param received_status      消息接收状态指针，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             结果回调
 */
RC_API
void rcim_engine_set_message_received_status(const struct RcimEngineSync *engine,
                                             int64_t message_id,
                                             const struct RcimReceivedStatus *received_status,
                                             const void *context,
                                             RcimEngineErrorCb callback);

/**
 * 修改本地数据库的消息内容（内部方法，禁止私自调用）
 *
 * @since 0.10.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param message_id           消息 ID，必须 > 0
 * @param content              消息内容
 * @param object_name          消息类型名
 * @param searchable_words     可被搜索的内容，只做为入参，不做出参，返回的消息该字段为空
 * @param context              上下文指针，用于回调时传递上下文信息，
 * @param callback             结果回调
 *
 * @warning 消息内容会影响 UI 展示和问题排查，原则上只能由 SDK 内部维护，不建议外部进行修改
 */
RC_API
void rcim_engine_set_message_content(const struct RcimEngineSync *engine,
                                     int64_t message_id,
                                     const char *content,
                                     const char *object_name,
                                     const char *searchable_words,
                                     const void *context,
                                     RcimEngineErrorCb callback);

/**
 * 设置消息的附加内容
 *
 * @since todo @baijingliang
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param message_id           消息 ID，必须 > 0
 * @param extra                消息的附加内容，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，
 * @param callback             结果回调
 */
RC_API
void rcim_engine_set_message_extra(const struct RcimEngineSync *engine,
                                   int64_t message_id,
                                   const char *extra,
                                   const void *context,
                                   RcimEngineErrorCb callback);

/**
 * 用户配置相关 ------------------------------------------------------------------------------------
 * 设置显示推送详情
 *
 * @since 0.11.0
 *
 * ```text
 * 通知栏显示的消息推送默认显示的是消息内容，如果消息包含敏感信息，不希望在推送通知栏上显示消息内容，可以调用此方法设置 showStatus 为 false
 * 注意：此功能需要从服务端开启用户设置功能。
 * ```
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param show_status          是否显示远程推送内容，true 显示，false 不显示
 * @param context              上下文指针，用于回调时传递上下文信息，
 * @param callback             结果回调
 */
RC_API
void rcim_engine_set_push_content_show_status(const struct RcimEngineSync *engine,
                                              bool show_status,
                                              const void *context,
                                              RcimEngineErrorCb callback);

/**
 * 获取是否显示远程推送内容详情设置
 *
 * @since 0.11.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，
 * @param callback             结果回调，获取是否显示远程推送内容详情，true 显示，false 不显示
 */
RC_API
void rcim_engine_get_push_content_show_status(const struct RcimEngineSync *engine,
                                              const void *context,
                                              RcimGetBoolCb callback);

/**
 * 设置 Web 端在线时，手机端是否接收推送
 *
 * @since 0.11.0
 *
 * ```text
 * 注意：此功能需要从服务端开启用户设置功能。
 * ```
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param receive_status       是否接收推送，true 接收，false 不接收
 * @param context              上下文指针，用于回调时传递上下文信息，
 * @param callback             结果回调
 */
RC_API
void rcim_engine_set_push_receive_status(const struct RcimEngineSync *engine,
                                         bool receive_status,
                                         const void *context,
                                         RcimEngineErrorCb callback);

/**
 * 获取是否接收远程推送的设置
 *
 * @since 0.11.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，
 * @param callback             结果回调，是否接收远程推送，true 接收，false 不接收
 */
RC_API
void rcim_engine_get_push_receive_status(const struct RcimEngineSync *engine,
                                         const void *context,
                                         RcimGetBoolCb callback);

/**
 * 设置消息阅后即焚开始监听
 *
 * @since 0.11.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     消息阅后即焚开始监听回调函数指针
 * @warning 国内不允许带阅后即焚功能的 App 上架
 */
RC_API
enum RcimEngineError rcim_engine_set_message_destructing_listener(const struct RcimEngineSync *engine,
                                                                  const void *context,
                                                                  RcimMessageDestructingLsr listener);

/**
 * 设置消息阅后即焚停止监听
 *
 * @since 0.11.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     消息阅后即焚停止监听回调函数指针
 * @warning 国内不允许带阅后即焚功能的 App 上架
 */
RC_API
enum RcimEngineError rcim_engine_set_message_destruction_stop_listener(const struct RcimEngineSync *engine,
                                                                       const void *context,
                                                                       RcimMessageDestructionStopLsr listener);

/**
 * 消息阅后即焚开始倒计时，仅支持单聊，仅限阅后即焚消息的接收方调用
 *
 * @since 0.11.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param msg_box      消息体，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback     回调，可为 NULL
 * @warning 国内不允许带阅后即焚功能的 App 上架
 * @discussion 调用之后，阅后即焚消息开始倒计时，触发 rcim_engine_message_destructing_listener
 */
RC_API
void rcim_engine_message_begin_destruct(const struct RcimEngineSync *engine,
                                        const struct RcimMessageBox *msg_box,
                                        const void *context,
                                        RcimEngineErrorCb callback);

/**
 * 消息阅后即焚倒计停止时，仅支持单聊，仅限阅后即焚消息的接收方调用
 *
 * @since 0.11.0
 *
 * ```text
 * 调用之后，该消息终止阅后即焚
 * 阅后即焚倒计时停止，并触发 rcim_engine_set_message_destruction_stop_listener
 * 可以调用 rcim_engine_message_begin_destruct() 重新进行倒计时
 * ```
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param msg_box      消息体，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback     回调，可为 NULL
 * @warning 国内不允许带阅后即焚功能的 App 上架
 */
RC_API
void rcim_engine_message_stop_destruct(const struct RcimEngineSync *engine,
                                       const struct RcimMessageBox *msg_box,
                                       const void *context,
                                       RcimEngineErrorCb callback);

/**
 * 设置会话状态监听
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     会话状态变更监听函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_conversation_status_listener(const struct RcimEngineSync *engine,
                                                                  const void *context,
                                                                  RcimConversationStatusLsr listener);

/**
 * 设置输入状态的监听
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     输入状态的监听
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_typing_status_listener(const struct RcimEngineSync *engine,
                                                            const void *context,
                                                            RcimTypingStatusLsr listener);

/**
 * 发送输入状态
 *
 * @param engine                   引擎实例指针，非 NULL 必传，C 负责释放
 * @param context                  上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param conv_type                待查询消息的会话类型
 * @param target_id                待查询消息的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id               待查询消息的频道 ID，可为 null，C 负责释放
 * @param object_name              输入状态的消息类型（文本：RC:TxtMsg)
 * @return                         调用结果码
 */
RC_API
void rcim_engine_send_typing_status(const struct RcimEngineSync *engine,
                                    enum RcimConversationType conv_type,
                                    const char *target_id,
                                    const char *channel_id,
                                    const char *object_name,
                                    const void *context,
                                    RcimEngineErrorCb callback);

/**
 * 设置发送状态的时间间隔
 *
 * @param engine                       引擎实例指针，非 NULL 必传，C 负责释放
 * @param interval_ms                  发送状态的时间间隔（单位：毫秒）
 *                                     有效值 [1000，60000] 毫秒；超过范围，则设置不成功
 * @param context                      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback                     清除本地会话的回调函数指针
 */
RC_API
void rcim_engine_set_typing_status_interval(const struct RcimEngineSync *engine,
                                            int32_t interval_ms,
                                            const void *context,
                                            RcimEngineErrorCb callback);

/**
 * 获取本地会话
 *
 * @since v0.5.0
 *
 * @param engine                   引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type                待获取的会话类型
 * @param target_id                待获取的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id               待获取的频道 ID，可为 NULL，C 负责释放
 * @param callback                 获取本地会话结果回调函数指针
 */
RC_API
void rcim_engine_get_local_conversation(const struct RcimEngineSync *engine,
                                        enum RcimConversationType conv_type,
                                        const char *target_id,
                                        const char *channel_id,
                                        const void *context,
                                        RcimGetConversationCb callback);

/**
 * 批量获取本地会话
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec        待获取的会话类型数组指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec_len    待获取的会话类型数组长度，取值范围 [1, 100]
 * @param send_time            查询的起始发送时间，返回小于该时间的会话；如果为 0，则查询全部。当分页时，可以传入上一次查询的最后一个会话的操作时间，取值范围 [0, INT64_MAX]
 * @param count                期望返回结果的最大个数，即分页查询的每页个数，取值范围 [1, 1000]
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             获取本地会话结果回调函数指针
 */
RC_API
void rcim_engine_get_local_conversations_by_page(const struct RcimEngineSync *engine,
                                                 const enum RcimConversationType *conv_type_vec,
                                                 int32_t conv_type_vec_len,
                                                 int64_t send_time,
                                                 int32_t count,
                                                 const void *context,
                                                 RcimGetConversationListCb callback);

/**
 * 批量获取本地置顶会话
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec        待获取的会话类型数组指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec_len    待获取的会话类型数组长度，取值范围 [1, 100]
 * @param send_time            查询的起始发送时间，返回小于该时间的会话；如果为 0，则查询全部。当分页时，可以传入上一次查询的最后一条消息的发送时间，取值范围 [0, INT64_MAX]
 * @param count                期望返回结果的最大个数，即分页查询的每页个数，取值范围 [1, 1000]
 * @param is_pinned            是否置顶
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             获取本地会话结果回调函数指针
 */
RC_API
void rcim_engine_get_local_pin_conversations_by_page(const struct RcimEngineSync *engine,
                                                     const enum RcimConversationType *conv_type_vec,
                                                     int32_t conv_type_vec_len,
                                                     int64_t send_time,
                                                     int32_t count,
                                                     bool is_pinned,
                                                     const void *context,
                                                     RcimGetConversationListCb callback);

/**
 * 批量获取本地免打扰会话
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec        待获取的会话类型数组指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec_len    待获取的会话类型数组长度，取值范围 [1, 100]
 * @param send_time            查询的起始发送时间，返回小于该时间的会话；如果为 0，则查询全部。当分页时，可以传入上一次查询的最后一条消息的发送时间，取值范围 [0, INT64_MAX]
 * @param count                期望返回结果的最大个数，即分页查询的每页个数，取值范围 [1, 1000]
 * @param mute_level_vec       免打扰级别指针数组，非 NULL 必传
 * @param mute_level_vec_len   免打扰级别指针数组长度，范围 [0, 20]
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             获取本地会话结果回调函数指针
 */
RC_API
void rcim_engine_get_local_muted_conversations_by_page(const struct RcimEngineSync *engine,
                                                       const enum RcimConversationType *conv_type_vec,
                                                       int32_t conv_type_vec_len,
                                                       int64_t send_time,
                                                       int32_t count,
                                                       const enum RcimPushNotificationMuteLevel *mute_level_vec,
                                                       int32_t mute_level_vec_len,
                                                       const void *context,
                                                       RcimGetConversationListCb callback);

/**
 * 按类型清除本地会话，只会移除本地数据库中指定类型的会话和消息。不会删除服务器数据
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec        待清除的会话类型数组指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec_len    待清除的会话类型数组长度，取值范围 [1, 100]
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             清除本地会话的回调函数指针
 */
RC_API
void rcim_engine_clear_local_conversations(const struct RcimEngineSync *engine,
                                           const enum RcimConversationType *conv_type_vec,
                                           int32_t conv_type_vec_len,
                                           const void *context,
                                           RcimEngineErrorCb callback);

/**
 * 移除远端和本地的指定会话，但会话内的消息不会删除，当有新消息到达时，仍能看到已存储的本地历史消息
 *
 * @since v0.5.0
 *
 * @param engine                   引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_idf_vec             待移除会话标识的指针数组，数组个数范围为 [1, 20]，非 NULL 必传，C 负责释放
 * @param conv_idf_vec_len         待移除会话标识的指针数组长度
 * @param context                  上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback                 移除会话的回调函数
 */
RC_API
void rcim_engine_remove_conversations(const struct RcimEngineSync *engine,
                                      const struct RcimConversationIdentifier *conv_idf_vec,
                                      int32_t conv_idf_vec_len,
                                      const void *context,
                                      RcimEngineErrorCb callback);

/**
 * 将传入的列表中会话全部置顶，若会话不存在，可选择是否创建新会话
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_vec             待置顶会话标识的指针数组，数组个数范围为 [1, 20]，非 NULL 必传，C 负责释放
 * @param conv_vec_len         待置顶会话标识的指针数组长度
 * @param is_pinned            是否置顶
 * @param need_create          如果会话不存在，是否需要创建
 * @param need_update_time     是否需要更新会话时间戳
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             置顶会话的回调函数
 */
RC_API
void rcim_engine_pin_conversations(const struct RcimEngineSync *engine,
                                   const struct RcimConversationIdentifier *conv_vec,
                                   int32_t conv_vec_len,
                                   bool is_pinned,
                                   bool need_create,
                                   bool need_update_time,
                                   const void *context,
                                   RcimEngineErrorCb callback);

/**
 * 获取本地会话的置顶状态
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type        待获取的会话类型
 * @param target_id        待获取的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       待获取的频道 ID，可为 NULL，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         获取会话置顶状态的回调函数
 */
RC_API
void rcim_engine_get_local_conversation_pin_status(const struct RcimEngineSync *engine,
                                                   enum RcimConversationType conv_type,
                                                   const char *target_id,
                                                   const char *channel_id,
                                                   const void *context,
                                                   RcimGetBoolCb callback);

/**
 * 将传入的列表中会话全部设置为免打扰
 *
 * @since v0.5.0
 *
 * @param engine                   引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_idf_vec             待设置会话标识的指针数组，数组个数范围为 [1, 20]，非 NULL 必传，C 负责释放
 * @param conv_idf_vec_len         待设置会话标识的指针数组长度
 * @param mute_level               免打扰级别
 * @param context                  上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback                 设置会话免打扰的回调函数
 */
RC_API
void rcim_engine_mute_conversations(const struct RcimEngineSync *engine,
                                    const struct RcimConversationIdentifier *conv_idf_vec,
                                    int32_t conv_idf_vec_len,
                                    enum RcimPushNotificationMuteLevel mute_level,
                                    const void *context,
                                    RcimEngineErrorCb callback);

/**
 * 获取会话的免打扰状态
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type            待获取的会话类型
 * @param target_id            待获取的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id           待获取的频道 ID，可为 NULL，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             获取会话免打扰的回调函数
 */
RC_API
void rcim_engine_get_local_conversation_mute_level(const struct RcimEngineSync *engine,
                                                   enum RcimConversationType conv_type,
                                                   const char *target_id,
                                                   const char *channel_id,
                                                   const void *context,
                                                   RcimGetLocalConversationMuteLevelCb callback);

/**
 * 获取本地未读会话
 *
 * @since v0.7.0
 *
 * @description                该接口仅支持单聊、群聊、系统三种会话类型，不支持聊天室、超级群。
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec        待获取的会话类型数组指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec_len    待获取的会话类型数组长度，取值范围 [1, 100]
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             结果回调
 */
RC_API
void rcim_engine_get_local_unread_conversation(const struct RcimEngineSync *engine,
                                               const enum RcimConversationType *conv_type_vec,
                                               int32_t conv_type_vec_len,
                                               const void *context,
                                               RcimGetConversationListCb callback);

/**
 * 根据关键字搜索本地会话。
 *
 * @since v0.7.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec        会话类型数组指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec_len    会话类型数组长度，取值范围 [1, 300]
 * @param channel_id           待查询消息的频道 ID，可为 NULL，C 负责释放
 * @param obj_name_vec         待查询消息的消息类型指针列表，如果为 NULL 则表示获取全部类型消息，C 负责释放
 * @param obj_name_vec_len     待查询消息的消息类型指针列表长度
 * @param keyword              搜索关键字，非 NULL 必传，C 负责释放，长度范围 [1, 256]
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             获取本地会话的回调函数指针
 */
RC_API
void rcim_engine_search_local_conversations(const struct RcimEngineSync *engine,
                                            const enum RcimConversationType *conv_type_vec,
                                            int32_t conv_type_vec_len,
                                            const char *channel_id,
                                            const char *const *obj_name_vec,
                                            int32_t obj_name_vec_len,
                                            const char *keyword,
                                            const void *context,
                                            RcimGetConversationListCb callback);

/**
 * 设置推送免打扰时间段
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param start_time           免打扰的开始时间，格式为 "HH:MM:SS"，非 NULL 必传，C 负责释放
 * @param duration_min         免打扰的持续时长（分钟），有效范围 [1, 1439]
 * @param mute_level           免打扰级别，如果设置为 Default，则取消免打扰
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             设置推送免打扰的回调函数
 */
RC_API
void rcim_engine_set_no_disturbing(const struct RcimEngineSync *engine,
                                   const char *start_time,
                                   int32_t duration_min,
                                   enum RcimPushNotificationMuteLevel mute_level,
                                   const void *context,
                                   RcimEngineErrorCb callback);

/**
 * 取消设置推送免打扰时间段
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback     取消设置推送免打扰的回调函数
 */
RC_API
void rcim_engine_unset_no_disturbing(const struct RcimEngineSync *engine,
                                     const void *context,
                                     RcimEngineErrorCb callback);

/**
 * 获取推送免打扰设置
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback     获取推送免打扰设置的回调函数
 */
RC_API
void rcim_engine_get_no_disturbing(const struct RcimEngineSync *engine,
                                   const void *context,
                                   RcimGetNoDisturbingCb callback);

/**
 * 保存会话草稿
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type        待保存草稿所属的会话类型
 * @param target_id        待保存草稿所属息的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       待保存草稿所属的频道 ID，可为 NULL，C 负责释放
 * @param draft            草稿内容，可为 NULL，为 NULL 时表示清除草稿
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         保存会话草稿的回调函数指针
 */
RC_API
void rcim_engine_save_text_message_draft(const struct RcimEngineSync *engine,
                                         enum RcimConversationType conv_type,
                                         const char *target_id,
                                         const char *channel_id,
                                         const char *draft,
                                         const void *context,
                                         RcimEngineErrorCb callback);

/**
 * 获取会话草稿
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type        待获取草稿所属的会话类型
 * @param target_id        待获取草稿所属息的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       待获取草稿所属的频道 ID，可为 NULL，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         获取会话草稿的回调函数指针
 */
RC_API
void rcim_engine_get_text_message_draft(const struct RcimEngineSync *engine,
                                        enum RcimConversationType conv_type,
                                        const char *target_id,
                                        const char *channel_id,
                                        const void *context,
                                        RcimGetTextMessageDraftCb callback);

/**
 * 获取所有未读消息数
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         获取未读数的回调函数指针
 */
RC_API
void rcim_engine_get_total_unread_count(const struct RcimEngineSync *engine,
                                        const void *context,
                                        RcimGetCountCb callback);

/**
 * 获取所有指定的会话未读消息数，不包含聊天室，聊天室消息不计数
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_idf_vec         待获取会话标识的指针数组，数组个数范围为 [1, 300]，非 NULL 必传，C 负责释放
 * @param conv_idf_vec_len     待获取会话标识的指针数组长度
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             获取未读数的回调函数指针
 */
RC_API
void rcim_engine_get_unread_count_by_conversations(const struct RcimEngineSync *engine,
                                                   const struct RcimConversationIdentifier *conv_idf_vec,
                                                   int32_t conv_idf_vec_len,
                                                   const void *context,
                                                   RcimGetCountCb callback);

/**
 * 获取指定会话的未读消息数
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type        待获取消息的会话类型
 * @param target_id        待获取消息的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       待获取消息的频道 ID，可为 NULL，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         获取未读数的回调函数指针
 */
RC_API
void rcim_engine_get_unread_count(const struct RcimEngineSync *engine,
                                  enum RcimConversationType conv_type,
                                  const char *target_id,
                                  const char *channel_id,
                                  const void *context,
                                  RcimGetCountCb callback);

/**
 * 获取指定会话类型的未读消息数量
 *
 * @param engine                   引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec            待获取的会话类型数组指针，非 NULL 必传，C 负责释放
 * @param conv_type_vec_len        待获取的会话类型数组长度，取值范围 [1, 300]
 * @param is_contain_blocked       是否包含免打扰；true 代表获取所有会话未读数之和；false 代表获取不包含免打扰会话的正常会话未读数之和
 * @param context                  上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback                 获取未读数的回调函数指针
 */
RC_API
void rcim_engine_get_unread_count_by_conversation_types(const struct RcimEngineSync *engine,
                                                        const enum RcimConversationType *conv_type_vec,
                                                        int32_t conv_type_vec_len,
                                                        bool is_contain_blocked,
                                                        const void *context,
                                                        RcimGetCountCb callback);

/**
 * 清除指定会话的未读数
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type        待清除未读数的会话类型
 * @param target_id        待清除未读数的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       待清除未读数的频道 ID，可为 NULL，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调，可为 NULL
 */
RC_API
void rcim_engine_clear_messages_unread_status(const struct RcimEngineSync *engine,
                                              enum RcimConversationType conv_type,
                                              const char *target_id,
                                              const char *channel_id,
                                              const void *context,
                                              RcimEngineErrorCb callback);

/**
 * 根据发送时间清除指定会话未读数
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type        待清除未读数的会话类型
 * @param target_id        待清除未读数的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       待清除未读数的频道 ID，可为 NULL，C 负责释放
 * @param send_time        指定的清除时间戳，发送时间小于等于该值的所有消息都会被清除未读状态，消息的具体发送时间，不能小于等于 0
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调，可为 NULL
 */
RC_API
void rcim_engine_clear_messages_unread_status_by_send_time(const struct RcimEngineSync *engine,
                                                           enum RcimConversationType conv_type,
                                                           const char *target_id,
                                                           const char *channel_id,
                                                           int64_t send_time,
                                                           const void *context,
                                                           RcimEngineErrorCb callback);

/**
 * 根据发送时间同步会话已读状态
 *
 * @since 0.10.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type        待同步已读的会话类型
 * @param target_id        待同步已读的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id       待同步已读的频道 ID，可为 NULL，C 负责释放
 * @param send_time        指定同步已读的时间戳，发送时间小于等于该值的所有消息都会被清除未读状态，消息的具体发送时间，不能小于等于 0
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         结果回调，可为 NULL
 */
RC_API
void rcim_engine_sync_conversation_read_status(const struct RcimEngineSync *engine,
                                               enum RcimConversationType conv_type,
                                               const char *target_id,
                                               const char *channel_id,
                                               int64_t send_time,
                                               const void *context,
                                               RcimEngineErrorCb callback);

/**
 * 设置会话已读状态监听
 *
 * @since 0.10.0
 *
 * @param engine                   引擎实例指针，非 NULL 必传，C 负责释放
 * @param context                  上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener                 监听函数指针
 * @return                         调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_sync_conversation_read_status_listener(const struct RcimEngineSync *engine,
                                                                            const void *context,
                                                                            RcimConversationReadStatusLsr listener_opt);

/**
 * 获取会话中的 @ 消息
 *
 * @since v0.5.0
 *
 * @param engine                   引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type                待清除未读数的会话类型
 * @param target_id                待清除未读数的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id               待清除未读数的频道 ID，可为 NULL，C 负责释放
 * @param count                    期望获取的消息数量，有效范围 [1, 100]
 * @param order                    获取消息的发送时间排序方式
 * @param context                  上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback                 获取消息的回调函数指针
 */
RC_API
void rcim_engine_get_unread_mentioned_messages(const struct RcimEngineSync *engine,
                                               enum RcimConversationType conv_type,
                                               const char *target_id,
                                               const char *channel_id,
                                               int32_t count,
                                               enum RcimOrder order,
                                               const void *context,
                                               RcimGetMessageListCb callback);

/**
 * 获取会话中的第一条未读消息
 *
 * @since v0.5.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param conv_type            待清除未读数的会话类型
 * @param target_id            待清除未读数的会话目标 ID，非 NULL 必传，C 负责释放
 * @param channel_id           待清除未读数的频道 ID，可为 NULL，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             获取消息的回调函数指针
 */
RC_API
void rcim_engine_get_first_unread_message(const struct RcimEngineSync *engine,
                                          enum RcimConversationType conv_type,
                                          const char *target_id,
                                          const char *channel_id,
                                          const void *context,
                                          RcimCodeMessageCb callback);

/**
 * 设置聊天室状态监听器
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     聊天室状态监听器
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_chatroom_status_listener(const struct RcimEngineSync *engine,
                                                              const void *context,
                                                              RcimChatroomStatusLsr listener);

/**
 * 设置聊天室成员变化监听
 *
 * @since v0.8.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     聊天室成员变化监听
 * @return             调用结果码
 *
 * @remark 聊天室成员变化监听功能默认不开启，需要提工单开启。
 */
RC_API
enum RcimEngineError rcim_engine_set_chatroom_member_changed_listener(const struct RcimEngineSync *engine,
                                                                      const void *context,
                                                                      RcimChatroomMemberChangedLsr listener);

/**
 * 设置聊天室成员禁言监听
 *
 * @since v0.8.0
 *
 * @param engine 引擎实例指针，非 NULL 必传，C 负责释放
 * @param context 上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener 聊天室成员禁言监听
 * @return 调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_chatroom_member_banned_listener(const struct RcimEngineSync *engine,
                                                                     const void *context,
                                                                     RcimChatroomMemberBannedLsr listener);

/**
 * 设置聊天室用户封禁监听
 *
 * @since v0.8.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     聊天室成员封禁监听
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_chatroom_member_blocked_listener(const struct RcimEngineSync *engine,
                                                                      const void *context,
                                                                      RcimChatroomMemberBlockedLsr listener);

/**
 * 设置聊天室多端同步监听
 *
 * @since v0.8.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     聊天室多端同步监听
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_chatroom_multi_client_sync_listener(const struct RcimEngineSync *engine,
                                                                         const void *context,
                                                                         RcimChatroomMultiClientSyncLsr listener);

/**
 * 加入聊天室
 *
 * @since v0.7.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param room_id          待加入聊天室的 ID，非 NULL 必传，C 负责释放
 * @param msg_pull_count   进入聊天室时自动拉取的消息数量。最多可以拉取 50 条消息，取值范围 [0,50]
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         执行结果的回调函数
 *
 * @remark 如果聊天室不存在，自动创建聊天室
 */
RC_API
void rcim_engine_join_chatroom(const struct RcimEngineSync *engine,
                               const char *room_id,
                               int32_t msg_pull_count,
                               const void *context,
                               RcimJoinChatroomCb callback);

/**
 * 加入已存在的聊天室
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param room_id          待加入聊天室的 ID，非 NULL 必传，C 负责释放
 * @param msg_pull_count   进入聊天室时自动拉取的消息数量。最多可以拉取 50 条消息，取值范围 [0,50]
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         执行结果的回调函数
 */
RC_API
void rcim_engine_join_existing_chatroom(const struct RcimEngineSync *engine,
                                        const char *room_id,
                                        int32_t msg_pull_count,
                                        const void *context,
                                        RcimJoinExistingChatroomCb callback);

/**
 * 退出聊天室
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param room_id      待退出聊天室的 ID，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback     执行结果的回调函数
 */
RC_API
void rcim_engine_quit_chatroom(const struct RcimEngineSync *engine,
                               const char *room_id,
                               const void *context,
                               RcimEngineErrorCb callback);

/**
 * 查询聊天室信息
 *
 * @since v0.5.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param room_id          待查询聊天室的 ID，非 NULL 必传，C 负责释放
 * @param query_count      期望查询人员信息的数量，有效范围 [0, 20]
 * @param order            期望查询人员加入聊天室的顺序。Ascending：最早加入的一批人；Descending：最新加入的一批人
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback         执行结果的回调函数
 */
RC_API
void rcim_engine_get_chatroom_info(const struct RcimEngineSync *engine,
                                   const char *room_id,
                                   int32_t query_count,
                                   enum RcimOrder order,
                                   const void *context,
                                   RcimGetChatroomInfoCb callback);

/**
 * 设置聊天室同步监听
 *
 * @since v0.8.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener         聊天室 kv 同步监听器
 * @return                 调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_chatroom_kv_sync_listener(const struct RcimEngineSync *engine,
                                                               const void *context,
                                                               RcimChatroomKvSyncLsr listener);

/**
 * 设置聊天室 kv 更新监听
 *
 * @since v0.8.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener         聊天室 kv 更新监听
 * @return                 调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_chatroom_kv_changed_listener(const struct RcimEngineSync *engine,
                                                                  const void *context,
                                                                  RcimChatroomKvChangedLsr listener_opt);

/**
 * 设置聊天室 kv 删除监听
 *
 * @since v0.8.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener         聊天室 kv 删除监听
 * @return                 调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_chatroom_kv_delete_listener(const struct RcimEngineSync *engine,
                                                                 const void *context,
                                                                 RcimChatroomKvDeleteLsr listener);

/**
 * 设置聊天室自定义属性
 *
 * @since v0.8.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param room_id              待设置的聊天室 ID，非 NULL 必传，C 负责释放
 * @param kv_vec               待设置的 kv 数组，非 NULL 必传，C 负责释放
 * @param kv_vec_len           待设置的 kv 数组长度，有效范围 [1, 10]
 * @param auto_delete          当用户掉线或退出聊天室后，是否自动删除设置的 kv
 * @param is_force             是否强制覆盖，用户设置 kv 后绑定有所属权，其他用户修改需要强制覆盖
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             结果回调
 *
 * @remark 每个聊天室支持设置最大 kv 数为 100，如果聊天室已经有 100 个 kv，则无法再增加新的 kv
 */
RC_API
void rcim_engine_set_chatroom_kvs(const struct RcimEngineSync *engine,
                                  const char *room_id,
                                  const struct RcimChatroomKvInfo *kv_vec,
                                  int32_t kv_vec_len,
                                  bool auto_delete,
                                  bool is_force,
                                  const void *context,
                                  RcimChatroomKvCb callback);

/**
 * 删除聊天室自定义属性
 *
 * @since v0.8.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param room_id              待删除的聊天室 ID，非 NULL 必传，C 负责释放
 * @param key_vec              待删除的 key 数组，非 NULL 必传，C 负责释放
 * @param key_vec_len          待删除的 key 数组长度，有效范围 [1, 10]
 * @param is_force             是否强制删除
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             结果回调
 */
RC_API
void rcim_engine_delete_chatroom_kvs(const struct RcimEngineSync *engine,
                                     const char *room_id,
                                     const char *const *key_vec,
                                     int32_t key_vec_len,
                                     bool is_force,
                                     const void *context,
                                     RcimChatroomKvCb callback);

/**
 * 获取聊天室自定义属性
 *
 * @since v0.8.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param room_id              待获取的聊天室 ID，非 NULL 必传，C 负责释放
 * @param key_vec              待获取的 key 数组，非 NULL 必传，C 负责释放
 * @param key_vec_len          待获取的 key 数组长度，有效范围 [1, 100]
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             结果回调
 */
RC_API
void rcim_engine_get_local_chatroom_kv_by_keys(const struct RcimEngineSync *engine,
                                               const char *room_id,
                                               const char *const *key_vec,
                                               int32_t key_vec_len,
                                               const void *context,
                                               RcimChatroomGetKvCb callback);

/**
 * 获取聊天室全部自定义属性
 *
 * @since v0.8.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param room_id              待获取的聊天室 ID，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             结果回调
 */
RC_API
void rcim_engine_get_chatroom_all_kvs(const struct RcimEngineSync *engine,
                                      const char *room_id,
                                      const void *context,
                                      RcimChatroomGetKvCb callback);

/**
 * 设置日志回调监听
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     日志数据监听回调函数指针
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_log_listener(const struct RcimEngineSync *engine,
                                                  const void *context,
                                                  RcimLogLsr listener);

/**
 * 设置日志过滤等级
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param level        日志过滤等级
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_log_filter(const struct RcimEngineSync *engine,
                                                enum RcimLogLevel level);

/**
 * 写入日志
 *
 * @since v0.5.0
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param log_info     日志数据，C 负责释放
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_insert_log(const struct RcimEngineSync *engine,
                                            const struct RcimInsertLogInfo *log_info);

/**
 * TODO(kongcong): 仅为现阶段功能测试与开发保留原 log 模块打印和日志输出，后续须删除
 */
RC_API
void rcim_dev_log_init(RcimDevLogLsr listener_opt);

/**
 * 获取本地的公众号
 *
 * @since v0.7.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param target_id            会话目标 ID，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             结果回调
 */
RC_API
void rcim_engine_get_local_public_service(const struct RcimEngineSync *engine,
                                          const char *target_id,
                                          const void *context,
                                          RcimGetPublicServiceCb callback);

/**
 * 获取订阅的公众号列表
 *
 * @since v0.7.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             结果回调
 *
 * @remark 当前版本仅支持 AppPublicService 会话类型
 */
RC_API
void rcim_engine_get_local_all_public_services(const struct RcimEngineSync *engine,
                                               const void *context,
                                               RcimGetLocalPublicServiceListCb callback);

/**
 * 设置 Voip 通话信息监听（内部方法，禁止私自调用）
 *
 * @since v0.10.0
 *
 * @param engine           引擎实例指针，非 NULL 必传，C 负责释放
 * @param context          上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener         Voip 通话信息监听
 * @return                 调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_voip_call_info_listener(const struct RcimEngineSync *engine,
                                                             const void *context,
                                                             RcimVoipCallInfoLsr listener);

/**
 * 发送 RTC 信令（内部方法，禁止私自调用）
 *
 * @since v0.10.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param room_id              房间 ID，非 NULL 必传，C 负责释放
 * @param method_name          信令方法名，非 NULL 必传，C 负责释放
 * @param is_query             是否是查询信令（对应 Query 或 Publish 信令）
 * @param data_info_vec        信令数据，非 NULL 必传，C 负责释放
 * @param data_info_vec_len    信令数据长度
 * @param timeout_sec          超时时间，单位：秒
 * @param out_ver              参数返回值，请求 ID，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param callback             结果回调
 */
RC_API
void rcim_engine_send_rtc_signaling(const struct RcimEngineSync *engine,
                                    const char *room_id,
                                    const char *method_name,
                                    bool is_query,
                                    const uint8_t *data_info_vec,
                                    int32_t data_info_vec_len,
                                    int32_t timeout_sec,
                                    int64_t *out_ver,
                                    const void *context,
                                    RcimSendRtcSignalingCb callback);

/**
 * 取消 RTC 信令（内部方法，禁止私自调用）
 *
 * @since v0.10.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param request_id_vec       请求 ID 数组，非 NULL 必传，C 负责释放
 * @param request_id_vec_len   请求 ID 数组长度
 * @return                     调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_cancel_rtc_signaling(const struct RcimEngineSync *engine,
                                                      const int64_t *request_id_vec,
                                                      int32_t request_id_vec_len);

/**
 * RTC 心跳发送过程监听（内部方法，禁止私自调用）
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener             心跳发送过程监听
 * @return                     调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_rtc_heartbeat_send_listener(const struct RcimEngineSync *engine,
                                                                 const void *context,
                                                                 RcimRtcHeartBeatSendLsr listener);

/**
 * RTC 心跳发送结果监听（内部方法，禁止私自调用）
 *
 * @param engine       引擎实例指针，非 NULL 必传，C 负责释放
 * @param context      上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener     心跳发送结果监听
 * @return             调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_rtc_heartbeat_send_result_listener(const struct RcimEngineSync *engine,
                                                                        const void *context,
                                                                        RcimRtcHeartBeatResultLsr listener);

/**
 * RTC 房间事件监听（内部方法，禁止私自调用）
 *
 * @since 0.10.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener_opt         房间事件监听
 * @return                     调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_rtc_room_event_listener(const struct RcimEngineSync *engine,
                                                             const void *context,
                                                             RcimRtcRoomEventLsr listener_opt);

/**
 * RTC 发送心跳（内部方法，禁止私自调用）
 *
 * @since v0.10.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param room_id_vec          房间 ID 数组，非 NULL 必传，C 负责释放
 * @param room_id_vec_len      房间 ID 数组长度
 * @param timeout_sec          超时时间，单位：秒，如果 <= 0 则使用默认值 30
 * @return                     调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_send_rtc_heartbeat(const struct RcimEngineSync *engine,
                                                    const char *const *room_id_vec,
                                                    int32_t room_id_vec_len,
                                                    int32_t timeout_sec);

/**
 * 发送 RTC 设置 GroupCall kv 信令（内部方法，禁止私自调用）
 *
 * @since v0.10.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param target_id            目标 ID，非 NULL 必传，C 负责释放
 * @param key                  要设置的 Key，非 NULL 必传，C 负责释放
 * @param value                要设置的 Value，非 NULL 必传，C 负责释放
 * @param context              回调上下文
 * @param callback             结果回调
 */
RC_API
void rcim_engine_rtc_set_kv_signaling(const struct RcimEngineSync *engine,
                                      const char *target_id,
                                      const char *key,
                                      const char *value,
                                      const void *context,
                                      RcimRtcSetKVSignalingCb callback);

/**
 * 设置 RTC groupCall kv 信令监听（内部方法，禁止私自调用）
 *
 * @since 0.10.0
 *
 * @param engine               引擎实例指针，非 NULL 必传，C 负责释放
 * @param context              上下文指针，用于回调时传递上下文信息，C 负责释放
 * @param listener_opt         kv 信令监听
 * @return                     调用结果码
 */
RC_API
enum RcimEngineError rcim_engine_set_rtc_kv_signaling_listener(const struct RcimEngineSync *engine,
                                                               const void *context,
                                                               RcimRtcKvSignalingLsr listener_opt);

/**
 * 初始化一个默认的 RcimMessageBox 结构体，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.5.0
 *
 * @return      返回初始化后的 RcimMessageBox 结构体指针，使用完毕请 C 使用者调用 rcim_free_message_box 释放。
 */
RC_API
struct RcimMessageBox *rcim_malloc_message_box(void);

/**
 * 释放 RcimMessageBox
 *
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.5.0
 *
 * @param value     待释放的 RcimMessageBox
 */
RC_API
void rcim_free_message_box(struct RcimMessageBox *value);

/**
 * 初始化一个默认的 RcimMessageBox 结构体数组，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.5.0
 *
 * @param len          待创建的 RcimMessageBox 数组长度
 * @return             RcimMessageBox 数组的指针，使用完毕请 C 使用者调用 rcim_free_message_box_vec 释放。
 * @remark:            返回的数组长度与入参的 len 一致
 */
RC_API
struct RcimMessageBox *rcim_malloc_message_box_vec(int32_t len);

/**
 * 释放 RcimMessageBox 数组
 *
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.5.0
 *
 * @param value     待释放的 RcimMessageBox 数组
 * @param len       待释放的 RcimMessageBox 数组长度
 */
RC_API
void rcim_free_message_box_vec(struct RcimMessageBox *value,
                               int32_t len);

/**
 * 初始化一个默认的 RcimReceivedStatus 结构体，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.5.0
 *
 * @return      返回初始化后的 RcimReceivedStatus 结构体指针，使用完毕请 C 使用者调用 rcim_free_receive_status 释放。
 */
RC_API
struct RcimReceivedStatus *rcim_malloc_receive_status(void);

/**
 * 释放 ReceivedStatus
 *
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.5.0
 *
 * @param value     待释放的 RcimReceivedStatus
 */
RC_API
void rcim_free_receive_status(struct RcimReceivedStatus *value);

/**
 * 初始化一个默认的 RcimPushConfig 结构体，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.5.0
 *
 * @return      返回初始化后的 RcimPushConfig 结构体指针，使用完毕请 C 使用者调用 rcim_free_push_config 释放。
 */
RC_API
struct RcimPushConfig *rcim_malloc_push_config(void);

/**
 * 释放 RcimPushConfig
 *
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.5.0
 *
 * @param value     待释放的 RcimPushConfig
 */
RC_API
void rcim_free_push_config(struct RcimPushConfig *value);

/**
 * 初始化一个默认的 RcimIosConfig 结构体，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.8.0
 *
 * @return      返回初始化后的 RcimIosConfig 结构体指针，使用完毕请 C 使用者调用 rcim_free_ios_config 释放。
 */
RC_API
struct RcimIosConfig *rcim_malloc_ios_config(void);

/**
 * 释放 RcimIosConfig
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.8.0
 *
 * @param value     待释放的 RcimIosConfig
 */
RC_API
void rcim_free_ios_config(struct RcimIosConfig *value);

/**
 * 初始化一个默认的 RcimAndroidConfig 结构体，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.8.0
 *
 * @return      返回初始化后的 RcimAndroidConfig 结构体指针，使用完毕请 C 使用者调用 rcim_free_android_config 释放。
 */
RC_API
struct RcimAndroidConfig *rcim_malloc_android_config(void);

/**
 * 释放 RcimAndroidConfig
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.8.0
 *
 * @param value     待释放的 RcimAndroidConfig
 */
RC_API
void rcim_free_android_config(struct RcimAndroidConfig *value);

/**
 * 初始化一个默认的 RcimHarmonyConfig 结构体，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.8.0
 *
 * @return      返回初始化后的 RcimHarmonyConfig 结构体指针，使用完毕请 C 使用者调用 rcim_free_harmony_config 释放。
 */
RC_API
struct RcimHarmonyConfig *rcim_malloc_harmony_config(void);

/**
 * 释放 RcimHarmonyConfig
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.8.0
 *
 * @param value     待释放的 RcimHarmonyConfig
 */
RC_API
void rcim_free_harmony_config(struct RcimHarmonyConfig *value);

/**
 * 初始化一个默认的 RcimMessageType 结构体，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.5.0
 *
 * @return      返回初始化后的 RcimMessageType 结构体指针，使用完毕请 C 使用者调用 rcim_free_msg_type 释放。
 */
RC_API
struct RcimMessageType *rcim_malloc_msg_type(void);

/**
 * 释放 RcimMessageType
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.5.0
 *
 * @param value     待释放的 RcimMessageType
 */
RC_API
void rcim_free_msg_type(struct RcimMessageType *value);

/**
 * 初始化一个默认的 RcimConversation 结构体，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.5.0
 *
 * @return      返回初始化后的 RcimConversation 结构体指针，使用完毕请 C 使用者调用 rcim_free_conversation 释放。
 */
RC_API
struct RcimConversation *rcim_malloc_conversation(void);

/**
 * 释放 RcimConversation
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.5.0
 *
 * @param value     待释放的 RcimConversation
 */
RC_API
void rcim_free_conversation(struct RcimConversation *value);

/**
 * 初始化一个默认的 RcimConversationIdentifier 结构体，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.5.0
 *
 * @return      返回初始化后的 RcimConversationIdentifier 结构体指针，使用完毕请 C 使用者调用 rcim_free_conversation_identifier_c 释放。
 */
RC_API
struct RcimConversationIdentifier *rcim_malloc_conversation_identifier(void);

/**
 * 释放 RcimConversationIdentifier
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.5.0
 *
 * @param value     待释放的 RcimConversationIdentifier
 */
RC_API
void rcim_free_conversation_identifier_c(struct RcimConversationIdentifier *value);

/**
 * 初始化一个默认的 RcimConversationIdentifier 结构体数组，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.8.0
 *
 * @param len          待创建的 RcimConversationIdentifier 数组长度
 * @return             RcimConversationIdentifier 数组的指针，使用完毕请 C 使用者调用 rcim_free_conversation_identifier_vec 释放。
 * @remark:            返回的数组长度与入参的 len 一致
 */
RC_API
struct RcimConversationIdentifier *rcim_malloc_conversation_identifier_vec(int32_t len);

/**
 * 释放 RcimConversationIdentifier 数组
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.8.0
 *
 * @param value     待释放的 RcimConversationIdentifier 数组
 * @param len       待释放的 RcimConversationIdentifier 数组长度
 */
RC_API
void rcim_free_conversation_identifier_vec(struct RcimConversationIdentifier *value,
                                           int32_t len);

/**
 * 初始化一个默认的 RcimSDKVersion 结构体，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.5.0
 *
 * @return      返回初始化后的 RcimSDKVersion 结构体指针，使用完毕请 C 使用者调用 rcim_free_sdk_version 释放。
 */
RC_API
struct RcimSDKVersion *rcim_malloc_sdk_version(void);

/**
 * 释放 RcimSDKVersion
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.5.0
 *
 * @param value     待释放的 RcimSDKVersion
 */
RC_API
void rcim_free_sdk_version(struct RcimSDKVersion *value);

/**
 * 初始化一个默认的 RcimEngineBuilderParam 结构体，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.5.0
 *
 * @return     RcimEngineBuilderParam 的指针，使用完毕请 C 使用者调用 rcim_free_engine_builder_param 释放。
 */
RC_API
struct RcimEngineBuilderParam *rcim_malloc_engine_builder_param(void);

/**
 * 释放 RcimEngineBuilderParam
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.5.0
 *
 * @param value     待释放的 RcimEngineBuilderParam
 */
RC_API
void rcim_free_engine_builder_param(struct RcimEngineBuilderParam *value);

/**
 * 初始化一个默认的 RcimPushTokenInfo 结构体数组，所有指针类型都为  NULL，数值类型为 0
 *
 * @since v0.5.0
 *
 * @param len          待创建的 RcimPushTokenInfo 数组长度
 * @return             RcimPushTokenInfo 数组的指针，使用完毕请 C 使用者调用 rcim_free_push_token_info_vec 释放。
 * @remark:            返回的数组长度与入参的 len 一致
 */
RC_API
struct RcimPushTokenInfo *rcim_malloc_push_token_info_vec(int32_t len);

/**
 * 释放 RcimPushTokenInfo 数组
 * 注意：由于不能区分成员指针变量所指内存位于堆区还是栈区，本函数仅释放自身，调用前请确保成员指针变量的正确释放。
 *
 * @since v0.5.0
 *
 * @param value     待释放的 RcimPushTokenInfo 数组
 * @param len       待释放的 RcimPushTokenInfo 数组长度
 */
RC_API
void rcim_free_push_token_info_vec(struct RcimPushTokenInfo *value,
                                   int32_t len);

/**
 * 释放由 Rust 生成返回的 const char* 对象。通常使用 C 语言的 free 函数释放即可，个别平台如遇 free 释放不干净，可尝试使用此函数释放。
 * 注意：value 指针必须是指向堆区的，否则释放会崩溃
 *
 * @since v0.5.0
 *
 * @param value    待释放的 const char* 对象
 */
RC_API
void rcim_free_char(const char *value);

/**
 * 内部使用
 */
RC_API
enum RcimEngineError rcim_engine_set_cmp_send_listener(const struct RcimEngineSync *engine,
                                                       const void *context,
                                                       RcimCmpSendCb listener);

#endif  /* RCIM_CLIENT_H */
