""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.ugn.schemas import apis


class UGNClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UGNClient, self).__init__(config, transport, middleware, logger)

    def attach_ugn_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """AttachUGNInstance - 实例加入云联网

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **InstanceId** (str) - (Required) 实例Id
        - **InstanceProjectId** (str) - (Required) 实例归属ProjectId
        - **InstanceRegion** (str) - (Required) 实例归属地域
        - **InstanceType** (str) - (Required) 实例类型
        - **UGNId** (str) - (Required) 云联网Id

        **Response**

        - **Message** (str) - 返回码描述信息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.AttachUGNInstanceRequestSchema().dumps(d)

        resp = self.invoke("AttachUGNInstance", d, **kwargs)
        return apis.AttachUGNInstanceResponseSchema().loads(resp)

    def batch_detach_ugn_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """BatchDetachUGNInstance - 批量移除云联网中实例

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **InstanceIds** (list) - (Required) 实例id
        - **UGNId** (str) - (Required) 云联网id

        **Response**

        - **InstanceIds** (list) - 删除成功的实例id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.BatchDetachUGNInstanceRequestSchema().dumps(d)

        resp = self.invoke("BatchDetachUGNInstance", d, **kwargs)
        return apis.BatchDetachUGNInstanceResponseSchema().loads(resp)

    def create_inter_region_bandwidth(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateInterRegionBandwidth - 购买跨域带宽

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Bandwidth** (int) - (Required) 带宽（单位为Mb/s）
        - **ChargeType** (str) - (Required) 计费类型
        - **PayMode** (str) - (Required) 付费类型
        - **Quantity** (int) - (Required) 购买时长
        - **Region0** (str) - (Required) 跨域带宽归属地域
        - **Region1** (str) - (Required) 跨域带宽归属地域
        - **UGNId** (str) - (Required) 云联网Id
        - **CouponId** (str) - 代金券Id

        **Response**

        - **InterRegionBandwidthId** (str) - 跨域带宽Id
        - **Message** (str) - 返回码描述信息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.CreateInterRegionBandwidthRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateInterRegionBandwidth", d, **kwargs)
        return apis.CreateInterRegionBandwidthResponseSchema().loads(resp)

    def create_ugn(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """CreateUGN -

        **Request**

        - **ProjectId** (str) - (Config)
        - **Name** (str) -
        - **Networks** (list) -
        - **Remark** (str) -

        **Response**

        - **Message** (str) -
        - **UGNID** (str) -

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.CreateUGNRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUGN", d, **kwargs)
        return apis.CreateUGNResponseSchema().loads(resp)

    def delete_inter_region_bandwidth(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteInterRegionBandwidth - 删除跨域带宽

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **InterRegionBandwidthId** (str) - (Required) 跨域带宽Id
        - **UGNId** (str) - (Required) 云联网Id

        **Response**

        - **Message** (str) - 返回码描述信息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DeleteInterRegionBandwidthRequestSchema().dumps(d)

        resp = self.invoke("DeleteInterRegionBandwidth", d, **kwargs)
        return apis.DeleteInterRegionBandwidthResponseSchema().loads(resp)

    def delete_ugn(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """DeleteUGN - 删除云联网

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **UGNId** (str) - (Required) 云联网Id

        **Response**

        - **Message** (str) - 返回码描述信息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DeleteUGNRequestSchema().dumps(d)

        resp = self.invoke("DeleteUGN", d, **kwargs)
        return apis.DeleteUGNResponseSchema().loads(resp)

    def describe_inter_region_bandwidth(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeInterRegionBandwidth - 查询跨域带宽

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **UGNId** (str) - (Required) 云联网Id
        - **InterRegionBandwidthIds** (list) - 跨域带宽Id
        - **Limit** (int) - 数据分页值。默认为20
        - **Offset** (int) - 数据偏移量。默认为0

        **Response**

        - **InterRegionBandwidths** (list) - 见 **InterRegionBandwidth** 模型定义
        - **Message** (str) - 返回码描述信息
        - **TotalCount** (int) - InterRegionBandwidths字段的数量

        **Response Model**

        **InterRegionBandwidth**
        - **Bandwidth** (int) - 带宽（单位为Mb/s）
        - **ChargeType** (str) - 计费类型
        - **CreateTime** (int) - 创建时间
        - **ExpireTime** (int) - 到期时间
        - **InterRegionBandwidthId** (str) - 跨域带宽Id
        - **PayMode** (str) - 付费类型
        - **Region0** (str) - 跨域带宽地域
        - **Region1** (str) - 跨域带宽地域
        - **State** (int) - 跨域带宽状态
        - **UGNId** (str) - 云联网Id


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DescribeInterRegionBandwidthRequestSchema().dumps(d)

        resp = self.invoke("DescribeInterRegionBandwidth", d, **kwargs)
        return apis.DescribeInterRegionBandwidthResponseSchema().loads(resp)

    def describe_simple_ugn(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeSimpleUGN - 获取简洁版UGN详情

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **UGNID** (str) - (Required) UGN ID

        **Response**

        - **BwPackages** (list) - 见 **SimpleBwPackage** 模型定义
        - **Message** (str) -
        - **Networks** (list) - 见 **SimpleNetwork** 模型定义
        - **Routes** (list) - 见 **SimpleRoute** 模型定义
        - **UGN** (dict) - 见 **UGN** 模型定义

        **Response Model**

        **SimpleBwPackage**
        - **BandWidth** (float) - 带宽值
        - **ChangePayMode** (str) - 带宽包切换计费类型
        - **ChangeStatus** (int) - 带宽包切换状态
        - **ChangeTime** (int) - 带宽包切换时间
        - **CreateTime** (int) - 创建时间
        - **ExpireTime** (int) - 过期时间
        - **Name** (str) -
        - **PackageID** (str) -
        - **Path** (str) - 智能路径Delay:最低时延｜IGP:普通线路｜TCO:最低成本
        - **PayMode** (str) - 计费模式 FixedBw:固定带宽｜Peak95:经典95｜Max5:第五峰值｜Traffic:流量计费
        - **Qos** (str) - 服务质量Diamond:钻石｜Platinum:铂金｜Gold:黄金
        - **RegionA** (str) - 地域A名称
        - **RegionB** (str) - 地域B名称
        - **Remark** (str) -
        - **UGNID** (str) -


        **SimpleNetwork**
        - **CreateTime** (int) -
        - **Name** (str) - 网络实例名称
        - **NetworkID** (str) - 网络实例的ID，如 vnet-xxxxx
        - **OrgID** (int) - 网络实例所在项目的ID
        - **OrgName** (str) - 网络实例所在项目名
        - **Region** (str) - 网络实例所在地域
        - **RegionID** (int) - 网络实例所在地域ID
        - **Type** (str) - 网络实例类型：VPC/HybridGW/...


        **SimpleRoute**
        - **DstAddr** (str) - 目的网段
        - **NextHopID** (str) - 下一跳网络实例 ID
        - **NextHopRegion** (str) - 下一跳网络实例所属地域
        - **NextHopRegionID** (int) - 下一跳网络实例所属地域 id
        - **NextHopType** (str) - 下一跳网络实例类型
        - **Priority** (int) - 路由优先级


        **UGN**
        - **BwPackageCount** (int) - 绑定带宽包数量
        - **CreateTime** (int) - 云联网创建时间
        - **Name** (str) - 云联网名称
        - **NetworkCount** (int) - 关联网络实例数量
        - **Remark** (str) - 云联网备注
        - **UGNID** (str) - 云联网资源 ID


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DescribeSimpleUGNRequestSchema().dumps(d)

        resp = self.invoke("DescribeSimpleUGN", d, **kwargs)
        return apis.DescribeSimpleUGNResponseSchema().loads(resp)

    def describe_ugn_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUGNInstance - 查询云联网实例

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **UGNId** (str) - (Required) 云联网Id
        - **InstanceIds** (list) - 实例Id
        - **Limit** (int) - 数据分页值。默认为20
        - **Offset** (int) - 数据偏移量。默认为0

        **Response**

        - **Message** (str) - 返回码描述信息
        - **TotalCount** (int) - UGNInstances字段的数量
        - **UGNInstances** (list) - 见 **Instance** 模型定义

        **Response Model**

        **Instance**
        - **CreateTime** (int) - 加入时间
        - **InstanceId** (str) - 实例Id
        - **InstanceOrganizationName** (str) - 实例归属项目名称
        - **InstanceProjectId** (str) - 实例归属ProjectId
        - **InstanceRegion** (str) - 实例归属地域
        - **InstanceType** (str) - 实例类型
        - **Networks** (list) - 网段信息
        - **State** (int) - 实例状态
        - **UGNId** (str) - 云联网Id


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DescribeUGNInstanceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUGNInstance", d, **kwargs)
        return apis.DescribeUGNInstanceResponseSchema().loads(resp)

    def describe_ugn_region_list(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUGNRegionList - 获取ugn支持的地域

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_

        **Response**

        - **Message** (str) - 返回码描述信息
        - **RegionList** (list) - 地域列表

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DescribeUGNRegionListRequestSchema().dumps(d)

        resp = self.invoke("DescribeUGNRegionList", d, **kwargs)
        return apis.DescribeUGNRegionListResponseSchema().loads(resp)

    def describe_ugn_route_rule(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUGNRouteRule - 查询路由规则

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **UGNId** (str) - (Required) 云联网Id
        - **Limit** (int) - 数据分页值。默认为20
        - **Offset** (int) - 数据偏移量。默认为0
        - **RouteRuleIds** (list) - 路由规则Id

        **Response**

        - **Message** (str) - 返回码描述信息
        - **TotalCount** (int) - UGNRouteRules字段的数量
        - **UGNRouteRules** (list) - 见 **RouteRule** 模型定义

        **Response Model**

        **RouteRule**
        - **CreateTime** (int) - 创建时间
        - **DeriveInstanceId** (str) - 归属实例Id
        - **DeriveInstanceRegion** (str) - 归属实例地域
        - **DeriveInstanceType** (str) - 归属实例类型
        - **DeriveRouteRuleId** (str) - 归属实例路由规则Id
        - **DeriveRouteTableId** (str) - 归属实例路由表Id
        - **DstAddr** (str) - 目的地址
        - **Enable** (bool) - false:未使能true:已使能
        - **NextHopId** (str) - 归属实例路由下一跳
        - **NextHopType** (str) - 归属实例路由下一跳类型
        - **Priority** (int) - 优先级
        - **Rollback** (bool) - false:不可撤回true:可撤回
        - **RouteRuleId** (str) - 路由规则Id
        - **RouteRuleType** (int) - 路由规则类型，枚举值 0：自动发布的LOCAL和动态路由1：手动发布的自定义路由


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DescribeUGNRouteRuleRequestSchema().dumps(d)

        resp = self.invoke("DescribeUGNRouteRule", d, **kwargs)
        return apis.DescribeUGNRouteRuleResponseSchema().loads(resp)

    def detach_ugn_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DetachUGNInstance - 实例退出云联网

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **InstanceId** (str) - (Required) 实例Id
        - **InstanceType** (str) - (Required) 实例类型
        - **UGNId** (str) - (Required) 云联网Id

        **Response**

        - **Message** (str) - 返回码描述信息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DetachUGNInstanceRequestSchema().dumps(d)

        resp = self.invoke("DetachUGNInstance", d, **kwargs)
        return apis.DetachUGNInstanceResponseSchema().loads(resp)

    def get_simple_ugn_bw_packages(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetSimpleUGNBwPackages - 获取指定云联网内的带宽包

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **UGNID** (str) - (Required)
        - **Limit** (int) - 分页大小，默认20
        - **Offset** (int) - 偏移量，默认0

        **Response**

        - **BwPackages** (list) - 见 **SimpleBwPackage** 模型定义
        - **Limit** (int) -
        - **Message** (str) -
        - **Offset** (int) -
        - **TotalCount** (int) -

        **Response Model**

        **SimpleBwPackage**
        - **BandWidth** (float) - 带宽值
        - **ChangePayMode** (str) - 带宽包切换计费类型
        - **ChangeStatus** (int) - 带宽包切换状态
        - **ChangeTime** (int) - 带宽包切换时间
        - **CreateTime** (int) - 创建时间
        - **ExpireTime** (int) - 过期时间
        - **Name** (str) -
        - **PackageID** (str) -
        - **Path** (str) - 智能路径Delay:最低时延｜IGP:普通线路｜TCO:最低成本
        - **PayMode** (str) - 计费模式 FixedBw:固定带宽｜Peak95:经典95｜Max5:第五峰值｜Traffic:流量计费
        - **Qos** (str) - 服务质量Diamond:钻石｜Platinum:铂金｜Gold:黄金
        - **RegionA** (str) - 地域A名称
        - **RegionB** (str) - 地域B名称
        - **Remark** (str) -
        - **UGNID** (str) -


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.GetSimpleUGNBwPackagesRequestSchema().dumps(d)

        resp = self.invoke("GetSimpleUGNBwPackages", d, **kwargs)
        return apis.GetSimpleUGNBwPackagesResponseSchema().loads(resp)

    def list_simple_bw_package(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ListSimpleBwPackage - 获取当前项目下的带宽包列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Limit** (int) -
        - **Offset** (int) -

        **Response**

        - **BwPackages** (list) - 见 **SimpleBwPackage** 模型定义
        - **Limit** (int) -
        - **Offset** (int) -
        - **TotalCount** (int) -

        **Response Model**

        **SimpleBwPackage**
        - **BandWidth** (float) - 带宽值
        - **ChangePayMode** (str) - 带宽包切换计费类型
        - **ChangeStatus** (int) - 带宽包切换状态
        - **ChangeTime** (int) - 带宽包切换时间
        - **CreateTime** (int) - 创建时间
        - **ExpireTime** (int) - 过期时间
        - **Name** (str) -
        - **PackageID** (str) -
        - **Path** (str) - 智能路径Delay:最低时延｜IGP:普通线路｜TCO:最低成本
        - **PayMode** (str) - 计费模式 FixedBw:固定带宽｜Peak95:经典95｜Max5:第五峰值｜Traffic:流量计费
        - **Qos** (str) - 服务质量Diamond:钻石｜Platinum:铂金｜Gold:黄金
        - **RegionA** (str) - 地域A名称
        - **RegionB** (str) - 地域B名称
        - **Remark** (str) -
        - **UGNID** (str) -


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.ListSimpleBwPackageRequestSchema().dumps(d)

        resp = self.invoke("ListSimpleBwPackage", d, **kwargs)
        return apis.ListSimpleBwPackageResponseSchema().loads(resp)

    def list_ugn(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ListUGN - 获取当前项目下所有云联网资源

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Limit** (int) - 分页大小，默认20
        - **Offset** (int) - 偏移量，默认0

        **Response**

        - **Limit** (int) -
        - **Message** (str) -
        - **Offset** (int) -
        - **TotalCount** (int) -
        - **UGNs** (list) - 见 **UGN** 模型定义

        **Response Model**

        **UGN**
        - **BwPackageCount** (int) - 绑定带宽包数量
        - **CreateTime** (int) - 云联网创建时间
        - **Name** (str) - 云联网名称
        - **NetworkCount** (int) - 关联网络实例数量
        - **Remark** (str) - 云联网备注
        - **UGNID** (str) - 云联网资源 ID


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.ListUGNRequestSchema().dumps(d)

        resp = self.invoke("ListUGN", d, **kwargs)
        return apis.ListUGNResponseSchema().loads(resp)

    def modify_inter_region_bandwidth(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyInterRegionBandwidth - 修改跨域带宽

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Bandwidth** (str) - (Required) 带宽（单位为Mb/s）
        - **InterRegionBandwidthId** (str) - (Required) 跨域带宽Id
        - **UGNId** (str) - (Required) 云联网Id
        - **PayMode** (str) - 付费类型

        **Response**

        - **Message** (str) - 返回码描述信息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.ModifyInterRegionBandwidthRequestSchema().dumps(d)

        resp = self.invoke("ModifyInterRegionBandwidth", d, **kwargs)
        return apis.ModifyInterRegionBandwidthResponseSchema().loads(resp)

    def modify_ugn_attribute(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyUGNAttribute - 修改云联网属性

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **UGNId** (str) - (Required) 云联网Id
        - **Name** (str) - 云联网名称
        - **Remark** (str) - 云联网备注

        **Response**

        - **Message** (str) - 错误码描述信息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.ModifyUGNAttributeRequestSchema().dumps(d)

        resp = self.invoke("ModifyUGNAttribute", d, **kwargs)
        return apis.ModifyUGNAttributeResponseSchema().loads(resp)

    def modify_ugn_bandwidth(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyUGNBandwidth - 修改云联网带宽大小

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **BandWidth** (int) - (Required) 带宽值
        - **PackageID** (str) - (Required) 带宽包id
        - **UGNID** (str) - (Required) 云联网id

        **Response**

        - **Message** (str) -

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.ModifyUGNBandwidthRequestSchema().dumps(d)

        resp = self.invoke("ModifyUGNBandwidth", d, **kwargs)
        return apis.ModifyUGNBandwidthResponseSchema().loads(resp)

    def publish_ugn_route_rule(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """PublishUGNRouteRule - 发布云联网路由规则

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **DeriveRouteRuleId** (str) - (Required) 归属实例路由规则Id
        - **DeriveRouteTableId** (str) - (Required) 归属实例路由表Id
        - **InstanceId** (str) - (Required) 实例Id
        - **UGNId** (str) - (Required) 云联网Id

        **Response**

        - **Message** (str) - 返回码描述信息
        - **RouteRuleId** (str) - 路由规则Id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.PublishUGNRouteRuleRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("PublishUGNRouteRule", d, **kwargs)
        return apis.PublishUGNRouteRuleResponseSchema().loads(resp)

    def s_describe_ugn(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """SDescribeUGN - 获取简洁版UGN详情

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **UGNID** (str) - (Required) UGN ID

        **Response**

        - **BwPackages** (list) - 见 **SBwPackage** 模型定义
        - **Message** (str) -
        - **Networks** (list) - 见 **SNetwork** 模型定义
        - **Policies** (list) - 暂不支持
        - **Routes** (list) - 见 **Route** 模型定义
        - **UGN** (dict) - 见 **UGN** 模型定义

        **Response Model**

        **SBwPackage**
        - **BandWidth** (int) - 带宽值
        - **ChangePayMode** (str) - 带宽包切换计费类型
        - **ChangeStatus** (int) - 带宽包切换状态
        - **ChangeTime** (int) - 带宽包切换时间
        - **CreateTime** (int) - 创建时间
        - **ExpireTime** (int) - 过期时间
        - **Message** (str) - 备注信息
        - **Name** (str) -
        - **PackageID** (str) -
        - **Path** (str) - 智能路径Delay:最低时延｜IGP:普通线路｜TCO:最低成本
        - **PayMode** (str) - 计费模式 FixedBw:固定带宽｜Peak95:经典95｜Max5:第五峰值｜Traffic:流量计费
        - **Qos** (str) - 服务质量Diamond:钻石｜Platinum:铂金｜Gold:黄金
        - **RegionA** (str) - 地域A名称
        - **RegionB** (str) - 地域B名称
        - **Remark** (str) -
        - **UGNID** (str) -


        **SNetwork**
        - **CreateTime** (str) -
        - **Name** (str) - 网络实例名称
        - **NetworkID** (str) - 网络实例的ID，如 vnet-xxxxx
        - **OrgID** (int) - 网络实例所在项目的ID
        - **OrgName** (str) - 网络实例所在项目名
        - **Region** (str) - 网络实例所在地域
        - **RegionID** (int) - 网络实例所在地域ID
        - **Type** (str) - 网络实例类型：VPC/HybridGW/...


        **Route**
        - **DstAddr** (str) - 目的网段
        - **NexthopID** (str) - 下一跳网络实例 ID
        - **NexthopRegion** (str) - 下一跳网络实例所属地域
        - **NexthopRegionID** (int) - 下一跳网络实例所属地域 id
        - **NexthopType** (str) - 下一跳网络实例类型
        - **Priority** (int) - 路由优先级


        **UGN**
        - **BwPackageCount** (int) - 绑定带宽包数量
        - **CreateTime** (int) - 云联网创建时间
        - **Name** (str) - 云联网名称
        - **NetworkCount** (int) - 关联网络实例数量
        - **Remark** (str) - 云联网备注
        - **UGNID** (str) - 云联网资源 ID


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.SDescribeUGNRequestSchema().dumps(d)

        resp = self.invoke("SDescribeUGN", d, **kwargs)
        return apis.SDescribeUGNResponseSchema().loads(resp)

    def unpublish_ugn_route_rule(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UnpublishUGNRouteRule - 取消发布云联网路由规则

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **DeriveRouteRuleId** (str) - (Required) 归属实例路由规则Id
        - **DeriveRouteTableId** (str) - (Required) 归属实例路由表Id
        - **InstanceId** (str) - (Required) 实例Id
        - **UGNId** (str) - (Required) 云联网Id

        **Response**

        - **Message** (str) - 返回码描述信息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.UnpublishUGNRouteRuleRequestSchema().dumps(d)

        resp = self.invoke("UnpublishUGNRouteRule", d, **kwargs)
        return apis.UnpublishUGNRouteRuleResponseSchema().loads(resp)

    def update_ugn_bw_package(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpdateUGNBwPackage -

        **Request**

        - **ProjectId** (str) - (Config)
        - **BwBidRate** (float) - (Required)
        - **BwULRate** (float) - (Required)
        - **PackageID** (str) - (Required)
        - **Path** (str) - (Required)
        - **PayMode** (str) - (Required)
        - **Qos** (str) - (Required)
        - **RegionA** (str) - (Required)
        - **RegionABwMax** (int) - (Required)
        - **RegionABwMin** (int) - (Required)
        - **RegionB** (str) - (Required)
        - **RegionBBwMax** (int) - (Required)
        - **RegionBBwMin** (int) - (Required)
        - **UGNID** (str) - (Required)
        - **ChargeType** (str) -
        - **Coupon** (str) -
        - **Name** (str) -
        - **Quantity** (str) -
        - **Remark** (str) -

        **Response**

        - **Message** (str) -

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.UpdateUGNBwPackageRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("UpdateUGNBwPackage", d, **kwargs)
        return apis.UpdateUGNBwPackageResponseSchema().loads(resp)
