# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._enums import *
from ._inputs import *
import pulumi_aws

__all__ = ['RestAPIArgs', 'RestAPI']

@pulumi.input_type
class RestAPIArgs:
    def __init__(__self__, *,
                 api_key_source: Optional['APIKeySource'] = None,
                 binary_media_types: Optional[Sequence[pulumi.Input[builtins.str]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_execute_api_endpoint: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_responses: Optional[Mapping[str, pulumi.Input['SwaggerGatewayResponseArgs']]] = None,
                 request_validator: Optional['RequestValidator'] = None,
                 routes: Optional[Sequence['RouteArgs']] = None,
                 stage_name: Optional[pulumi.Input[builtins.str]] = None,
                 static_routes_bucket: Optional[pulumi.Input['pulumi_aws.s3.Bucket']] = None,
                 swagger_string: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a RestAPI resource.
        :param 'APIKeySource' api_key_source: The source for the apikey. This can either be a HEADER or AUTHORIZER. If `apiKeyRequired` is
               set to true on a route, and this is not defined the value will default to HEADER.
        :param Sequence[pulumi.Input[builtins.str]] binary_media_types: List of binary media types supported by the REST API. By default, the REST API supports only UTF-8-encoded text payloads. 
               If importing an OpenAPI specification via the body argument, this corresponds to the x-amazon-apigateway-binary-media-types extension. 
               If the argument value is provided and is different than the OpenAPI value, the argument value will override the OpenAPI value.
        :param pulumi.Input[builtins.str] description: Description of the REST API.
        :param pulumi.Input[builtins.bool] disable_execute_api_endpoint: Whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke
               your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that
               clients use a custom domain name to invoke your API, disable the default endpoint. Defaults to false.
        :param Mapping[str, pulumi.Input['SwaggerGatewayResponseArgs']] gateway_responses: Define custom gateway responses for the API. This can be used to properly enable
               CORS for Lambda Authorizers.
        :param 'RequestValidator' request_validator: Request Validator specifies the validator to use at the API level. Note method level validators
               override this.
        :param Sequence['RouteArgs'] routes: Routes to use to initialize the APIGateway.  These will be used to create the Swagger
               specification for the API.
               
               Either `swaggerString` or `routes` must be specified.
        :param pulumi.Input[builtins.str] stage_name: The stage name for your API. This will get added as a base path to your API url.
        :param pulumi.Input['pulumi_aws.s3.Bucket'] static_routes_bucket: Bucket to use for placing resources for static resources.  If not provided a default one will
               be created on your behalf if any `StaticRoute`s are provided.
        :param pulumi.Input[builtins.str] swagger_string: A Swagger specification already in string form to use to initialize the APIGateway.  Note
               that you must manually provide permission for any route targets to be invoked by API Gateway
               when using `swaggerString`.
               
               Either `swaggerString` or `routes` must be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: 'Map of tags to assign to the resource. If configured with a provider `defaultTags` configuration block present,
               tags with matching keys will overwrite those defined at the provider-level.
        """
        if api_key_source is not None:
            pulumi.set(__self__, "api_key_source", api_key_source)
        if binary_media_types is not None:
            pulumi.set(__self__, "binary_media_types", binary_media_types)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_execute_api_endpoint is not None:
            pulumi.set(__self__, "disable_execute_api_endpoint", disable_execute_api_endpoint)
        if gateway_responses is not None:
            pulumi.set(__self__, "gateway_responses", gateway_responses)
        if request_validator is not None:
            pulumi.set(__self__, "request_validator", request_validator)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if stage_name is not None:
            pulumi.set(__self__, "stage_name", stage_name)
        if static_routes_bucket is not None:
            pulumi.set(__self__, "static_routes_bucket", static_routes_bucket)
        if swagger_string is not None:
            pulumi.set(__self__, "swagger_string", swagger_string)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="apiKeySource")
    def api_key_source(self) -> Optional['APIKeySource']:
        """
        The source for the apikey. This can either be a HEADER or AUTHORIZER. If `apiKeyRequired` is
        set to true on a route, and this is not defined the value will default to HEADER.
        """
        return pulumi.get(self, "api_key_source")

    @api_key_source.setter
    def api_key_source(self, value: Optional['APIKeySource']):
        pulumi.set(self, "api_key_source", value)

    @property
    @pulumi.getter(name="binaryMediaTypes")
    def binary_media_types(self) -> Optional[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of binary media types supported by the REST API. By default, the REST API supports only UTF-8-encoded text payloads. 
        If importing an OpenAPI specification via the body argument, this corresponds to the x-amazon-apigateway-binary-media-types extension. 
        If the argument value is provided and is different than the OpenAPI value, the argument value will override the OpenAPI value.
        """
        return pulumi.get(self, "binary_media_types")

    @binary_media_types.setter
    def binary_media_types(self, value: Optional[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "binary_media_types", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the REST API.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableExecuteApiEndpoint")
    def disable_execute_api_endpoint(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke
        your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that
        clients use a custom domain name to invoke your API, disable the default endpoint. Defaults to false.
        """
        return pulumi.get(self, "disable_execute_api_endpoint")

    @disable_execute_api_endpoint.setter
    def disable_execute_api_endpoint(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_execute_api_endpoint", value)

    @property
    @pulumi.getter(name="gatewayResponses")
    def gateway_responses(self) -> Optional[Mapping[str, pulumi.Input['SwaggerGatewayResponseArgs']]]:
        """
        Define custom gateway responses for the API. This can be used to properly enable
        CORS for Lambda Authorizers.
        """
        return pulumi.get(self, "gateway_responses")

    @gateway_responses.setter
    def gateway_responses(self, value: Optional[Mapping[str, pulumi.Input['SwaggerGatewayResponseArgs']]]):
        pulumi.set(self, "gateway_responses", value)

    @property
    @pulumi.getter(name="requestValidator")
    def request_validator(self) -> Optional['RequestValidator']:
        """
        Request Validator specifies the validator to use at the API level. Note method level validators
        override this.
        """
        return pulumi.get(self, "request_validator")

    @request_validator.setter
    def request_validator(self, value: Optional['RequestValidator']):
        pulumi.set(self, "request_validator", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['RouteArgs']]:
        """
        Routes to use to initialize the APIGateway.  These will be used to create the Swagger
        specification for the API.

        Either `swaggerString` or `routes` must be specified.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[Sequence['RouteArgs']]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The stage name for your API. This will get added as a base path to your API url.
        """
        return pulumi.get(self, "stage_name")

    @stage_name.setter
    def stage_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stage_name", value)

    @property
    @pulumi.getter(name="staticRoutesBucket")
    def static_routes_bucket(self) -> Optional[pulumi.Input['pulumi_aws.s3.Bucket']]:
        """
        Bucket to use for placing resources for static resources.  If not provided a default one will
        be created on your behalf if any `StaticRoute`s are provided.
        """
        return pulumi.get(self, "static_routes_bucket")

    @static_routes_bucket.setter
    def static_routes_bucket(self, value: Optional[pulumi.Input['pulumi_aws.s3.Bucket']]):
        pulumi.set(self, "static_routes_bucket", value)

    @property
    @pulumi.getter(name="swaggerString")
    def swagger_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A Swagger specification already in string form to use to initialize the APIGateway.  Note
        that you must manually provide permission for any route targets to be invoked by API Gateway
        when using `swaggerString`.

        Either `swaggerString` or `routes` must be specified.
        """
        return pulumi.get(self, "swagger_string")

    @swagger_string.setter
    def swagger_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "swagger_string", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        'Map of tags to assign to the resource. If configured with a provider `defaultTags` configuration block present,
        tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


class RestAPI(pulumi.ComponentResource):

    pulumi_type = "aws-apigateway:index:RestAPI"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key_source: Optional['APIKeySource'] = None,
                 binary_media_types: Optional[Sequence[pulumi.Input[builtins.str]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_execute_api_endpoint: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_responses: Optional[Mapping[str, pulumi.Input[Union['SwaggerGatewayResponseArgs', 'SwaggerGatewayResponseArgsDict']]]] = None,
                 request_validator: Optional['RequestValidator'] = None,
                 routes: Optional[Sequence[Union['RouteArgs', 'RouteArgsDict']]] = None,
                 stage_name: Optional[pulumi.Input[builtins.str]] = None,
                 static_routes_bucket: Optional[pulumi.Input['pulumi_aws.s3.Bucket']] = None,
                 swagger_string: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        The RestAPI component offers a simple interface for creating a fully functional API Gateway REST API. The
        REST API can define any number of routes, each of which maps a path and HTTP method to one of (1) an event
        hander route that invokes a Lambda Function (2) a local path route which uploads local files into an S3 bucket
        and serves them or (3) an integration target such as an HTTP proxy or service integration.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param 'APIKeySource' api_key_source: The source for the apikey. This can either be a HEADER or AUTHORIZER. If `apiKeyRequired` is
               set to true on a route, and this is not defined the value will default to HEADER.
        :param Sequence[pulumi.Input[builtins.str]] binary_media_types: List of binary media types supported by the REST API. By default, the REST API supports only UTF-8-encoded text payloads. 
               If importing an OpenAPI specification via the body argument, this corresponds to the x-amazon-apigateway-binary-media-types extension. 
               If the argument value is provided and is different than the OpenAPI value, the argument value will override the OpenAPI value.
        :param pulumi.Input[builtins.str] description: Description of the REST API.
        :param pulumi.Input[builtins.bool] disable_execute_api_endpoint: Whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke
               your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that
               clients use a custom domain name to invoke your API, disable the default endpoint. Defaults to false.
        :param Mapping[str, pulumi.Input[Union['SwaggerGatewayResponseArgs', 'SwaggerGatewayResponseArgsDict']]] gateway_responses: Define custom gateway responses for the API. This can be used to properly enable
               CORS for Lambda Authorizers.
        :param 'RequestValidator' request_validator: Request Validator specifies the validator to use at the API level. Note method level validators
               override this.
        :param Sequence[Union['RouteArgs', 'RouteArgsDict']] routes: Routes to use to initialize the APIGateway.  These will be used to create the Swagger
               specification for the API.
               
               Either `swaggerString` or `routes` must be specified.
        :param pulumi.Input[builtins.str] stage_name: The stage name for your API. This will get added as a base path to your API url.
        :param pulumi.Input['pulumi_aws.s3.Bucket'] static_routes_bucket: Bucket to use for placing resources for static resources.  If not provided a default one will
               be created on your behalf if any `StaticRoute`s are provided.
        :param pulumi.Input[builtins.str] swagger_string: A Swagger specification already in string form to use to initialize the APIGateway.  Note
               that you must manually provide permission for any route targets to be invoked by API Gateway
               when using `swaggerString`.
               
               Either `swaggerString` or `routes` must be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: 'Map of tags to assign to the resource. If configured with a provider `defaultTags` configuration block present,
               tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RestAPIArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The RestAPI component offers a simple interface for creating a fully functional API Gateway REST API. The
        REST API can define any number of routes, each of which maps a path and HTTP method to one of (1) an event
        hander route that invokes a Lambda Function (2) a local path route which uploads local files into an S3 bucket
        and serves them or (3) an integration target such as an HTTP proxy or service integration.

        :param str resource_name: The name of the resource.
        :param RestAPIArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RestAPIArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key_source: Optional['APIKeySource'] = None,
                 binary_media_types: Optional[Sequence[pulumi.Input[builtins.str]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_execute_api_endpoint: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_responses: Optional[Mapping[str, pulumi.Input[Union['SwaggerGatewayResponseArgs', 'SwaggerGatewayResponseArgsDict']]]] = None,
                 request_validator: Optional['RequestValidator'] = None,
                 routes: Optional[Sequence[Union['RouteArgs', 'RouteArgsDict']]] = None,
                 stage_name: Optional[pulumi.Input[builtins.str]] = None,
                 static_routes_bucket: Optional[pulumi.Input['pulumi_aws.s3.Bucket']] = None,
                 swagger_string: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RestAPIArgs.__new__(RestAPIArgs)

            __props__.__dict__["api_key_source"] = api_key_source
            __props__.__dict__["binary_media_types"] = binary_media_types
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_execute_api_endpoint"] = disable_execute_api_endpoint
            __props__.__dict__["gateway_responses"] = gateway_responses
            __props__.__dict__["request_validator"] = request_validator
            __props__.__dict__["routes"] = routes
            __props__.__dict__["stage_name"] = stage_name
            __props__.__dict__["static_routes_bucket"] = static_routes_bucket
            __props__.__dict__["swagger_string"] = swagger_string
            __props__.__dict__["tags"] = tags
            __props__.__dict__["api"] = None
            __props__.__dict__["api_policy"] = None
            __props__.__dict__["deployment"] = None
            __props__.__dict__["stage"] = None
            __props__.__dict__["url"] = None
        super(RestAPI, __self__).__init__(
            'aws-apigateway:index:RestAPI',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def api(self) -> pulumi.Output['pulumi_aws.apigateway.RestApi']:
        """
        The underlying RestAPI resource.
        """
        return pulumi.get(self, "api")

    @property
    @pulumi.getter(name="apiPolicy")
    def api_policy(self) -> pulumi.Output[Optional['pulumi_aws.apigateway.RestApiPolicy']]:
        """
        The underlying RestAPIPolicy resource.
        """
        return pulumi.get(self, "api_policy")

    @property
    @pulumi.getter
    def deployment(self) -> pulumi.Output['pulumi_aws.apigateway.Deployment']:
        """
        The underlying Deployment resource.
        """
        return pulumi.get(self, "deployment")

    @property
    @pulumi.getter
    def stage(self) -> pulumi.Output['pulumi_aws.apigateway.Stage']:
        """
        The underlying Stage resource.
        """
        return pulumi.get(self, "stage")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        The URL where the Rest API is exposed.
        """
        return pulumi.get(self, "url")

