# -*- coding: utf-8 -*-

import numpy as np
from eko import constants

from ..partonic_channel import RSL
from . import partonic_channel as pc
from . import raw_cc


class Splus(pc.ChargedCurrentBase):
    """
    The convolution point simplifies to :math:`x` when m2=0,
    see :eqref:`6` of :cite:`kretzer-schienbein`.
    """

    def __init__(self, *args, m1sq):
        super().__init__(*args, m1sq=m1sq)
        self.lo = 1.0 - 1.0 / self.y

    def LO(self):
        return RSL.from_delta(self.lo)

    def NLO(self):
        norm = constants.CF
        lnomx = raw_cc.lnomx * norm * self.lo
        omx = raw_cc.omx(self.y) * norm * self.lo
        delta = raw_cc.f2sv(self.y) * norm

        def reg(z, _args):
            return norm * raw_cc.f2r(self.y, z) - (lnomx * np.log(1.0 - z) + omx) / (
                1.0 - z
            )

        return RSL.from_distr_coeffs(reg, (delta, omx, lnomx))
