"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sift.common.type.v1.resource_identifier_pb2
import sift.tags.v1.tags_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Campaign(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAMPAIGN_ID_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_BY_USER_ID_FIELD_NUMBER: builtins.int
    MODIFIED_BY_USER_ID_FIELD_NUMBER: builtins.int
    CREATED_DATE_FIELD_NUMBER: builtins.int
    MODIFIED_DATE_FIELD_NUMBER: builtins.int
    ARCHIVED_DATE_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    REPORTS_FIELD_NUMBER: builtins.int
    CREATED_FROM_CAMPAIGN_ID_FIELD_NUMBER: builtins.int
    campaign_id: builtins.str
    organization_id: builtins.str
    client_key: builtins.str
    name: builtins.str
    description: builtins.str
    created_by_user_id: builtins.str
    modified_by_user_id: builtins.str
    created_from_campaign_id: builtins.str
    """If this campaign was created by duplicating another campaign, that other campaign will be referenced here"""
    @property
    def created_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def modified_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def archived_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.tags.v1.tags_pb2.TagRef]: ...
    @property
    def reports(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CampaignReport]:
        """A campaign, at its core, is a list of reports"""

    def __init__(
        self,
        *,
        campaign_id: builtins.str = ...,
        organization_id: builtins.str = ...,
        client_key: builtins.str | None = ...,
        name: builtins.str = ...,
        description: builtins.str | None = ...,
        created_by_user_id: builtins.str = ...,
        modified_by_user_id: builtins.str = ...,
        created_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        archived_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        tags: collections.abc.Iterable[sift.tags.v1.tags_pb2.TagRef] | None = ...,
        reports: collections.abc.Iterable[global___CampaignReport] | None = ...,
        created_from_campaign_id: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_client_key", b"_client_key", "_created_from_campaign_id", b"_created_from_campaign_id", "_description", b"_description", "archived_date", b"archived_date", "client_key", b"client_key", "created_date", b"created_date", "created_from_campaign_id", b"created_from_campaign_id", "description", b"description", "modified_date", b"modified_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_client_key", b"_client_key", "_created_from_campaign_id", b"_created_from_campaign_id", "_description", b"_description", "archived_date", b"archived_date", "campaign_id", b"campaign_id", "client_key", b"client_key", "created_by_user_id", b"created_by_user_id", "created_date", b"created_date", "created_from_campaign_id", b"created_from_campaign_id", "description", b"description", "modified_by_user_id", b"modified_by_user_id", "modified_date", b"modified_date", "name", b"name", "organization_id", b"organization_id", "reports", b"reports", "tags", b"tags"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_client_key", b"_client_key"]) -> typing.Literal["client_key"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_created_from_campaign_id", b"_created_from_campaign_id"]) -> typing.Literal["created_from_campaign_id"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_description", b"_description"]) -> typing.Literal["description"] | None: ...

global___Campaign = Campaign

@typing.final
class CampaignReport(google.protobuf.message.Message):
    """A top-level summary of the report's rules is provided here so clients needn't aggregate this information themselves."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPORT_ID_FIELD_NUMBER: builtins.int
    REPORT_NAME_FIELD_NUMBER: builtins.int
    NUM_ANNOTATIONS_FIELD_NUMBER: builtins.int
    NUM_PASSED_RULES_FIELD_NUMBER: builtins.int
    NUM_ACCEPTED_RULES_FIELD_NUMBER: builtins.int
    NUM_FAILED_RULES_FIELD_NUMBER: builtins.int
    NUM_OPEN_RULES_FIELD_NUMBER: builtins.int
    report_id: builtins.str
    """Direct reference to the report. Set this on the client to tell the backend which report you're referring to."""
    report_name: builtins.str
    num_annotations: builtins.int
    """How many annotations exist under the report's various rules."""
    num_passed_rules: builtins.int
    """How many rules from this report were never triggered and generated NO annotations."""
    num_accepted_rules: builtins.int
    """How many rules have annotations which are ALL marked as accepted."""
    num_failed_rules: builtins.int
    """How many rules have ANY annotations which are marked as failed."""
    num_open_rules: builtins.int
    """How many rules have annotations of which SOME are marked as open and NONE are marked as failed."""
    def __init__(
        self,
        *,
        report_id: builtins.str = ...,
        report_name: builtins.str = ...,
        num_annotations: builtins.int = ...,
        num_passed_rules: builtins.int = ...,
        num_accepted_rules: builtins.int = ...,
        num_failed_rules: builtins.int = ...,
        num_open_rules: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["num_accepted_rules", b"num_accepted_rules", "num_annotations", b"num_annotations", "num_failed_rules", b"num_failed_rules", "num_open_rules", b"num_open_rules", "num_passed_rules", b"num_passed_rules", "report_id", b"report_id", "report_name", b"report_name"]) -> None: ...

global___CampaignReport = CampaignReport

@typing.final
class GetCampaignRequest(google.protobuf.message.Message):
    """The request for a call to `CampaignService_GetCampaign` to retrieve a campaign.
    If `campaign_id` is provided then all other arguments will be ignored.
    The `organization_id` argument is only required if using `client_key` and the user belongs to multiple organizations.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAMPAIGN_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    campaign_id: builtins.str
    client_key: builtins.str
    organization_id: builtins.str
    def __init__(
        self,
        *,
        campaign_id: builtins.str = ...,
        client_key: builtins.str = ...,
        organization_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["campaign_id", b"campaign_id", "client_key", b"client_key", "organization_id", b"organization_id"]) -> None: ...

global___GetCampaignRequest = GetCampaignRequest

@typing.final
class GetCampaignResponse(google.protobuf.message.Message):
    """The response of a call to `CampaignService_GetCampaign` to retrieve a campaign."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAMPAIGN_FIELD_NUMBER: builtins.int
    @property
    def campaign(self) -> global___Campaign: ...
    def __init__(
        self,
        *,
        campaign: global___Campaign | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["campaign", b"campaign"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["campaign", b"campaign"]) -> None: ...

global___GetCampaignResponse = GetCampaignResponse

@typing.final
class CreateCampaignRequest(google.protobuf.message.Message):
    """The request of a call to `CampaignService_CreateCampaign` to create a campaign."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    CREATE_FROM_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The descriptive display name of the created campaign"""
    description: builtins.str
    """A custom description for the campaign"""
    organization_id: builtins.str
    """`organization_id` is only required if your user belongs to multiple organizations"""
    client_key: builtins.str
    """User-specified unique identifier."""
    @property
    def tags(self) -> sift.common.type.v1.resource_identifier_pb2.NamedResources:
        """Tags to be applied to the new campaign"""

    @property
    def create_from(self) -> global___CreateCampaignFrom:
        """Initialize the campaign, or leave this field empty to create an empty campaign to be populated later"""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str | None = ...,
        tags: sift.common.type.v1.resource_identifier_pb2.NamedResources | None = ...,
        organization_id: builtins.str = ...,
        client_key: builtins.str | None = ...,
        create_from: global___CreateCampaignFrom | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_client_key", b"_client_key", "_description", b"_description", "client_key", b"client_key", "create_from", b"create_from", "description", b"description", "tags", b"tags"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_client_key", b"_client_key", "_description", b"_description", "client_key", b"client_key", "create_from", b"create_from", "description", b"description", "name", b"name", "organization_id", b"organization_id", "tags", b"tags"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_client_key", b"_client_key"]) -> typing.Literal["client_key"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_description", b"_description"]) -> typing.Literal["description"] | None: ...

global___CreateCampaignRequest = CreateCampaignRequest

@typing.final
class CreateCampaignFrom(google.protobuf.message.Message):
    """Campaigns can be created from a few different sources."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPORTS_FIELD_NUMBER: builtins.int
    RUNS_FIELD_NUMBER: builtins.int
    OTHER_CAMPAIGN_FIELD_NUMBER: builtins.int
    @property
    def reports(self) -> sift.common.type.v1.resource_identifier_pb2.ResourceIdentifiers:
        """Create a campaign directly from a set of reports"""

    @property
    def runs(self) -> sift.common.type.v1.resource_identifier_pb2.ResourceIdentifiers:
        """Create a campaign from a set of runs by collecting all the reports generated by those runs"""

    @property
    def other_campaign(self) -> sift.common.type.v1.resource_identifier_pb2.ResourceIdentifier:
        """Duplicate another campaign"""

    def __init__(
        self,
        *,
        reports: sift.common.type.v1.resource_identifier_pb2.ResourceIdentifiers | None = ...,
        runs: sift.common.type.v1.resource_identifier_pb2.ResourceIdentifiers | None = ...,
        other_campaign: sift.common.type.v1.resource_identifier_pb2.ResourceIdentifier | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["initializer", b"initializer", "other_campaign", b"other_campaign", "reports", b"reports", "runs", b"runs"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["initializer", b"initializer", "other_campaign", b"other_campaign", "reports", b"reports", "runs", b"runs"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["initializer", b"initializer"]) -> typing.Literal["reports", "runs", "other_campaign"] | None: ...

global___CreateCampaignFrom = CreateCampaignFrom

@typing.final
class CreateCampaignResponse(google.protobuf.message.Message):
    """The response of a call to `CampaignService_CreateCampaign` to create a campaign."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAMPAIGN_FIELD_NUMBER: builtins.int
    @property
    def campaign(self) -> global___Campaign: ...
    def __init__(
        self,
        *,
        campaign: global___Campaign | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["campaign", b"campaign"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["campaign", b"campaign"]) -> None: ...

global___CreateCampaignResponse = CreateCampaignResponse

@typing.final
class ListCampaignsRequest(google.protobuf.message.Message):
    """The request for a call to `CampaignService_ListCampaigns` to retrieve campaigns."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    INCLUDE_ARCHIVED_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of campaigns to return. The service may return fewer than this value.
    If unspecified, at most 50 campaigns will be returned. The maximum value is 1000; values above
    1000 will be coerced to 1000. Optional.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListCampaigns` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListCampaigns` must match
    the call that provided the page token. Optional.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are:
    `created_by_user_id`, `tag_id`, `tag_name`, `report_id`, `report_name`, `campaign_id`, `client_key`, `description`, `run_id`, and `name`.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to this definition. Optional.
    """
    organization_id: builtins.str
    """This field is only required if your user belongs to multiple organizations."""
    include_archived: builtins.bool
    """If `true` then archived campaigns will be included in the query. Defaults to `false`."""
    order_by: builtins.str
    """How to order the retrieved campaigns. Formatted as a comma-separated string i.e. "FIELD_NAME[ desc],...".
    Available fields to order_by are `created_date` and `modified_date`.
    If left empty, items are ordered by `created_date` in ascending order (oldest-first).
    For more information about the format of this field, read [this](https://google.aip.dev/132#ordering)
    Example: "created_date desc,modified_date"
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        organization_id: builtins.str = ...,
        include_archived: builtins.bool = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "include_archived", b"include_archived", "order_by", b"order_by", "organization_id", b"organization_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListCampaignsRequest = ListCampaignsRequest

@typing.final
class ListCampaignsResponse(google.protobuf.message.Message):
    """The response of a call to `CampaignService_ListCampaignsResponse`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAMPAIGNS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    @property
    def campaigns(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Campaign]: ...
    def __init__(
        self,
        *,
        campaigns: collections.abc.Iterable[global___Campaign] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["campaigns", b"campaigns", "next_page_token", b"next_page_token"]) -> None: ...

global___ListCampaignsResponse = ListCampaignsResponse

@typing.final
class UpdateCampaignRequest(google.protobuf.message.Message):
    """The request for a call to `CampaignService_UpdateCampaign` to update a campaign. When updating
    tags or rules, the update will perform a full replace. Additionally, when updating rules, only the rule ID or the rule client key
    is required, but it is okay to provide both. If some rules contain only client keys and others only rule IDs, they will be consolidated.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAMPAIGN_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def campaign(self) -> global___Campaign:
        """The campaign to update."""

    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The list of fields to be updated. The fields available to be updated are `name`, `archived_date`, `description`, `tags`, and `reports`."""

    def __init__(
        self,
        *,
        campaign: global___Campaign | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["campaign", b"campaign", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["campaign", b"campaign", "update_mask", b"update_mask"]) -> None: ...

global___UpdateCampaignRequest = UpdateCampaignRequest

@typing.final
class UpdateCampaignResponse(google.protobuf.message.Message):
    """The response of a call to `CampaignService_UpdateCampaign`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CAMPAIGN_FIELD_NUMBER: builtins.int
    @property
    def campaign(self) -> global___Campaign: ...
    def __init__(
        self,
        *,
        campaign: global___Campaign | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["campaign", b"campaign"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["campaign", b"campaign"]) -> None: ...

global___UpdateCampaignResponse = UpdateCampaignResponse
