"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
*
These are message and field options that can be used when ingesting protobuf messages. These can be applied to protobuf fields
and messages before compiling and uploading the descriptor set.
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.descriptor_pb2
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.internal.extension_dict
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _TagSourceType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TagSourceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TagSourceType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DESCENDANT_SOURCES: _TagSourceType.ValueType  # 0
    """Tags can be sourced from descendant fields"""
    SIBLING_SOURCES: _TagSourceType.ValueType  # 1
    """Tags can be sourced from sibling fields"""
    DESCENDANT_AND_SIBLING_SOURCES: _TagSourceType.ValueType  # 2
    """Tags can be sourced from both descendant and sibling fields"""

class TagSourceType(_TagSourceType, metaclass=_TagSourceTypeEnumTypeWrapper):
    """Enum for different types of tag sources"""

DESCENDANT_SOURCES: TagSourceType.ValueType  # 0
"""Tags can be sourced from descendant fields"""
SIBLING_SOURCES: TagSourceType.ValueType  # 1
"""Tags can be sourced from sibling fields"""
DESCENDANT_AND_SIBLING_SOURCES: TagSourceType.ValueType  # 2
"""Tags can be sourced from both descendant and sibling fields"""
global___TagSourceType = TagSourceType

class _TagTargetType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TagTargetTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TagTargetType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ANCESTOR_TARGETS: _TagTargetType.ValueType  # 0
    """Tags can be applied to ancestor fields"""
    SIBLING_TARGETS: _TagTargetType.ValueType  # 1
    """Tags can be applied to sibling fields"""
    ANCESTOR_AND_SIBLING_TARGETS: _TagTargetType.ValueType  # 2
    """Tags can be applied to both ancestor and sibling fields"""

class TagTargetType(_TagTargetType, metaclass=_TagTargetTypeEnumTypeWrapper):
    """Enum for different types of tag targets"""

ANCESTOR_TARGETS: TagTargetType.ValueType  # 0
"""Tags can be applied to ancestor fields"""
SIBLING_TARGETS: TagTargetType.ValueType  # 1
"""Tags can be applied to sibling fields"""
ANCESTOR_AND_SIBLING_TARGETS: TagTargetType.ValueType  # 2
"""Tags can be applied to both ancestor and sibling fields"""
global___TagTargetType = TagTargetType

class _MapKeyOverrideType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MapKeyOverrideTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MapKeyOverrideType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    MAP_KEY_OVERRIDE_UNSPECIFIED: _MapKeyOverrideType.ValueType  # 0
    """Default value, will be ignored"""
    MAP_KEY_OVERRIDE_TARGET: _MapKeyOverrideType.ValueType  # 1
    """Map key will be replaced on fields with this type specified"""
    MAP_KEY_OVERRIDE_SOURCE: _MapKeyOverrideType.ValueType  # 2
    """Map key will be sourced from fields with this type specified"""
    MAP_KEY_OVERRIDE_REMOVE_KEY: _MapKeyOverrideType.ValueType  # 3
    """Map key will be removed from fields with this type specified"""
    MAP_KEY_OVERRIDE_ENUM: _MapKeyOverrideType.ValueType  # 4
    """Map key will be replaced with the enum name specified by the display_override_enum value on the field"""

class MapKeyOverrideType(_MapKeyOverrideType, metaclass=_MapKeyOverrideTypeEnumTypeWrapper):
    """Enum for the source and destination of a map key override"""

MAP_KEY_OVERRIDE_UNSPECIFIED: MapKeyOverrideType.ValueType  # 0
"""Default value, will be ignored"""
MAP_KEY_OVERRIDE_TARGET: MapKeyOverrideType.ValueType  # 1
"""Map key will be replaced on fields with this type specified"""
MAP_KEY_OVERRIDE_SOURCE: MapKeyOverrideType.ValueType  # 2
"""Map key will be sourced from fields with this type specified"""
MAP_KEY_OVERRIDE_REMOVE_KEY: MapKeyOverrideType.ValueType  # 3
"""Map key will be removed from fields with this type specified"""
MAP_KEY_OVERRIDE_ENUM: MapKeyOverrideType.ValueType  # 4
"""Map key will be replaced with the enum name specified by the display_override_enum value on the field"""
global___MapKeyOverrideType = MapKeyOverrideType

class _ArrayIndexOverrideType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ArrayIndexOverrideTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ArrayIndexOverrideType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ARRAY_INDEX_OVERRIDE_UNSPECIFIED: _ArrayIndexOverrideType.ValueType  # 0
    """Default value, will be ignored"""
    ARRAY_INDEX_OVERRIDE_TARGET: _ArrayIndexOverrideType.ValueType  # 1
    """Array Index will be replaced on fields with this type specified"""
    ARRAY_INDEX_OVERRIDE_SOURCE: _ArrayIndexOverrideType.ValueType  # 2
    """Array Index  will be sourced from fields with this type specified"""
    ARRAY_INDEX_OVERRIDE_REMOVE_INDEX: _ArrayIndexOverrideType.ValueType  # 3
    """Array Index will be removed from fields with this type specified"""
    ARRAY_INDEX_OVERRIDE_ENUM: _ArrayIndexOverrideType.ValueType  # 4
    """Array Index will be replaced with the enum name specified by the display_override_enum value on the field"""

class ArrayIndexOverrideType(_ArrayIndexOverrideType, metaclass=_ArrayIndexOverrideTypeEnumTypeWrapper):
    """Enum for the source and destination of an array index override"""

ARRAY_INDEX_OVERRIDE_UNSPECIFIED: ArrayIndexOverrideType.ValueType  # 0
"""Default value, will be ignored"""
ARRAY_INDEX_OVERRIDE_TARGET: ArrayIndexOverrideType.ValueType  # 1
"""Array Index will be replaced on fields with this type specified"""
ARRAY_INDEX_OVERRIDE_SOURCE: ArrayIndexOverrideType.ValueType  # 2
"""Array Index  will be sourced from fields with this type specified"""
ARRAY_INDEX_OVERRIDE_REMOVE_INDEX: ArrayIndexOverrideType.ValueType  # 3
"""Array Index will be removed from fields with this type specified"""
ARRAY_INDEX_OVERRIDE_ENUM: ArrayIndexOverrideType.ValueType  # 4
"""Array Index will be replaced with the enum name specified by the display_override_enum value on the field"""
global___ArrayIndexOverrideType = ArrayIndexOverrideType

class _BytesDecodingType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BytesDecodingTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BytesDecodingType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BYTES_DECODING_TYPE_UNSPECIFIED: _BytesDecodingType.ValueType  # 0
    """Default value, will be ignored"""
    BYTES_DECODING_TYPE_UTF8: _BytesDecodingType.ValueType  # 1
    """Decode bytes as UTF-8"""

class BytesDecodingType(_BytesDecodingType, metaclass=_BytesDecodingTypeEnumTypeWrapper):
    """Enum for how to decode bytes fields"""

BYTES_DECODING_TYPE_UNSPECIFIED: BytesDecodingType.ValueType  # 0
"""Default value, will be ignored"""
BYTES_DECODING_TYPE_UTF8: BytesDecodingType.ValueType  # 1
"""Decode bytes as UTF-8"""
global___BytesDecodingType = BytesDecodingType

@typing.final
class TagTarget(google.protobuf.message.Message):
    """Message representing a tag target"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALLOWED_TAG_SOURCE_FIELD_NUMBER: builtins.int
    allowed_tag_source: global___TagSourceType.ValueType
    """Setting this value indicates the allowed sources for tag values.
    If set to SIBLING_SOURCES, tag_sources from descendant proto fields will not be applied.
    If set to DESCENDANT_SOURCES, sibling tag_sources will not be applied.
    """
    def __init__(
        self,
        *,
        allowed_tag_source: global___TagSourceType.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_allowed_tag_source", b"_allowed_tag_source", "allowed_tag_source", b"allowed_tag_source"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_allowed_tag_source", b"_allowed_tag_source", "allowed_tag_source", b"allowed_tag_source"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["_allowed_tag_source", b"_allowed_tag_source"]) -> typing.Literal["allowed_tag_source"] | None: ...

global___TagTarget = TagTarget

@typing.final
class TagSource(google.protobuf.message.Message):
    """Message representing a tag source
    Setting either of these values indicates that the field is a tag source
    and the value can be applied to allowed tag_targets.
    Tag sources apply only to the nearest ancestor (if any) and do not propagate
    to ancestors that are lists or maps or beyond.
    They can apply to both ancestor and sibling fields.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALLOWED_TAG_TARGET_FIELD_NUMBER: builtins.int
    TAG_NAME_FIELD_NUMBER: builtins.int
    allowed_tag_target: global___TagTargetType.ValueType
    """Indicates which tag_target relationships are allowed to have this tag.
    If set to ANCESTOR_TARGETS, sibling tag_targets will not have this value.
    If set to SIBLING_TARGETS, it will not apply to tag_targets that are ancestors.
    """
    tag_name: builtins.str
    """The name of the tag. It defaults to the field name but can be overridden here."""
    def __init__(
        self,
        *,
        allowed_tag_target: global___TagTargetType.ValueType | None = ...,
        tag_name: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_allowed_tag_target", b"_allowed_tag_target", "_tag_name", b"_tag_name", "allowed_tag_target", b"allowed_tag_target", "tag_name", b"tag_name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_allowed_tag_target", b"_allowed_tag_target", "_tag_name", b"_tag_name", "allowed_tag_target", b"allowed_tag_target", "tag_name", b"tag_name"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_allowed_tag_target", b"_allowed_tag_target"]) -> typing.Literal["allowed_tag_target"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_tag_name", b"_tag_name"]) -> typing.Literal["tag_name"] | None: ...

global___TagSource = TagSource

UNITS_FIELD_NUMBER: builtins.int
DESCRIPTION_FIELD_NUMBER: builtins.int
TAG_TARGET_FIELD_NUMBER: builtins.int
TAG_SOURCE_FIELD_NUMBER: builtins.int
MAP_KEY_OVERRIDE_TYPE_FIELD_NUMBER: builtins.int
BYTES_DECODING_TYPE_FIELD_NUMBER: builtins.int
IGNORE_FIELD_FIELD_NUMBER: builtins.int
DISPLAY_OVERRIDE_ENUM_FIELD_NUMBER: builtins.int
ARRAY_INDEX_OVERRIDE_TYPE_FIELD_NUMBER: builtins.int
MESSAGE_IS_TAG_TARGET_FIELD_NUMBER: builtins.int
units: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.FieldOptions, builtins.str]
"""Adding the units FieldOption to a field sets the units displayed on the channel when charted"""
description: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.FieldOptions, builtins.str]
"""Adding the description FieldOption to a field sets the description for the channel in the chart"""
tag_target: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.FieldOptions, global___TagTarget]
"""Adding the tag_target FieldOption indicates that this field can have tag values appended
to the field name. The tag values will come from descendant or sibling fields in the proto path
that have the tag_source FieldOption applied.
"""
tag_source: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.FieldOptions, global___TagSource]
"""Adding the tag_source FieldOption allows the value of the annotated field to be added to
applicable fields that are annotated with tag_target. These fields can be either ancestor fields
or sibling fields, depending on their respective fields' allowed_tag_source and allowed_tag_target values.
"""
map_key_override_type: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.FieldOptions, global___MapKeyOverrideType.ValueType]
"""Adding the map_key_override_type FieldOption to a map type field with the `MAP_KEY_OVERRIDE_TARGET`
type indicates that this field can have the map key replaced in the display name by a descendant field.
Adding this to a primitive type field with the `MAP_KEY_OVERRIDE_SOURCE` indicates that this field
is the replacement value for an ancestor map's key display. Note that sources within arrays will not apply to
ancestor maps that contain those arrays. This tag will be ignored if the field is not a map or if there
are no map_key_override_sources that apply. If multiple apply then the first override will be applied and an
error will be logged.
"""
bytes_decoding_type: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.FieldOptions, global___BytesDecodingType.ValueType]
"""Adding the bytes_decoding_type FieldOption to a bytes field indicates how the bytes should be decoded
If not set, the bytes fields will be ignored and an error will be logged.
"""
ignore_field: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.FieldOptions, builtins.bool]
"""Adding the ignore_field FieldOption with a value of true will cause the field to be ignored when ingesting the proto"""
display_override_enum: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.FieldOptions, builtins.str]
"""Adding the display_override_enum FieldOption to a field with that has map_key_override_type set to MAP_KEY_OVERRIDE_ENUM
will look up the enum value in the enum referenced by this field and use that to look up the enum value by number and replace it
with the enum value name.
"""
array_index_override_type: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.FieldOptions, global___ArrayIndexOverrideType.ValueType]
"""Adding the array_index_override_type FieldOption to a repeated type field with the `ARRAY_INDEX_OVERRIDE_TARGET`
type indicates that this field can have the array index replaced in the display name by a descendant field.
Adding this to a primitive type field with the `ARRAY_INDEX_OVERRIDE_SOURCE` type indicates that this field
is the replacement value for an ancestor array's index display. Note that sources within nested arrays will not apply to
ancestor arrays that contain those arrays. This tag will be ignored if the field is not an array or if there
are no `ARRAY_INDEX_OVERRIDE_SOURCE` fields that apply. If multiple apply then the first override will be applied and an
error will be logged.
"""
message_is_tag_target: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.MessageOptions, builtins.bool]
"""The message_is_tag_target option indicates that the message will allow its fields to have tags
added to them. This option only accepts descendant sources.
It can be helpful to annotate top-level messages with tags from deeper in the proto path.
"""
