# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .inconclusive import Inconclusive
from .raw_ecg_sample import RawEcgSample


class EcgReading(UncheckedBaseModel):
    start_timestamp: typing.Optional[str] = pydantic.Field(default=None)
    """
    Time with which the record is associated, in ISO8601 format with microsecond precision. TimeZone info will be provided whenever possible. If absent, the time corresponds to the user's local time.
    """

    avg_hr_bpm: typing.Optional[float] = pydantic.Field(default=None)
    """
    User's average heart rate throughout the day, in beats per minute (bpm).
    """

    afib_classification: typing.Optional[Inconclusive] = pydantic.Field(default=None)
    """
    User's afib classification throught the day.
    """

    raw_signal: typing.Optional[typing.List[RawEcgSample]] = pydantic.Field(default=None)
    """
    List of raw ECG readings sampled through the day.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
