# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .daily_pattern_sample import DailyPatternSample
from .glucose_data_sample import GlucoseDataSample


class GlucoseData(UncheckedBaseModel):
    blood_glucose_samples: typing.Optional[typing.List[GlucoseDataSample]] = pydantic.Field(default=None)
    """
    List of blood glucose readings sampled throughout the day.
    """

    detailed_blood_glucose_samples: typing.Optional[typing.List[GlucoseDataSample]] = pydantic.Field(default=None)
    """
    List of blood glucose readings sampled throughout the day - this represents additional data points, potentially at higher frequency from the ones in blood_glucose_samples, which may come at a cost of reduced accuracy.
    """

    day_avg_blood_glucose_mg_per_d_l: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="day_avg_blood_glucose_mg_per_dL")
    ] = pydantic.Field(default=None)
    """
    User's average glucose level throughout the day.
    """

    gmi: typing.Optional[float] = pydantic.Field(default=None)
    """
    GMI (Glucose Management Indicator) is a metric derived from continuous glucose monitoring (CGM) data that estimates average glucose levels to help guide diabetes management, without implying a precise match to laboratory A1C.
    """

    time_in_range: typing.Optional[float] = pydantic.Field(default=None)
    """
    Time that the user's glucose is within acceptable range (not hyper or hypoglycemic).
    """

    sensor_usage: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of data points recorded by the sensor throughout the day.
    """

    daily_patterns: typing.Optional[typing.List[DailyPatternSample]] = pydantic.Field(default=None)
    """
    List of glucose percentile samples throughout the day.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
